/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity;

import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelSquid;
import net.minecraft.client.model.ModelVillager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.config.Configuration;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.client.model.ModelGoron;
import zeldaswordskills.client.render.RenderNothing;
import zeldaswordskills.client.render.entity.RenderCustomArrow;
import zeldaswordskills.client.render.entity.RenderEntityBomb;
import zeldaswordskills.client.render.entity.RenderEntityBoomerang;
import zeldaswordskills.client.render.entity.RenderEntityChu;
import zeldaswordskills.client.render.entity.RenderEntityFairy;
import zeldaswordskills.client.render.entity.RenderEntityHookShot;
import zeldaswordskills.client.render.entity.RenderEntityJar;
import zeldaswordskills.client.render.entity.RenderEntityKeese;
import zeldaswordskills.client.render.entity.RenderEntityMagicSpell;
import zeldaswordskills.client.render.entity.RenderEntitySwordBeam;
import zeldaswordskills.client.render.entity.RenderGenericLiving;
import zeldaswordskills.client.render.entity.RenderOctorok;
import zeldaswordskills.entity.CustomEntityList;
import zeldaswordskills.entity.EntityChu;
import zeldaswordskills.entity.EntityFairy;
import zeldaswordskills.entity.EntityGoron;
import zeldaswordskills.entity.EntityKeese;
import zeldaswordskills.entity.EntityMaskTrader;
import zeldaswordskills.entity.EntityOctorok;
import zeldaswordskills.entity.projectile.EntityArrowBomb;
import zeldaswordskills.entity.projectile.EntityArrowCustom;
import zeldaswordskills.entity.projectile.EntityArrowElemental;
import zeldaswordskills.entity.projectile.EntityBomb;
import zeldaswordskills.entity.projectile.EntityBoomerang;
import zeldaswordskills.entity.projectile.EntityCeramicJar;
import zeldaswordskills.entity.projectile.EntityCyclone;
import zeldaswordskills.entity.projectile.EntityHookShot;
import zeldaswordskills.entity.projectile.EntityLeapingBlow;
import zeldaswordskills.entity.projectile.EntityMagicSpell;
import zeldaswordskills.entity.projectile.EntitySeedShot;
import zeldaswordskills.entity.projectile.EntitySwordBeam;
import zeldaswordskills.entity.projectile.EntityThrowingRock;
import zeldaswordskills.item.ZSSItems;

public class ZSSEntities {
    private static int spawnChu;
    private static int spawnFairy;
    private static int spawnGoron;
    private static int spawnKeese;
    private static int spawnOctorok;

    public static int getGoronRatio() {
        return spawnGoron;
    }

    public static void init(Configuration config) {
        spawnChu = config.get("Spawn Rates", "Chuchu spawn rate (0 to disable)[0+]", 1).getInt();
        spawnFairy = config.get("Spawn Rates", "Fairy (wild) spawn rate (0 to disable)[0+]", 1).getInt();
        spawnGoron = config.get("Spawn Rates", "Goron spawn rate, as a ratio of regular villagers to Gorons (0 to disable)[0+]", 4).getInt();
        spawnKeese = config.get("Spawn Rates", "Keese spawn rate (0 to disable)[0+]", 1).getInt();
        spawnOctorok = config.get("Spawn Rates", "Octorok spawn rate (0 to disable)[0+]", 8).getInt();
    }

    public static void load() {
        ZSSEntities.registerEntities();
        ZSSEntities.addSpawns();
    }

    private static void registerEntities() {
        int modEntityIndex = 0;
        EntityRegistry.registerModEntity(EntityLeapingBlow.class, (String)"leapingblow", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntitySwordBeam.class, (String)"swordbeam", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityBomb.class, (String)"bomb", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityBoomerang.class, (String)"boomerang", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityCyclone.class, (String)"cyclone", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityCeramicJar.class, (String)"jar", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityHookShot.class, (String)"hookshot", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntitySeedShot.class, (String)"seedshot", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityThrowingRock.class, (String)"rock", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityArrowBomb.class, (String)"arrowbomb", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)20, (boolean)true);
        EntityRegistry.registerModEntity(EntityArrowCustom.class, (String)"arrowcustom", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)20, (boolean)true);
        EntityRegistry.registerModEntity(EntityArrowElemental.class, (String)"arrowelemental", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)20, (boolean)true);
        EntityRegistry.registerModEntity(EntityMagicSpell.class, (String)"magicspell", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)10, (boolean)true);
        ZSSEntities.registerEntity(EntityFairy.class, "fairy", ++modEntityIndex, 11403055, 0xFFFF00);
        EntityRegistry.registerModEntity(EntityChu.class, (String)"chu", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)10, (boolean)true);
        CustomEntityList.addMapping(EntityChu.class, "chu", 32768, 14423100, 32768, 60928, 32768, 3825613, 32768, 0xFFFF00);
        EntityRegistry.registerModEntity(EntityKeese.class, (String)"keese", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)10, (boolean)true);
        CustomEntityList.addMapping(EntityKeese.class, "keese", 0, 0x555555, 0, 16729344, 0, 4251856, 0, 16766720, 0, 0x800080);
        EntityRegistry.registerModEntity(EntityOctorok.class, (String)"octorok", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)64, (int)10, (boolean)true);
        CustomEntityList.addMapping(EntityOctorok.class, "octorok", 6824587, 12211667, 6824587, 0xFF00FF);
        ZSSEntities.registerEntity(EntityGoron.class, "goron", ++modEntityIndex, 12092939, 9132544);
        EntityRegistry.registerModEntity(EntityMaskTrader.class, (String)"npc.mask_trader", (int)(++modEntityIndex), (Object)ZSSMain.instance, (int)80, (int)3, (boolean)false);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityArrowCustom.class, (Render)new RenderCustomArrow());
        RenderingRegistry.registerEntityRenderingHandler(EntityBomb.class, (Render)new RenderEntityBomb());
        RenderingRegistry.registerEntityRenderingHandler(EntityBoomerang.class, (Render)new RenderEntityBoomerang());
        RenderingRegistry.registerEntityRenderingHandler(EntityCeramicJar.class, (Render)new RenderEntityJar());
        RenderingRegistry.registerEntityRenderingHandler(EntityChu.class, (Render)new RenderEntityChu());
        RenderingRegistry.registerEntityRenderingHandler(EntityCyclone.class, (Render)new RenderNothing());
        RenderingRegistry.registerEntityRenderingHandler(EntityFairy.class, (Render)new RenderEntityFairy());
        RenderingRegistry.registerEntityRenderingHandler(EntityGoron.class, (Render)new RenderGenericLiving(new ModelGoron(), 0.5f, 1.5f, "zeldaswordskills:textures/entity/goron.png"));
        RenderingRegistry.registerEntityRenderingHandler(EntityKeese.class, (Render)new RenderEntityKeese());
        RenderingRegistry.registerEntityRenderingHandler(EntityHookShot.class, (Render)new RenderEntityHookShot());
        RenderingRegistry.registerEntityRenderingHandler(EntityLeapingBlow.class, (Render)new RenderNothing());
        RenderingRegistry.registerEntityRenderingHandler(EntityMagicSpell.class, (Render)new RenderEntityMagicSpell());
        RenderingRegistry.registerEntityRenderingHandler(EntityMaskTrader.class, (Render)new RenderGenericLiving((ModelBase)new ModelVillager(0.0f), 0.5f, 1.0f, "textures/entity/villager/villager.png"));
        RenderingRegistry.registerEntityRenderingHandler(EntityOctorok.class, (Render)new RenderOctorok((ModelBase)new ModelSquid(), 0.7f));
        RenderingRegistry.registerEntityRenderingHandler(EntitySeedShot.class, (Render)new RenderSnowball(ZSSItems.dekuNut));
        RenderingRegistry.registerEntityRenderingHandler(EntitySwordBeam.class, (Render)new RenderEntitySwordBeam());
        RenderingRegistry.registerEntityRenderingHandler(EntityThrowingRock.class, (Render)new RenderSnowball(ZSSItems.throwingRock));
    }

    public static void registerEntity(Class entityClass, String name, int modEntityIndex, int primaryColor, int secondaryColor) {
        EntityRegistry.registerModEntity((Class)entityClass, (String)name, (int)modEntityIndex, (Object)ZSSMain.instance, (int)80, (int)3, (boolean)false);
        CustomEntityList.addMapping(entityClass, name, primaryColor, secondaryColor);
    }

    private static void addSpawns() {
        if (spawnFairy > 0) {
            EntityRegistry.addSpawn(EntityFairy.class, (int)spawnFairy, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.ambient, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76780_h});
        }
        for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            if (biome == null) continue;
            if (spawnChu > 0) {
                EntityRegistry.addSpawn(EntityChu.class, (int)spawnChu, (int)4, (int)4, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{biome});
            }
            if (spawnKeese <= 0) continue;
            EntityRegistry.addSpawn(EntityKeese.class, (int)spawnKeese, (int)4, (int)4, (EnumCreatureType)EnumCreatureType.ambient, (BiomeGenBase[])new BiomeGenBase[]{biome});
        }
        if (spawnOctorok > 0) {
            EntityRegistry.addSpawn(EntityOctorok.class, (int)spawnOctorok, (int)2, (int)4, (EnumCreatureType)EnumCreatureType.waterCreature, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76771_b, BiomeGenBase.field_76781_i, BiomeGenBase.field_76780_h});
        }
    }
}

