/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity;

import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.entity.IEntityVariant;
import zeldaswordskills.entity.projectile.EntityBomb;
import zeldaswordskills.entity.projectile.EntityMobThrowable;
import zeldaswordskills.entity.projectile.EntityThrowingRock;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.TargetUtils;

public class EntityOctorok
extends EntityWaterMob
implements IMob,
IEntityVariant {
    private static final int OCTOROK_TYPE_INDEX = 13;
    public float squidPitch;
    public float prevSquidPitch;
    public float squidYaw;
    public float prevSquidYaw;
    public float squidRotation;
    public float prevSquidRotation;
    public float tentacleAngle;
    public float prevTentacleAngle;
    private float randomMotionSpeed;
    private float rotationVelocity;
    private float field_70871_bB;
    private float randomMotionVecX;
    private float randomMotionVecY;
    private float randomMotionVecZ;

    public EntityOctorok(World world) {
        super(world);
        this.field_70728_aV = 5;
        this.func_70105_a(0.95f, 0.95f);
        this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(13, (Object)((byte)(this.field_70146_Z.nextInt(5) == 0 ? 1 : 0)));
    }

    public int getType() {
        return this.field_70180_af.func_75683_a(13);
    }

    @Override
    public void setType(int type) {
        this.field_70180_af.func_75692_b(13, (Object)((byte)(type % 2)));
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70686_a(Class clazz) {
        return super.func_70686_a(clazz) && clazz != EntityOctorok.class;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.prevSquidPitch = this.squidPitch;
        this.prevSquidYaw = this.squidYaw;
        this.prevSquidRotation = this.squidRotation;
        this.prevTentacleAngle = this.tentacleAngle;
        this.squidRotation += this.rotationVelocity;
        if (this.squidRotation > (float)Math.PI * 2) {
            this.squidRotation -= (float)Math.PI * 2;
            if (this.field_70146_Z.nextInt(10) == 0) {
                this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
            }
        }
        if (this.func_70090_H()) {
            float f;
            if (this.squidRotation < (float)Math.PI) {
                f = this.squidRotation / (float)Math.PI;
                this.tentacleAngle = MathHelper.func_76126_a((float)(f * f * (float)Math.PI)) * (float)Math.PI * 0.25f;
                if ((double)f > 0.75) {
                    this.randomMotionSpeed = 1.0f;
                    this.field_70871_bB = 1.0f;
                } else {
                    this.field_70871_bB *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                this.randomMotionSpeed *= 0.9f;
                this.field_70871_bB *= 0.99f;
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70789_a != null) {
                    TargetUtils.setEntityHeading((Entity)this, this.randomMotionVecX, this.randomMotionVecY, this.randomMotionVecZ, 0.25f, 1.0f, false);
                    this.func_70625_a(this.field_70789_a, 30.0f, 120.0f);
                } else {
                    this.field_70159_w = this.randomMotionVecX * this.randomMotionSpeed;
                    this.field_70181_x = this.randomMotionVecY * this.randomMotionSpeed;
                    this.field_70179_y = this.randomMotionVecZ * this.randomMotionSpeed;
                }
            }
            this.field_70761_aq += (-((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI - this.field_70761_aq) * 0.1f;
            this.field_70177_z = this.field_70761_aq;
            this.squidYaw += (float)Math.PI * this.field_70871_bB * 1.5f;
            f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.squidPitch += (-((float)Math.atan2(f, this.field_70181_x)) * 180.0f / (float)Math.PI - this.squidPitch) * 0.1f;
        } else {
            this.tentacleAngle = MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)this.squidRotation)) * (float)Math.PI * 0.25f;
            this.squidPitch = (float)((double)this.squidPitch + (double)(-90.0f - this.squidPitch) * 0.02);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70159_w = 0.0;
                this.field_70181_x -= 0.08;
                this.field_70181_x *= (double)0.98f;
                this.field_70179_y = 0.0;
            }
        }
    }

    public void func_70612_e(float dx, float dz) {
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    protected void func_70626_be() {
        float distance = 0.0f;
        ++this.field_70708_bq;
        if (this.field_70789_a == null) {
            this.field_70789_a = this.func_70782_k();
        } else if (this.field_70789_a.func_70089_S() && this.func_70686_a(this.field_70789_a.getClass())) {
            distance = this.field_70789_a.func_70032_d((Entity)this);
            if (distance > 16.0f) {
                this.field_70789_a = null;
            } else if (this.func_70685_l(this.field_70789_a)) {
                this.func_70785_a(this.field_70789_a, distance);
            }
        } else {
            this.field_70789_a = null;
        }
        if (this.field_70708_bq > 100) {
            this.randomMotionVecZ = 0.0f;
            this.randomMotionVecY = 0.0f;
            this.randomMotionVecX = 0.0f;
        } else if (this.field_70146_Z.nextInt(this.field_70789_a != null ? 25 : 50) == 0 || !this.field_70171_ac || this.randomMotionVecX == 0.0f && this.randomMotionVecY == 0.0f && this.randomMotionVecZ == 0.0f) {
            if (this.field_70789_a != null && distance > 5.0f) {
                this.randomMotionVecX = (float)(this.field_70789_a.field_70165_t - this.field_70165_t) * 0.015f;
                this.randomMotionVecY = (float)(1.0 + this.field_70789_a.field_70163_u - this.field_70163_u) * 0.015f;
                this.randomMotionVecZ = (float)(this.field_70789_a.field_70161_v - this.field_70161_v) * 0.015f;
            } else {
                float f = this.field_70146_Z.nextFloat() * (float)Math.PI * 2.0f;
                this.randomMotionVecX = MathHelper.func_76134_b((float)f) * 0.2f;
                this.randomMotionVecY = -0.1f + this.field_70146_Z.nextFloat() * 0.3f;
                this.randomMotionVecZ = MathHelper.func_76126_a((float)f) * 0.2f;
            }
        }
        this.func_70623_bb();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.75);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean func_70090_H() {
        return this.field_70170_p.func_72918_a(this.field_70121_D.func_72314_b(0.0, (double)-0.6f, 0.0), Material.field_151586_h, (Entity)this);
    }

    public boolean func_70601_bi() {
        return this.field_70163_u > 45.0 && this.field_70163_u < 63.0 && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && super.func_70601_bi();
    }

    public int func_70658_aO() {
        return Math.min(super.func_70658_aO() + 2, 20);
    }

    protected Entity func_70782_k() {
        EntityPlayer entityplayer = this.field_70170_p.func_72856_b((Entity)this, 16.0);
        return entityplayer != null && this.func_70685_l((Entity)entityplayer) ? entityplayer : null;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_85032_ar() || source.func_94541_c()) {
            return false;
        }
        if (super.func_70097_a(source, amount)) {
            Entity entity = source.func_76346_g();
            if (this.field_70153_n != entity && this.field_70154_o != entity) {
                if (entity != this) {
                    this.field_70789_a = entity;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean func_70652_k(Entity entity) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entity instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_77512_a((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
            i += EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
        }
        if (flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0) {
                entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entity.func_70015_d(j * 4);
            }
            if (entity instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)entity), (Entity)this);
            }
        }
        return flag;
    }

    protected void func_70785_a(Entity entity, float distance) {
        if (this.field_70724_aR <= 0) {
            if (distance < 2.0f && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
                this.field_70724_aR = 20;
                this.func_70652_k(entity);
            } else if (this.field_70146_Z.nextInt(60) == 0 && entity instanceof EntityLivingBase) {
                this.field_70724_aR = 20;
                float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                int difficulty = this.field_70170_p.field_73013_u.func_151525_a();
                EntityMobThrowable projectile = this.getType() == 1 ? new EntityBomb(this.field_70170_p, (EntityLivingBase)this, (EntityLivingBase)entity, 1.0f, 14 - difficulty * 4).setType(BombType.BOMB_WATER).setTime(12 - difficulty * 2).setNoGrief().setMotionFactor(0.25f).setDamage(f * 2.0f * (float)difficulty) : new EntityThrowingRock(this.field_70170_p, (EntityLivingBase)this, (EntityLivingBase)entity, 1.0f, 14 - difficulty * 4).setIgnoreWater().setDamage(f * (float)difficulty);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)projectile);
                }
            }
        }
    }

    protected void func_70628_a(boolean recentlyHit, int lootingLevel) {
        int j = this.field_70146_Z.nextInt(2 + lootingLevel) + 1;
        for (int k = 0; k < j; ++k) {
            this.func_70099_a(new ItemStack(Items.field_151100_aR, 1, 0), 0.0f);
        }
    }

    protected void func_70600_l(int par1) {
        switch (par1) {
            case 1: {
                this.func_70099_a(new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.TENTACLE.ordinal()), 0.0f);
                break;
            }
            default: {
                if (this.getType() == 1) {
                    this.func_70099_a(new ItemStack(ZSSItems.bomb, 1, BombType.BOMB_WATER.ordinal()), 0.0f);
                    break;
                }
                this.func_70099_a(new ItemStack(par1 == 1 ? Items.field_151166_bC : ZSSItems.smallHeart), 0.0f);
            }
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("octorokType", (byte)this.getType());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("octorokType")) {
            this.setType(compound.func_74771_c("octorokType"));
        }
    }
}

