/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.item.ItemMask;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TimedAddItem;
import zeldaswordskills.util.TimedChatDialogue;

public class EntityMaskTrader
extends EntityCreature
implements INpc {
    private int randomTickDivider;
    public Village villageObj;
    private EntityPlayer customer;
    private static final Map<Integer, Item> maskMap = new HashMap<Integer, Item>();
    private static final int NUM_STAGES = 3;

    public EntityMaskTrader(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.func_70661_as().func_75498_b(true);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityZombie.class, 8.0f, 0.6, 0.6));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    public boolean func_85032_ar() {
        return true;
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_70629_bd() {
        if (--this.randomTickDivider <= 0) {
            this.field_70170_p.field_72982_D.func_75551_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
            this.randomTickDivider = 70 + this.field_70146_Z.nextInt(50);
            this.villageObj = this.field_70170_p.field_72982_D.func_75550_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v), 32);
            if (this.villageObj == null) {
                this.func_110177_bN();
            } else {
                ChunkCoordinates chunkcoordinates = this.villageObj.func_75577_a();
                this.func_110171_b(chunkcoordinates.field_71574_a, chunkcoordinates.field_71572_b, chunkcoordinates.field_71573_c, (int)((float)this.villageObj.func_75568_b() * 0.6f));
            }
            if (this.customer != null) {
                if (this.customer.field_71070_bA instanceof Container && this.func_70068_e((Entity)this.customer) > 16.0) {
                    this.func_70661_as().func_75499_g();
                } else {
                    this.customer = null;
                }
            }
        }
        super.func_70629_bd();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected String func_70639_aQ() {
        return "mob.villager.haggle";
    }

    protected String func_70621_aR() {
        return "mob.villager.hit";
    }

    protected String func_70673_aS() {
        return "mob.villager.death";
    }

    public boolean func_110164_bC() {
        return false;
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            this.func_70642_aH();
            ZSSPlayerInfo info = ZSSPlayerInfo.get(player);
            int maskStage = info.getCurrentMaskStage();
            if (maskStage >= maskMap.size() * 3) {
                ItemStack stack = player.func_70694_bm();
                Item mask = info.getBorrowedMask();
                if (stack != null && stack.func_77973_b() == mask) {
                    player.func_70062_b(0, null);
                    info.setBorrowedMask(null);
                    PlayerUtils.playSound(player, "random.pop", 1.0f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.npc.mask_trader.returned"));
                } else if (mask != null) {
                    new TimedChatDialogue(player, Arrays.asList(StatCollector.func_74837_a((String)"chat.zss.npc.mask_trader.borrowed.0", (Object[])new Object[]{mask.func_77653_i(new ItemStack(mask))}), StatCollector.func_74837_a((String)"chat.zss.npc.mask_trader.borrowed.1", (Object[])new Object[0])));
                } else {
                    int x = MathHelper.func_76128_c((double)this.field_70165_t);
                    int y = MathHelper.func_76128_c((double)this.field_70163_u);
                    int z = MathHelper.func_76128_c((double)this.field_70161_v);
                    this.customer = player;
                    player.openGui((Object)ZSSMain.instance, 1, this.field_70170_p, x, y, z);
                }
            } else {
                Item mask = maskMap.get(maskStage / 3);
                switch (maskStage % 3) {
                    case 0: {
                        String[] chat = maskStage == 0 ? new String[]{StatCollector.func_74838_a((String)"chat.zss.npc.mask_trader.intro.0"), StatCollector.func_74838_a((String)"chat.zss.npc.mask_trader.intro.1"), StatCollector.func_74838_a((String)"chat.zss.npc.mask_trader.intro.2"), StatCollector.func_74838_a((String)"chat.zss.npc.mask_trader.intro.3")} : new String[]{StatCollector.func_74838_a((String)"chat.zss.npc.mask_trader.next_mask.0"), StatCollector.func_74838_a((String)"chat.zss.npc.mask_trader.next_mask.1")};
                        new TimedChatDialogue(player, Arrays.asList(chat));
                        if (mask != null) {
                            new TimedAddItem(player, new ItemStack(mask), maskStage == 0 ? 4000 : 2000);
                        }
                        info.completeCurrentMaskStage();
                        break;
                    }
                    case 1: {
                        PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)("chat.zss.npc.mask_trader.selling." + this.field_70146_Z.nextInt(4))));
                        break;
                    }
                    case 2: {
                        int price;
                        int n = price = mask instanceof ItemMask ? ((ItemMask)mask).getBuyPrice() : 16;
                        if (PlayerUtils.consumeInventoryItems(player, new ItemStack(Items.field_151166_bC, price))) {
                            PlayerUtils.playSound(player, "zeldaswordskills:cash_sale", 1.0f, 1.0f);
                            info.completeCurrentMaskStage();
                            if (info.getCurrentMaskStage() == maskMap.size() * 3) {
                                new TimedChatDialogue(player, Arrays.asList(StatCollector.func_74838_a((String)"chat.zss.npc.mask_trader.reward.0"), StatCollector.func_74838_a((String)"chat.zss.npc.mask_trader.reward.1"), StatCollector.func_74838_a((String)"chat.zss.npc.mask_trader.reward.2"), StatCollector.func_74838_a((String)"chat.zss.npc.mask_trader.reward.3")));
                                new TimedAddItem(player, new ItemStack(ZSSItems.maskTruth), 4000);
                                info.setBorrowedMask(ZSSItems.maskTruth);
                                player.func_71029_a((StatBase)ZSSAchievements.maskShop);
                                break;
                            }
                            PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.npc.mask_trader.sold"));
                            break;
                        }
                        new TimedChatDialogue(player, Arrays.asList(StatCollector.func_74838_a((String)"chat.zss.npc.mask_trader.penniless.0"), StatCollector.func_74837_a((String)"chat.zss.npc.mask_trader.penniless.1", (Object[])new Object[]{price})));
                    }
                }
            }
        }
        return true;
    }

    public static int getMaskMapSize() {
        return maskMap.size();
    }

    public static Item getMask(int i) {
        return maskMap.get(i);
    }

    static {
        int i = 0;
        maskMap.put(i++, ZSSItems.maskKeaton);
        maskMap.put(i++, ZSSItems.maskSkull);
        maskMap.put(i++, ZSSItems.maskSpooky);
        maskMap.put(i++, ZSSItems.maskScents);
        maskMap.put(i++, ZSSItems.maskCouples);
        maskMap.put(i++, ZSSItems.maskBunny);
    }
}

