/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client.render.item;

import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderBigItem
implements IItemRenderer {
    private final float scale;

    public RenderBigItem(float scale) {
        this.scale = scale;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case EQUIPPED_FIRST_PERSON: {
                this.renderEquippedItem(item, (EntityLivingBase)data[1], true);
                break;
            }
            case EQUIPPED: {
                this.renderEquippedItem(item, (EntityLivingBase)data[1], false);
                break;
            }
        }
    }

    private void renderEquippedItem(ItemStack stack, EntityLivingBase entity, boolean firstPerson) {
        GL11.glPushMatrix();
        float f = this.scale;
        if (firstPerson) {
            f *= 1.75f;
            GL11.glTranslatef((float)(-0.35f * this.scale), (float)(-0.125f * this.scale), (float)0.0f);
        } else {
            GL11.glTranslatef((float)(1.0f - (f *= entity instanceof EntityPlayer ? 2.0f : 1.75f)), (float)(-0.125f * this.scale), (float)(0.05f * this.scale));
        }
        GL11.glScalef((float)f, (float)f, (float)f);
        IIcon icon = stack.func_77973_b().getIcon(stack, 0);
        Tessellator tessellator = Tessellator.field_78398_a;
        ItemRenderer.func_78439_a((Tessellator)tessellator, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
        GL11.glPopMatrix();
    }
}

