/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ModParticle
extends EntityFX {
    public static final ResourceLocation modParticles = new ResourceLocation("zeldaswordskills", "textures/particles.png");
    public static final ResourceLocation minecraftParticles = new ResourceLocation("textures/particle/particles.png");
    protected int iconStages;
    protected int iconStartIndex;
    private int initialIconIndex;
    private int remainingIconStages;
    private boolean animated = false;
    private float fadeInTime = 0.0f;
    private float baseAlpha = 1.0f;
    private float fadeOutTime = 0.8f;
    private boolean glowing = false;

    public ModParticle(World world, double x, double y, double z) {
        this(world, x, y, z, 0.0, 0.0, 0.0);
    }

    public ModParticle(World world, double x, double y, double z, double velX, double velY, double velZ) {
        super(world, x, y, z, velX, velY, velZ);
        this.field_70159_w = velX;
        this.field_70181_x = velY;
        this.field_70179_y = velZ;
    }

    public void func_82338_g(float value) {
        this.setBaseAlpha(value);
    }

    protected void setBaseAlpha(float value) {
        this.baseAlpha = value;
        this.field_82339_as = value;
    }

    protected void setRandomScale(float min, float max) {
        this.field_70544_f = this.field_70146_Z.nextFloat() * (max - min) + min;
    }

    protected void setRandomMaxAge(int min, int max) {
        this.field_70547_e = MathHelper.func_76141_d((float)(this.field_70146_Z.nextFloat() * (float)(max - min))) + min;
    }

    protected void randomizeVelocity(double maximum) {
        this.field_70159_w += (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * maximum;
        this.field_70181_x += (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * maximum;
        this.field_70179_y += (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * maximum;
    }

    protected void setTexturePositions(int x, int y) {
        this.setTexturePositions(x, y, 1, false);
    }

    protected void setTexturePositions(int x, int y, int stages, boolean randomStart) {
        this.remainingIconStages = this.iconStages = stages;
        this.initialIconIndex = this.iconStartIndex = y * 16 + x;
        if (randomStart) {
            int firstStage = this.field_70146_Z.nextInt(stages - 1);
            this.initialIconIndex += firstStage;
            this.remainingIconStages -= firstStage;
        }
        this.func_70536_a(this.initialIconIndex);
    }

    protected void setAnimated(boolean value) {
        this.animated = value;
    }

    protected void setFade(float fadeInTime, float fadeOutTime) {
        this.fadeInTime = fadeInTime;
        this.fadeOutTime = fadeOutTime;
    }

    protected void setGlowing() {
        this.glowing = true;
    }

    public void func_70539_a(Tessellator tessellator, float partialTick, float rotX, float rotXZ, float rotZ, float rotYZ, float rotXY) {
        tessellator.func_78381_a();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(modParticles);
        tessellator.func_78382_b();
        tessellator.func_78380_c(this.func_70070_b(partialTick));
        super.func_70539_a(tessellator, partialTick, rotX, rotXZ, rotZ, rotYZ, rotXY);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(minecraftParticles);
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        float ageFraq = (float)this.field_70546_d / (float)this.field_70547_e;
        this.field_82339_as = this.alphaAtAge(ageFraq);
        this.field_70544_f = this.scaleAtAge(ageFraq);
        if (this.animated && this.remainingIconStages > 1) {
            int stage = MathHelper.func_76141_d((float)(ageFraq * (float)this.remainingIconStages));
            this.func_70536_a(this.initialIconIndex + stage);
        }
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_70106_y();
        }
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    public int func_70070_b(float partialTick) {
        return this.glowing ? 0xF000F0 : super.func_70070_b(partialTick);
    }

    protected float alphaAtAge(float ageFraq) {
        if (ageFraq <= this.fadeInTime) {
            return this.baseAlpha * ageFraq / this.fadeInTime;
        }
        if (ageFraq >= this.fadeOutTime) {
            return this.baseAlpha * (1.0f - (ageFraq - this.fadeOutTime) / (1.0f - this.fadeOutTime));
        }
        return this.baseAlpha;
    }

    protected float scaleAtAge(float ageFraq) {
        return this.field_70544_f;
    }

    protected void setColor(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        this.func_70538_b(r, g, b);
    }
}

