/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.client.render.EntityRendererAlt;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.item.ItemMagicRod;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.lib.Config;
import zeldaswordskills.skills.ILockOnTarget;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.skills.sword.Dodge;
import zeldaswordskills.skills.sword.EndingBlow;
import zeldaswordskills.skills.sword.Parry;
import zeldaswordskills.skills.sword.RisingCut;
import zeldaswordskills.skills.sword.SpinAttack;
import zeldaswordskills.skills.sword.SwordBreak;
import zeldaswordskills.util.PlayerUtils;

@SideOnly(value=Side.CLIENT)
public class TargetingTickHandler {
    private final Minecraft mc = Minecraft.func_71410_x();
    private EntityRenderer renderer;
    private EntityRenderer prevRenderer;
    private EntityPlayer player = null;
    private Entity target = null;
    boolean isLeftPressed = false;

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.player = this.mc.field_71439_g;
            if (this.player != null && ZSSPlayerInfo.get(this.player) != null) {
                ZSSPlayerInfo skills;
                ILockOnTarget skill;
                this.updateRenderer();
                if (this.player.func_71011_bu() != null && this.player.func_71011_bu().func_77973_b() instanceof ItemMagicRod) {
                    this.player.field_70733_aJ = 0.5f;
                }
                if ((skill = (skills = ZSSPlayerInfo.get(this.player)).getTargetingSkill()) != null) {
                    boolean flag = false;
                    if (skills.isSkillActive(SkillBase.dodge)) {
                        flag = ((Dodge)skills.getPlayerSkill(SkillBase.dodge)).onRenderTick(this.player);
                    } else if (skills.isSkillActive(SkillBase.spinAttack)) {
                        flag = ((SpinAttack)skills.getPlayerSkill(SkillBase.spinAttack)).onRenderTick(this.player);
                    } else if (skills.isSkillActive(SkillBase.risingCut)) {
                        flag = ((RisingCut)skills.getPlayerSkill(SkillBase.risingCut)).onRenderTick(this.player);
                    }
                    if (!flag && skill.isLockedOn()) {
                        this.target = skill.getCurrentTarget();
                        this.updatePlayerView();
                    }
                    if (skill.isLockedOn() && skills.canInteract() && !skills.isNayruActive()) {
                        if (this.isVanillaKeyPressed(this.mc.field_71474_y.field_74314_A)) {
                            if (skills.hasSkill(SkillBase.risingCut) && !skills.isSkillActive(SkillBase.risingCut) && !PlayerUtils.isUsingItem(this.player) && this.player.func_70093_af()) {
                                ((RisingCut)skills.getPlayerSkill(SkillBase.risingCut)).keyPressed();
                            } else if (skills.hasSkill(SkillBase.leapingBlow) && !skills.isSkillActive(SkillBase.leapingBlow) && PlayerUtils.isUsingItem(this.player)) {
                                skills.activateSkill((World)this.mc.field_71441_e, SkillBase.leapingBlow);
                                KeyBinding.func_74510_a((int)this.mc.field_71474_y.field_74313_G.func_151463_i(), (boolean)false);
                                KeyBinding.func_74510_a((int)ZSSKeyHandler.keys[6].func_151463_i(), (boolean)false);
                            }
                        } else if (this.isVanillaKeyPressed(this.mc.field_71474_y.field_74351_w)) {
                            if (skills.hasSkill(SkillBase.endingBlow)) {
                                ((EndingBlow)skills.getPlayerSkill(SkillBase.endingBlow)).keyPressed();
                            }
                        } else if (Config.allowVanillaControls()) {
                            this.isLeftPressed = this.isVanillaKeyPressed(this.mc.field_71474_y.field_74370_x);
                            if (this.isLeftPressed || this.isVanillaKeyPressed(this.mc.field_71474_y.field_74366_z)) {
                                if (skills.hasSkill(SkillBase.spinAttack)) {
                                    ((SpinAttack)skills.getPlayerSkill(SkillBase.spinAttack)).keyPressed(this.isLeftPressed ? this.mc.field_71474_y.field_74370_x : this.mc.field_71474_y.field_74366_z, this.player);
                                }
                                if (skills.hasSkill(SkillBase.dodge) && this.player.field_70122_E) {
                                    ((Dodge)skills.getPlayerSkill(SkillBase.dodge)).keyPressed(this.isLeftPressed ? this.mc.field_71474_y.field_74370_x : this.mc.field_71474_y.field_74366_z, this.player);
                                }
                            } else if (this.isVanillaKeyPressed(this.mc.field_71474_y.field_74368_y)) {
                                if (PlayerUtils.isUsingItem(this.player) && skills.hasSkill(SkillBase.swordBreak)) {
                                    ((SwordBreak)skills.getPlayerSkill(SkillBase.swordBreak)).keyPressed(this.player);
                                } else if (skills.hasSkill(SkillBase.parry)) {
                                    ((Parry)skills.getPlayerSkill(SkillBase.parry)).keyPressed(this.player);
                                }
                            }
                        }
                    }
                }
            }
        } else {
            this.player = null;
            this.target = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isVanillaKeyPressed(KeyBinding key) {
        return key.func_151468_f() && key.func_151470_d();
    }

    private void updatePlayerView() {
        float rYaw;
        double dx = this.player.field_70165_t - this.target.field_70165_t;
        double dz = this.player.field_70161_v - this.target.field_70161_v;
        double angle = Math.atan2(dz, dx) * 180.0 / Math.PI;
        double pitch = Math.atan2(this.player.field_70163_u - (this.target.field_70163_u + (double)(this.target.field_70131_O / 2.0f)), Math.sqrt(dx * dx + dz * dz)) * 180.0 / Math.PI;
        double distance = this.player.func_70032_d(this.target);
        for (rYaw = (float)(angle - (double)this.player.field_70177_z); rYaw > 180.0f; rYaw -= 360.0f) {
        }
        while (rYaw < -180.0f) {
            rYaw += 360.0f;
        }
        float rPitch = (float)pitch - (float)(10.0 / Math.sqrt(distance)) + (float)(distance * Math.PI / 90.0);
        this.player.func_70082_c(rYaw += 90.0f, -(rPitch - this.player.field_70125_A));
    }

    private void updateRenderer() {
        ItemStack mask = this.mc.field_71439_g.func_82169_q(3);
        if (mask != null && mask.func_77973_b() == ZSSItems.maskGiants) {
            if (this.renderer == null) {
                this.renderer = new EntityRendererAlt(this.mc);
            }
            if (this.mc.field_71460_t != this.renderer) {
                this.prevRenderer = this.mc.field_71460_t;
                this.mc.field_71460_t = this.renderer;
            }
        } else if (this.prevRenderer != null && this.mc.field_71460_t != this.prevRenderer) {
            this.mc.field_71460_t = this.prevRenderer;
        }
    }
}

