/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.api.block.IExplodable;
import zeldaswordskills.api.block.ISmashable;
import zeldaswordskills.block.IDungeonBlock;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.lib.Config;
import zeldaswordskills.util.PlayerUtils;

public class BlockSecretStone
extends Block
implements IDungeonBlock,
IExplodable,
ISmashable {
    public static final String[] names = new String[]{"stone", "sandstone_normal", "nether_brick", "stonebrick", "cobblestone_mossy", "ice", "cobblestone", "end_stone"};
    private static final int[] slabs = new int[]{0, 1, 6, 5, 3, 7, 3, 7};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public BlockSecretStone(Material material) {
        super(material);
        this.func_149722_s();
        this.func_149752_b(6.0f);
        this.func_149672_a(field_149769_e);
        this.func_149647_a(ZSSCreativeTabs.tabBlocks);
    }

    @Override
    public BlockWeight getSmashWeight(EntityPlayer player, ItemStack stack, int meta) {
        return meta < 8 ? BlockWeight.VERY_HEAVY : BlockWeight.IMPOSSIBLE;
    }

    @Override
    public Event.Result onSmashed(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, int side) {
        return Event.Result.DEFAULT;
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        return world.func_72805_g(x, y, z) < 8;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public int func_149656_h() {
        return 2;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return false;
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return Item.func_150898_a((Block)BlockSecretStone.getBlockFromMeta(meta));
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.field_72995_K && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemPickaxe) {
            if (Config.showSecretMessage()) {
                PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.block.secret"));
            }
            world.func_72956_a((Entity)player, "random.break", 0.25f, 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 0.5f));
        }
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return world.func_72805_g(x, y, z) < 8 ? this.func_149638_a(entity) : BlockWeight.getMaxResistance();
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        if (world.func_72805_g(x, y, z) < 8) {
            super.onBlockExploded(world, x, y, z, explosion);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < names.length; ++i) {
            list.add(new ItemStack(item, 1, i));
            list.add(new ItemStack(item, 1, i | 8));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.iconArray[(meta & 0xFFFFFFF7) % names.length];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.iconArray = new IIcon[names.length];
        for (int i = 0; i < names.length; ++i) {
            this.iconArray[i] = register.func_94245_a(names[i]);
        }
    }

    public static Block getBlockFromMeta(int meta) {
        switch (meta & 0xFFFFFFF7) {
            case 0: {
                return Blocks.field_150348_b;
            }
            case 1: {
                return Blocks.field_150322_A;
            }
            case 2: {
                return Blocks.field_150385_bj;
            }
            case 3: {
                return Blocks.field_150417_aV;
            }
            case 4: {
                return Blocks.field_150341_Y;
            }
            case 5: {
                return Blocks.field_150432_aD;
            }
            case 6: {
                return Blocks.field_150347_e;
            }
            case 7: {
                return Blocks.field_150377_bs;
            }
        }
        return Blocks.field_150348_b;
    }

    public static Block getStairsFromMeta(int meta) {
        switch (meta & 0xFFFFFFF7) {
            case 0: {
                return Blocks.field_150390_bg;
            }
            case 4: 
            case 6: {
                return Blocks.field_150446_ar;
            }
            case 1: {
                return Blocks.field_150372_bz;
            }
            case 2: {
                return Blocks.field_150387_bl;
            }
            case 3: {
                return Blocks.field_150390_bg;
            }
            case 5: 
            case 7: {
                return Blocks.field_150370_cb;
            }
        }
        return Blocks.field_150446_ar;
    }

    public static int getSlabTypeFromMeta(int meta) {
        return slabs[meta % 8];
    }
}

