/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import net.minecraftforge.common.MinecraftForge;
import zeldaswordskills.CommonProxy;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.entity.ZSSEntities;
import zeldaswordskills.handler.BattlegearEvents;
import zeldaswordskills.handler.GuiHandler;
import zeldaswordskills.handler.ZSSCombatEvents;
import zeldaswordskills.handler.ZSSEntityEvents;
import zeldaswordskills.handler.ZSSItemEvents;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.lib.Config;
import zeldaswordskills.network.PacketPipeline;
import zeldaswordskills.util.LogHelper;
import zeldaswordskills.world.gen.DungeonLootLists;
import zeldaswordskills.world.gen.ZSSWorldGenEvent;

@Mod(modid="zeldaswordskills", name="Zelda Sword Skills", version="1.7.2-beta-0.1.3")
public class ZSSMain {
    @Mod.Instance(value="zeldaswordskills")
    public static ZSSMain instance;
    @SidedProxy(clientSide="zeldaswordskills.ClientProxy", serverSide="zeldaswordskills.CommonProxy")
    public static CommonProxy proxy;
    public static final PacketPipeline dispatcher;
    public static boolean isAtlasEnabled;
    public static boolean isBG2Enabled;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LogHelper.init();
        Config.init(event);
        ZSSBlocks.load();
        ZSSItems.load();
        ZSSEntities.load();
        ZSSAchievements.init();
        DungeonLootLists.initLootLists();
        isAtlasEnabled = Loader.isModLoaded((String)"antiqueatlas");
        isBG2Enabled = Loader.isModLoaded((String)"battlegear2");
        proxy.initialize();
        ZSSWorldGenEvent dungeonGen = new ZSSWorldGenEvent();
        MinecraftForge.EVENT_BUS.register((Object)dungeonGen);
        if (Config.areBossDungeonsEnabled()) {
            MinecraftForge.TERRAIN_GEN_BUS.register((Object)dungeonGen);
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        dispatcher.initialise();
        proxy.registerRenderers();
        MinecraftForge.EVENT_BUS.register((Object)new ZSSCombatEvents());
        MinecraftForge.EVENT_BUS.register((Object)new ZSSEntityEvents());
        MinecraftForge.EVENT_BUS.register((Object)new ZSSItemEvents());
        ZSSItemEvents.initializeDrops();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Config.postInit();
        dispatcher.postInitialise();
        if (isBG2Enabled) {
            MinecraftForge.EVENT_BUS.register((Object)new BattlegearEvents());
        }
    }

    static {
        dispatcher = new PacketPipeline();
    }
}

