/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.ether;

import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.world.World;
import net.slimevoid.wirelessredstone.core.WRCore;
import net.slimevoid.wirelessredstone.data.LoggerRedstoneWireless;
import net.slimevoid.wirelessredstone.data.WirelessReadWriteLock;
import net.slimevoid.wirelessredstone.ether.RedstoneEther;
import net.slimevoid.wirelessredstone.ether.RedstoneEtherNode;

public class RedstoneEtherFrequency {
    public Map<RedstoneEtherNode, RedstoneEtherNode> txs = new TreeMap<RedstoneEtherNode, RedstoneEtherNode>();
    private WirelessReadWriteLock txLock = new WirelessReadWriteLock();
    public Map<RedstoneEtherNode, RedstoneEtherNode> rxs = new TreeMap<RedstoneEtherNode, RedstoneEtherNode>();
    private WirelessReadWriteLock rxLock = new WirelessReadWriteLock();

    public boolean getState(World world) {
        boolean state = false;
        try {
            LinkedList<RedstoneEtherNode> rem = new LinkedList<RedstoneEtherNode>();
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").write(world.isRemote, "getState(world)", LoggerRedstoneWireless.LogLevel.DEBUG);
            this.txLock.readLock(world);
            for (RedstoneEtherNode tx : this.txs.values()) {
                if (!RedstoneEther.getInstance().isLoaded(world, tx.i, tx.j, tx.k)) {
                    LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").write(world.isRemote, "getState(world) - " + tx.toString() + " not loaded. Removing", LoggerRedstoneWireless.LogLevel.WARNING);
                    rem.add(tx);
                    continue;
                }
                if (state || !tx.state) continue;
                state = true;
                break;
            }
            this.txLock.readUnlock();
            for (RedstoneEtherNode tx : rem) {
                this.remTransmitter(world, tx.i, tx.j, tx.k);
            }
        }
        catch (InterruptedException e) {
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").writeStackTrace(e);
        }
        return state;
    }

    public void setTransmitterState(World world, int i, int j, int k, boolean state) {
        try {
            if (!this.txs.containsKey(new RedstoneEtherNode(i, j, k))) {
                return;
            }
            this.txLock.readLock(world);
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").write(world.isRemote, "setTransmitterState(world, " + i + ", " + j + ", " + k + ", " + state + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
            this.txs.get((Object)new RedstoneEtherNode((int)i, (int)j, (int)k)).state = state;
            this.txLock.readUnlock();
            this.updateReceivers(world);
        }
        catch (InterruptedException e) {
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").writeStackTrace(e);
        }
    }

    public void addTransmitter(World world, RedstoneEtherNode tx) {
        try {
            this.txLock.writeLock(world);
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").write(world.isRemote, "addTransmitter(" + tx.toString() + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
            this.txs.put(tx, tx);
            this.txLock.writeUnlock();
        }
        catch (InterruptedException e) {
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").writeStackTrace(e);
        }
    }

    public void addReceiver(World world, RedstoneEtherNode rx) {
        try {
            this.rxLock.writeLock(world);
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").write(world.isRemote, "addTransmitter(" + rx.toString() + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
            this.rxs.put(rx, rx);
            this.rxLock.writeUnlock();
        }
        catch (InterruptedException e) {
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").writeStackTrace(e);
        }
    }

    public void remTransmitter(World world, int i, int j, int k) {
        try {
            if (!this.txs.containsKey(new RedstoneEtherNode(i, j, k))) {
                return;
            }
            this.txLock.writeLock(world);
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").write(world.isRemote, "remTransmitter(world, " + i + ", " + j + ", " + k + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
            this.txs.remove(new RedstoneEtherNode(i, j, k));
            this.txLock.writeUnlock();
            this.updateReceivers(world);
        }
        catch (InterruptedException e) {
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").writeStackTrace(e);
        }
    }

    public void remReceiver(World world, int i, int j, int k) {
        try {
            if (!this.rxs.containsKey(new RedstoneEtherNode(i, j, k))) {
                return;
            }
            this.rxLock.writeLock(world);
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").write(world.isRemote, "remReceiver(" + i + ", " + j + ", " + k + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
            this.rxs.remove(new RedstoneEtherNode(i, j, k));
            this.rxLock.writeUnlock();
        }
        catch (InterruptedException e) {
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").writeStackTrace(e);
        }
    }

    private void updateReceivers(World world) {
        try {
            LinkedList<RedstoneEtherNode> rem = new LinkedList<RedstoneEtherNode>();
            LinkedList update = new LinkedList();
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").write(world.isRemote, "updateReceivers(world)", LoggerRedstoneWireless.LogLevel.DEBUG);
            this.rxLock.readLock(world);
            for (RedstoneEtherNode rx : this.rxs.values()) {
                if (!RedstoneEther.getInstance().isLoaded(world, rx.i, rx.j, rx.k)) {
                    LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").write(world.isRemote, "updateReceivers(world) " + rx.toString() + " not loaded. Removing", LoggerRedstoneWireless.LogLevel.WARNING);
                    rem.add(rx);
                    continue;
                }
                WRCore.blockWirelessR.updateTick(world, rx.i, rx.j, rx.k, null);
            }
            this.rxLock.readUnlock();
            for (RedstoneEtherNode rx : rem) {
                this.remReceiver(world, rx.i, rx.j, rx.k);
            }
        }
        catch (InterruptedException e) {
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").writeStackTrace(e);
        }
    }

    public int count() {
        return this.rxs.size() + this.txs.size();
    }

    public int[] getClosestActiveTransmitter(World world, int i, int j, int k) {
        try {
            int[] pos = new int[3];
            int[] myPos = new int[]{i, j, k};
            int[] tmpPos = new int[3];
            boolean first = true;
            float h = 0.0f;
            this.txLock.readLock(world);
            for (RedstoneEtherNode node : this.txs.values()) {
                if (!node.state) continue;
                if (first) {
                    pos = new int[]{node.i, node.j, node.k};
                    h = RedstoneEther.pythagoras(myPos, pos);
                    first = false;
                    continue;
                }
                tmpPos[0] = node.i;
                tmpPos[1] = node.j;
                tmpPos[2] = node.k;
                if (!(h > RedstoneEther.pythagoras(myPos, tmpPos))) continue;
                pos[0] = node.i;
                pos[1] = node.j;
                pos[2] = node.k;
            }
            this.txLock.readUnlock();
            if (first) {
                return null;
            }
            return pos;
        }
        catch (InterruptedException e) {
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").writeStackTrace(e);
            return null;
        }
    }

    public int[] getClosestTransmitter(World world, int i, int j, int k) {
        try {
            int[] pos = new int[3];
            int[] myPos = new int[]{i, j, k};
            int[] tmpPos = new int[3];
            boolean first = true;
            float h = 0.0f;
            this.txLock.readLock(world);
            for (RedstoneEtherNode node : this.txs.values()) {
                if (first) {
                    pos = new int[]{node.i, node.j, node.k};
                    h = RedstoneEther.pythagoras(myPos, pos);
                    first = false;
                    continue;
                }
                tmpPos[0] = node.i;
                tmpPos[1] = node.j;
                tmpPos[2] = node.k;
                if (!(h > RedstoneEther.pythagoras(myPos, tmpPos))) continue;
                pos[0] = node.i;
                pos[1] = node.j;
                pos[2] = node.k;
            }
            this.txLock.readUnlock();
            if (first) {
                return null;
            }
            return pos;
        }
        catch (InterruptedException e) {
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").writeStackTrace(e);
            return null;
        }
    }
}

