/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.data;

import net.minecraft.world.World;
import net.slimevoid.wirelessredstone.data.LoggerRedstoneWireless;

public class WirelessReadWriteLock {
    private int readers = 0;
    private int writers = 0;
    private int writeReq = 0;

    public synchronized void readLock(World world) throws InterruptedException {
        while (this.writers > 0 || this.writeReq > 0) {
            LoggerRedstoneWireless.getInstance("WirelessReadWriteLock").write(world.isRemote, "readLock() - waiting", LoggerRedstoneWireless.LogLevel.INFO);
            this.wait();
        }
        ++this.readers;
    }

    public synchronized void readUnlock() {
        --this.readers;
        this.notifyAll();
    }

    public synchronized void writeLock(World world) throws InterruptedException {
        ++this.writeReq;
        while (this.readers > 0 || this.writers > 0) {
            LoggerRedstoneWireless.getInstance("WirelessReadWriteLock").write(world.isRemote, "writeLock() - waiting", LoggerRedstoneWireless.LogLevel.INFO);
            this.wait();
        }
        ++this.writers;
        --this.writeReq;
    }

    public synchronized void writeUnlock() {
        --this.writers;
        this.notifyAll();
    }
}

