/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.data;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import net.slimevoid.wirelessredstone.core.WirelessRedstone;

public class LoggerRedstoneWireless {
    private static LoggerRedstoneWireless instance;
    private String name = "WirelessRedstone";
    private LoggerRedstoneWirelessWriter writer;
    private LogLevel filterLevel;

    private LoggerRedstoneWireless() {
    }

    public static LoggerRedstoneWireless getInstance(String name) {
        if (instance == null) {
            instance = new LoggerRedstoneWireless();
        }
        LoggerRedstoneWireless.instance.name = name;
        return instance;
    }

    public boolean setFilterLevel(String f) {
        if (f.equals(LogLevel.DEBUG.name())) {
            this.filterLevel = LogLevel.DEBUG;
            return true;
        }
        if (f.equals(LogLevel.INFO.name())) {
            this.filterLevel = LogLevel.INFO;
            return true;
        }
        if (f.equals(LogLevel.WARNING.name())) {
            this.filterLevel = LogLevel.WARNING;
            return true;
        }
        if (f.equals(LogLevel.ERROR.name())) {
            this.filterLevel = LogLevel.ERROR;
            return true;
        }
        this.filterLevel = LogLevel.INFO;
        return false;
    }

    private boolean filter(LogLevel lvl) {
        if (this.filterLevel == LogLevel.DEBUG) {
            return true;
        }
        if (this.filterLevel == LogLevel.INFO) {
            return lvl != LogLevel.DEBUG;
        }
        if (this.filterLevel == LogLevel.WARNING) {
            return lvl != LogLevel.DEBUG && lvl != LogLevel.INFO;
        }
        if (this.filterLevel == LogLevel.ERROR) {
            return lvl == LogLevel.ERROR;
        }
        return true;
    }

    public void write(boolean isRemote, String msg, LogLevel lvl) {
        String name = this.name;
        if (this.filter(lvl)) {
            if (this.writer == null) {
                this.writer = new LoggerRedstoneWirelessWriter();
            }
            StringBuilder trace = new StringBuilder();
            try {
                throw new Exception();
            }
            catch (Exception e) {
                int min;
                StackTraceElement[] c = e.getStackTrace();
                for (int i = min = Math.min(3, c.length - 1); i >= 1; --i) {
                    trace.append(LoggerRedstoneWireless.filterClassName(c[i].getClassName()) + "." + c[i].getMethodName());
                    if (i <= 1) continue;
                    trace.append("->");
                }
                this.writer.write(lvl.name() + ":" + this.getSide(isRemote) + ":" + name + ":" + msg + ":" + trace);
            }
        }
    }

    private String getSide(boolean isRemote) {
        if (!isRemote && FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            return "ISERVER";
        }
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            return "CLIENT";
        }
        if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
            return "SERVER";
        }
        return "UNKNOWN";
    }

    public void writeStackTrace(Exception e) {
        if (this.writer == null) {
            this.writer = new LoggerRedstoneWirelessWriter();
        }
        this.writer.writeStackTrace(e);
        FMLCommonHandler.instance().raiseException((Throwable)e, e.getMessage(), true);
    }

    public static String filterClassName(String name) {
        return name.substring(name.lastIndexOf(".") + 1);
    }

    private class LoggerRedstoneWirelessWriter {
        private File file;
        private FileWriter fstream;
        private PrintWriter out;

        public LoggerRedstoneWirelessWriter() {
            try {
                this.file = new File(WirelessRedstone.proxy.getMinecraftDir() + File.separator + "wirelessRedstone.log");
                this.fstream = new FileWriter(this.file);
                this.out = new PrintWriter(this.fstream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void finalize() {
            try {
                this.out.close();
                this.fstream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void write(String msg) {
            this.out.write("\n" + System.currentTimeMillis() + ":" + msg);
            this.out.flush();
        }

        public void writeStackTrace(Exception e) {
            this.out.write("\n" + System.currentTimeMillis() + ":");
            this.out.flush();
            e.printStackTrace(this.out);
            this.out.flush();
            e.printStackTrace();
        }
    }

    public static enum LogLevel {
        DEBUG,
        INFO,
        WARNING,
        ERROR;

    }
}

