/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.core;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.slimevoid.wirelessredstone.api.IBlockRedstoneWirelessOverride;
import net.slimevoid.wirelessredstone.block.BlockRedstoneWireless;
import net.slimevoid.wirelessredstone.block.BlockRedstoneWirelessR;
import net.slimevoid.wirelessredstone.block.BlockRedstoneWirelessT;
import net.slimevoid.wirelessredstone.core.WirelessRedstone;
import net.slimevoid.wirelessredstone.data.LoggerRedstoneWireless;
import net.slimevoid.wirelessredstone.network.NetworkEvent;
import net.slimevoid.wirelessredstone.tileentity.TileEntityRedstoneWireless;
import net.slimevoid.wirelessredstone.tileentity.TileEntityRedstoneWirelessR;
import net.slimevoid.wirelessredstone.tileentity.TileEntityRedstoneWirelessT;

public class WRCore {
    public static Block blockWirelessR;
    public static Block blockWirelessT;
    public static int rxID;
    public static int txID;
    public static int spriteTItem;
    public static int spriteRItem;
    public static int maxEtherFrequencies;
    public static boolean isLoaded;
    public static CreativeTabs wirelessRedstone;

    public static boolean initialize() {
        WirelessRedstone.proxy.init();
        WRCore.initBlocks();
        WirelessRedstone.proxy.addOverrides();
        WRCore.registerBlocks();
        WirelessRedstone.proxy.registerRenderInformation();
        WirelessRedstone.proxy.registerTileEntitySpecialRenderer(TileEntityRedstoneWireless.class);
        WRCore.addRecipes();
        NetworkEvent.registerNetworkEvents();
        return true;
    }

    private static void initBlocks() {
        blockWirelessR = new BlockRedstoneWirelessR(rxID, 1.0f, 8.0f).setBlockName("wirelessredstone.receiver");
        blockWirelessT = new BlockRedstoneWirelessT(txID, 1.0f, 8.0f).setBlockName("wirelessredstone.transmitter");
    }

    private static void registerBlocks() {
        GameRegistry.registerBlock((Block)blockWirelessR, (String)"wirelessredstone.receiver");
        GameRegistry.registerTileEntityWithAlternatives(TileEntityRedstoneWirelessR.class, (String)"wirelessredstone.receiver", (String[])new String[]{"Wireless Receiver"});
        GameRegistry.registerBlock((Block)blockWirelessT, (String)"wirelessredstone.transmitter");
        GameRegistry.registerTileEntityWithAlternatives(TileEntityRedstoneWirelessT.class, (String)"wirelessredstone.transmitter", (String[])new String[]{"Wireless Transmitter"});
    }

    private static void addRecipes() {
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockWirelessR, 1), (Object[])new Object[]{"IRI", "RLR", "IRI", Character.valueOf('I'), Items.iron_ingot, Character.valueOf('R'), Items.redstone, Character.valueOf('L'), Blocks.lever});
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockWirelessT, 1), (Object[])new Object[]{"IRI", "RTR", "IRI", Character.valueOf('I'), Items.iron_ingot, Character.valueOf('R'), Items.redstone, Character.valueOf('T'), Blocks.redstone_torch});
    }

    public static void addOverrideToReceiver(IBlockRedstoneWirelessOverride override) {
        LoggerRedstoneWireless.getInstance("Wireless Redstone").write(true, "Override added to " + LoggerRedstoneWireless.filterClassName(blockWirelessR.getClass().toString()) + " - " + LoggerRedstoneWireless.filterClassName(override.getClass().toString()), LoggerRedstoneWireless.LogLevel.DEBUG);
        ((BlockRedstoneWireless)blockWirelessR).addOverride(override);
    }

    public static void addOverrideToTransmitter(IBlockRedstoneWirelessOverride override) {
        LoggerRedstoneWireless.getInstance("Wireless Redstone").write(true, "Override added to " + LoggerRedstoneWireless.filterClassName(blockWirelessT.getClass().toString()) + " - " + LoggerRedstoneWireless.filterClassName(override.getClass().toString()), LoggerRedstoneWireless.LogLevel.DEBUG);
        ((BlockRedstoneWireless)blockWirelessT).addOverride(override);
    }

    public static boolean mergeItemStack(Container container, ItemStack stackToMerge, int slotStart, int slotEnd, boolean reverseOrder) {
        ItemStack stackInSlot;
        Slot slot;
        boolean stackMerged = false;
        int realSlotStart = slotStart;
        if (reverseOrder) {
            realSlotStart = slotEnd - 1;
        }
        if (stackToMerge.isStackable()) {
            while (stackToMerge.stackSize > 0 && (!reverseOrder && realSlotStart < slotEnd || reverseOrder && realSlotStart >= slotStart)) {
                slot = (Slot)container.inventorySlots.get(realSlotStart);
                stackInSlot = slot.getStack();
                if (stackInSlot != null && stackInSlot.getItem().equals(stackToMerge.getItem()) && (!stackToMerge.getHasSubtypes() || stackToMerge.getItemDamage() == stackInSlot.getItemDamage()) && ItemStack.areItemStackTagsEqual((ItemStack)stackToMerge, (ItemStack)stackInSlot)) {
                    int totalStackSize = stackInSlot.stackSize + stackToMerge.stackSize;
                    if (totalStackSize <= stackToMerge.getMaxStackSize() && totalStackSize <= slot.getSlotStackLimit()) {
                        stackToMerge.stackSize = 0;
                        stackInSlot.stackSize = totalStackSize;
                        slot.onSlotChanged();
                        stackMerged = true;
                    } else if (stackInSlot.stackSize < stackToMerge.getMaxStackSize() && stackInSlot.stackSize < slot.getSlotStackLimit()) {
                        stackToMerge.stackSize -= stackToMerge.getMaxStackSize() - stackInSlot.stackSize;
                        stackInSlot.stackSize = stackToMerge.getMaxStackSize();
                        slot.onSlotChanged();
                        stackMerged = true;
                    }
                }
                if (reverseOrder) {
                    --realSlotStart;
                    continue;
                }
                ++realSlotStart;
            }
        }
        if (stackToMerge.stackSize > 0) {
            realSlotStart = reverseOrder ? slotEnd - 1 : slotStart;
            while (!reverseOrder && realSlotStart < slotEnd || reverseOrder && realSlotStart >= slotStart) {
                slot = (Slot)container.inventorySlots.get(realSlotStart);
                stackInSlot = slot.getStack();
                if (stackInSlot == null) {
                    slot.putStack(stackToMerge.copy());
                    if (stackToMerge.stackSize > slot.getSlotStackLimit()) {
                        slot.getStack().stackSize = slot.getSlotStackLimit();
                        stackToMerge.stackSize -= slot.getSlotStackLimit();
                    } else {
                        stackToMerge.stackSize = 0;
                        stackMerged = true;
                    }
                    slot.onSlotChanged();
                    break;
                }
                if (reverseOrder) {
                    --realSlotStart;
                    continue;
                }
                ++realSlotStart;
            }
        }
        return stackMerged;
    }

    static {
        maxEtherFrequencies = 10000;
        isLoaded = false;
    }
}

