/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.slimevoid.wirelessredstone.block.BlockRedstoneWireless;
import net.slimevoid.wirelessredstone.core.WirelessRedstone;
import net.slimevoid.wirelessredstone.ether.RedstoneEther;
import net.slimevoid.wirelessredstone.tileentity.TileEntityRedstoneWireless;
import net.slimevoid.wirelessredstone.tileentity.TileEntityRedstoneWirelessT;

public class BlockRedstoneWirelessT
extends BlockRedstoneWireless {
    @Override
    public void registerIcons(IIconRegister iconRegister) {
        this.iconBuffer = new IIcon[2][6];
        this.iconBuffer[0][0] = iconRegister.registerIcon("wirelessredstone:bottomoff");
        this.iconBuffer[0][1] = iconRegister.registerIcon("wirelessredstone:topoff");
        this.iconBuffer[0][2] = iconRegister.registerIcon("wirelessredstone:txoff");
        this.iconBuffer[0][3] = iconRegister.registerIcon("wirelessredstone:txoff");
        this.iconBuffer[0][4] = iconRegister.registerIcon("wirelessredstone:txoff");
        this.iconBuffer[0][5] = iconRegister.registerIcon("wirelessredstone:txoff");
        this.iconBuffer[1][0] = iconRegister.registerIcon("wirelessredstone:bottomon");
        this.iconBuffer[1][1] = iconRegister.registerIcon("wirelessredstone:topon");
        this.iconBuffer[1][2] = iconRegister.registerIcon("wirelessredstone:txon");
        this.iconBuffer[1][3] = iconRegister.registerIcon("wirelessredstone:txon");
        this.iconBuffer[1][4] = iconRegister.registerIcon("wirelessredstone:txon");
        this.iconBuffer[1][5] = iconRegister.registerIcon("wirelessredstone:txon");
    }

    public BlockRedstoneWirelessT(int i, float hardness, float resistance) {
        super(i, hardness, resistance);
        this.setStepSound(Block.soundTypeMetal);
    }

    @Override
    public void setState(World world, int i, int j, int k, boolean state) {
        super.setState(world, i, j, k, state);
        String freq = this.getFreq(world, i, j, k);
        RedstoneEther.getInstance().setTransmitterState(world, i, j, k, freq, state);
    }

    @Override
    public void changeFreq(World world, int i, int j, int k, Object oldFreq, Object freq) {
        RedstoneEther.getInstance().remTransmitter(world, i, j, k, oldFreq);
        RedstoneEther.getInstance().addTransmitter(world, i, j, k, freq);
        RedstoneEther.getInstance().setTransmitterState(world, i, j, k, freq, this.getState((IBlockAccess)world, i, j, k));
    }

    @Override
    protected void onBlockRedstoneWirelessAdded(World world, int i, int j, int k) {
        RedstoneEther.getInstance().addTransmitter(world, i, j, k, this.getFreq(world, i, j, k));
        this.onBlockRedstoneWirelessNeighborChange(world, i, j, k, (Block)Blocks.redstone_wire);
    }

    @Override
    protected void onBlockRedstoneWirelessRemoved(World world, int i, int j, int k) {
        RedstoneEther.getInstance().remTransmitter(world, i, j, k, this.getFreq(world, i, j, k));
    }

    @Override
    protected boolean onBlockRedstoneWirelessActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        TileEntity tileentity = world.getTileEntity(i, j, k);
        if (tileentity != null && tileentity instanceof TileEntityRedstoneWirelessT) {
            entityplayer.openGui((Object)WirelessRedstone.instance, 0, world, i, j, k);
        }
        return true;
    }

    @Override
    protected void onBlockRedstoneWirelessNeighborChange(World world, int i, int j, int k, Block block) {
        if (block.equals((Object)this)) {
            return;
        }
        if (!(block == null || block.equals(Blocks.air) || this.getState((IBlockAccess)world, i, j, k) || world.getBlockPowerInput(i, j, k) <= 0 && !world.isBlockIndirectlyGettingPowered(i, j, k))) {
            this.setState(world, i, j, k, true);
        } else if (this.getState((IBlockAccess)world, i, j, k) && world.getBlockPowerInput(i, j, k) <= 0 && !world.isBlockIndirectlyGettingPowered(i, j, k)) {
            this.setState(world, i, j, k, false);
        }
    }

    @Override
    protected IIcon getBlockRedstoneWirelessTexture(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        if (this.getState(iblockaccess, i, j, k)) {
            return this.getIconFromStateAndSide(1, l);
        }
        return this.getBlockRedstoneWirelessTextureFromSide(l);
    }

    @Override
    protected IIcon getBlockRedstoneWirelessTextureFromSide(int l) {
        return this.getIconFromStateAndSide(0, l);
    }

    @Override
    protected TileEntityRedstoneWireless getBlockRedstoneWirelessEntity() {
        return new TileEntityRedstoneWirelessT();
    }

    @Override
    protected void updateRedstoneWirelessTick(World world, int i, int j, int k, Random random) {
    }

    @Override
    protected int isRedstoneWirelessPoweringTo(World world, int i, int j, int k, int l) {
        return 0;
    }

    @Override
    protected int isRedstoneWirelessIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
        return 0;
    }

    @Override
    protected boolean isBlockRedstoneWirelessSolidOnSide(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    @Override
    protected boolean isBlockRedstoneWirelessOpaqueCube() {
        return true;
    }
}

