/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.slimevoid.wirelessredstone.block.BlockRedstoneWireless;
import net.slimevoid.wirelessredstone.core.WirelessRedstone;
import net.slimevoid.wirelessredstone.ether.RedstoneEther;
import net.slimevoid.wirelessredstone.network.handlers.RedstoneEtherPacketHandler;
import net.slimevoid.wirelessredstone.tileentity.TileEntityRedstoneWireless;
import net.slimevoid.wirelessredstone.tileentity.TileEntityRedstoneWirelessR;

public class BlockRedstoneWirelessR
extends BlockRedstoneWireless {
    private boolean initialSchedule;

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        this.iconBuffer = new IIcon[2][6];
        this.iconBuffer[0][0] = iconRegister.registerIcon("wirelessredstone:bottomoff");
        this.iconBuffer[0][1] = iconRegister.registerIcon("wirelessredstone:topoff");
        this.iconBuffer[0][2] = iconRegister.registerIcon("wirelessredstone:rxoff");
        this.iconBuffer[0][3] = iconRegister.registerIcon("wirelessredstone:rxoff");
        this.iconBuffer[0][4] = iconRegister.registerIcon("wirelessredstone:rxoff");
        this.iconBuffer[0][5] = iconRegister.registerIcon("wirelessredstone:rxoff");
        this.iconBuffer[1][0] = iconRegister.registerIcon("wirelessredstone:bottomon");
        this.iconBuffer[1][1] = iconRegister.registerIcon("wirelessredstone:topon");
        this.iconBuffer[1][2] = iconRegister.registerIcon("wirelessredstone:rxon");
        this.iconBuffer[1][3] = iconRegister.registerIcon("wirelessredstone:rxon");
        this.iconBuffer[1][4] = iconRegister.registerIcon("wirelessredstone:rxon");
        this.iconBuffer[1][5] = iconRegister.registerIcon("wirelessredstone:rxon");
    }

    public BlockRedstoneWirelessR(int i, float hardness, float resistance) {
        super(i, hardness, resistance);
        this.setStepSound(Block.soundTypeMetal);
        this.setTickRandomly(true);
        this.initialSchedule = true;
    }

    public boolean hasTicked() {
        return !this.initialSchedule;
    }

    @Override
    public void changeFreq(World world, int i, int j, int k, Object oldFreq, Object freq) {
        RedstoneEther.getInstance().remReceiver(world, i, j, k, oldFreq);
        RedstoneEther.getInstance().addReceiver(world, i, j, k, freq);
        this.updateTick(world, i, j, k, null);
    }

    @Override
    protected void onBlockRedstoneWirelessAdded(World world, int i, int j, int k) {
        RedstoneEther.getInstance().addReceiver(world, i, j, k, this.getFreq(world, i, j, k));
        world.notifyBlocksOfNeighborChange(i, j, k, (Block)this);
        this.updateTick(world, i, j, k, null);
    }

    @Override
    protected void onBlockRedstoneWirelessRemoved(World world, int i, int j, int k) {
        RedstoneEther.getInstance().remReceiver(world, i, j, k, this.getFreq(world, i, j, k));
        world.notifyBlocksOfNeighborChange(i, j, k, (Block)this);
    }

    @Override
    protected boolean onBlockRedstoneWirelessActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        TileEntity tileentity = world.getTileEntity(i, j, k);
        if (tileentity != null && tileentity instanceof TileEntityRedstoneWirelessR) {
            entityplayer.openGui((Object)WirelessRedstone.instance, 0, world, i, j, k);
        }
        return true;
    }

    @Override
    protected void onBlockRedstoneWirelessNeighborChange(World world, int i, int j, int k, Block block) {
        if (block.equals((Object)this)) {
            return;
        }
        this.updateTick(world, i, j, k, null);
    }

    @Override
    protected IIcon getBlockRedstoneWirelessTexture(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        if (this.getState(iblockaccess, i, j, k)) {
            return this.getIconFromStateAndSide(1, l);
        }
        return this.getBlockRedstoneWirelessTextureFromSide(l);
    }

    @Override
    protected IIcon getBlockRedstoneWirelessTextureFromSide(int side) {
        return this.getIconFromStateAndSide(0, side);
    }

    @Override
    protected TileEntityRedstoneWireless getBlockRedstoneWirelessEntity() {
        return new TileEntityRedstoneWirelessR();
    }

    @Override
    protected void updateRedstoneWirelessTick(World world, int i, int j, int k, Random random) {
        if (this.initialSchedule) {
            this.initialSchedule = false;
        }
        if (world == null) {
            return;
        }
        String freq = this.getFreq(world, i, j, k);
        boolean oldState = this.getState((IBlockAccess)world, i, j, k);
        boolean newState = RedstoneEther.getInstance().getFreqState(world, freq);
        if (newState != oldState) {
            TileEntity entity;
            this.setState(world, i, j, k, newState);
            world.markBlockForUpdate(i, j, k);
            BlockRedstoneWirelessR.notifyNeighbors(world, i, j, k, (Block)this);
            if (!world.isRemote && (entity = world.getTileEntity(i, j, k)) instanceof TileEntityRedstoneWireless) {
                RedstoneEtherPacketHandler.sendEtherTileToAll((TileEntityRedstoneWireless)entity, world);
            }
        }
    }

    @Override
    protected int isRedstoneWirelessPoweringTo(World world, int i, int j, int k, int l) {
        TileEntity entity = world.getTileEntity(i, j, k);
        if (entity instanceof TileEntityRedstoneWireless) {
            return ((TileEntityRedstoneWireless)entity).isPoweringDirection(l) && this.getState((IBlockAccess)world, i, j, k) ? 16 : 0;
        }
        return 0;
    }

    @Override
    protected int isRedstoneWirelessIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
        TileEntity entity = world.getTileEntity(i, j, k);
        if (entity instanceof TileEntityRedstoneWireless) {
            if (!((TileEntityRedstoneWireless)entity).isPoweringIndirectly(l)) {
                return 0;
            }
            return this.isProvidingStrongPower((IBlockAccess)world, i, j, k, l);
        }
        return 0;
    }

    @Override
    protected boolean isBlockRedstoneWirelessSolidOnSide(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return this.isOpaqueCube();
    }

    @Override
    protected boolean isBlockRedstoneWirelessOpaqueCube() {
        return false;
    }
}

