/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.slimevoid.wirelessredstone.api.IBlockRedstoneWirelessOverride;
import net.slimevoid.wirelessredstone.client.presentation.BlockRedstoneWirelessRenderer;
import net.slimevoid.wirelessredstone.core.WRCore;
import net.slimevoid.wirelessredstone.data.LoggerRedstoneWireless;
import net.slimevoid.wirelessredstone.tileentity.TileEntityRedstoneWireless;

public abstract class BlockRedstoneWireless
extends BlockContainer {
    private List<IBlockRedstoneWirelessOverride> overrides;
    protected IIcon[][] iconBuffer;

    protected IIcon getIconFromStateAndSide(int state, int side) {
        if (this.iconBuffer == null) {
            return this.blockIcon;
        }
        state = state < 0 || state >= this.iconBuffer.length ? 0 : state;
        side = side < 0 || side >= this.iconBuffer[state].length ? 0 : side;
        return this.iconBuffer[state][side];
    }

    public void registerBlockIcons(IIconRegister iconRegister) {
        this.registerIcons(iconRegister);
    }

    public abstract void registerIcons(IIconRegister var1);

    protected BlockRedstoneWireless(int i, float hardness, float resistance) {
        super(Material.circuits);
        this.setHardness(hardness);
        this.setResistance(resistance);
        this.setCreativeTab(WRCore.wirelessRedstone);
        this.overrides = new ArrayList<IBlockRedstoneWirelessOverride>();
    }

    public void addOverride(IBlockRedstoneWirelessOverride override) {
        this.overrides.add(override);
    }

    public synchronized void setState(World world, int i, int j, int k, boolean state) {
        LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).write(world.isRemote, "setState(world," + i + "," + j + "," + k + "," + state + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        try {
            TileEntity tRW = world.getTileEntity(i, j, k);
            if (tRW != null && tRW instanceof TileEntityRedstoneWireless) {
                ((TileEntityRedstoneWireless)tRW).setState(state);
            }
            world.markBlockForUpdate(i, j, k);
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).writeStackTrace(e);
        }
    }

    public synchronized boolean getState(IBlockAccess iblockaccess, int i, int j, int k) {
        LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).write(false, "getState(world," + i + "," + j + "," + k + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        boolean state = false;
        try {
            TileEntity tRW = iblockaccess.getTileEntity(i, j, k);
            if (tRW != null && tRW instanceof TileEntityRedstoneWireless) {
                state = ((TileEntityRedstoneWireless)tRW).getState();
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).writeStackTrace(e);
        }
        return state;
    }

    public static boolean getState(int meta) {
        return (meta & 1) == 1;
    }

    public String getFreq(World world, int i, int j, int k) {
        LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).write(world.isRemote, "getFreq(world," + i + "," + j + "," + k + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        try {
            TileEntity tileentity = world.getTileEntity(i, j, k);
            if (tileentity == null) {
                return null;
            }
            if (tileentity instanceof TileEntityRedstoneWireless) {
                return ((TileEntityRedstoneWireless)tileentity).getFreq().toString();
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).writeStackTrace(e);
        }
        return null;
    }

    public abstract void changeFreq(World var1, int var2, int var3, int var4, Object var5, Object var6);

    public void onBlockAdded(World world, int i, int j, int k) {
        LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).write(world.isRemote, "onBlockAdded(world," + i + "," + j + "," + k + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        boolean prematureExit = false;
        for (IBlockRedstoneWirelessOverride override : this.overrides) {
            if (!override.beforeBlockRedstoneWirelessAdded(world, i, j, k)) continue;
            prematureExit = true;
        }
        if (prematureExit) {
            return;
        }
        try {
            TileEntityRedstoneWireless entity = (TileEntityRedstoneWireless)this.createNewTileEntity(world, 0);
            world.setTileEntity(i, j, k, (TileEntity)entity);
            this.onBlockRedstoneWirelessAdded(world, i, j, k);
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).writeStackTrace(e);
        }
        for (IBlockRedstoneWirelessOverride override : this.overrides) {
            override.afterBlockRedstoneWirelessAdded(world, i, j, k);
        }
    }

    protected abstract void onBlockRedstoneWirelessAdded(World var1, int var2, int var3, int var4);

    public void breakBlock(World world, int i, int j, int k, Block block, int m) {
        LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).write(world.isRemote, "onBlockRemoval(world," + i + "," + j + "," + k + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        boolean prematureExit = false;
        for (IBlockRedstoneWirelessOverride override : this.overrides) {
            if (!override.beforeBlockRedstoneWirelessRemoved(world, i, j, k, block, m)) continue;
            prematureExit = true;
        }
        if (prematureExit) {
            return;
        }
        try {
            this.onBlockRedstoneWirelessRemoved(world, i, j, k);
            world.removeTileEntity(i, j, k);
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).writeStackTrace(e);
        }
        for (IBlockRedstoneWirelessOverride override : this.overrides) {
            override.afterBlockRedstoneWirelessRemoved(world, i, j, k);
        }
    }

    protected abstract void onBlockRedstoneWirelessRemoved(World var1, int var2, int var3, int var4);

    public boolean onBlockActivated(World world, int i, int j, int k, EntityPlayer entityplayer, int q, float a, float b, float c) {
        LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).write(world.isRemote, "blockActivated(world," + i + "," + j + "," + k + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        boolean prematureExit = false;
        for (IBlockRedstoneWirelessOverride override : this.overrides) {
            if (!override.beforeBlockRedstoneWirelessActivated(world, i, j, k, entityplayer)) continue;
            prematureExit = true;
        }
        if (prematureExit) {
            return false;
        }
        boolean output = false;
        try {
            output = this.onBlockRedstoneWirelessActivated(world, i, j, k, entityplayer);
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).writeStackTrace(e);
            return false;
        }
        for (IBlockRedstoneWirelessOverride override : this.overrides) {
            override.afterBlockRedstoneWirelessActivated(world, i, j, k, entityplayer);
        }
        return output;
    }

    protected abstract boolean onBlockRedstoneWirelessActivated(World var1, int var2, int var3, int var4, EntityPlayer var5);

    public void onNeighborBlockChange(World world, int i, int j, int k, Block block) {
        LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).write(world.isRemote, "onNeighborBlockChange(world," + i + "," + j + "," + k + "," + block.getLocalizedName() + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        boolean prematureExit = false;
        for (IBlockRedstoneWirelessOverride override : this.overrides) {
            if (!override.beforeBlockRedstoneWirelessNeighborChange(world, i, j, k, block)) continue;
            prematureExit = true;
        }
        if (prematureExit) {
            return;
        }
        try {
            this.onBlockRedstoneWirelessNeighborChange(world, i, j, k, block);
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).writeStackTrace(e);
        }
        for (IBlockRedstoneWirelessOverride override : this.overrides) {
            override.afterBlockRedstoneWirelessNeighborChange(world, i, j, k, block);
        }
    }

    protected abstract void onBlockRedstoneWirelessNeighborChange(World var1, int var2, int var3, int var4, Block var5);

    public boolean isOpaqueCube() {
        return this.isBlockRedstoneWirelessOpaqueCube();
    }

    public boolean canProvidePower() {
        return true;
    }

    public IIcon getIcon(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        IIcon output;
        try {
            output = this.getBlockRedstoneWirelessTexture(iblockaccess, i, j, k, l);
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).writeStackTrace(e);
            output = this.blockIcon;
        }
        for (IBlockRedstoneWirelessOverride override : this.overrides) {
            if (!override.shouldOverrideTextureAt(iblockaccess, i, j, k, l)) continue;
            output = override.getBlockTexture(iblockaccess, i, j, k, l, output);
        }
        return output;
    }

    protected abstract IIcon getBlockRedstoneWirelessTexture(IBlockAccess var1, int var2, int var3, int var4, int var5);

    protected abstract IIcon getBlockRedstoneWirelessTextureFromSide(int var1);

    public IIcon getIcon(int side, int metadata) {
        try {
            return this.getBlockRedstoneWirelessTextureFromSide(side);
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).writeStackTrace(e);
            return this.blockIcon;
        }
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return this.getBlockRedstoneWirelessEntity();
    }

    protected abstract TileEntityRedstoneWireless getBlockRedstoneWirelessEntity();

    public static void notifyNeighbors(World world, int i, int j, int k, Block block) {
        LoggerRedstoneWireless.getInstance("BlockRedstoneWireless").write(world.isRemote, "notifyNeighbors(world," + i + "," + j + "," + k + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        world.notifyBlocksOfNeighborChange(i, j, k, block, 0);
        world.notifyBlocksOfNeighborChange(i - 1, j, k, block, 0);
        world.notifyBlocksOfNeighborChange(i + 1, j, k, block, 0);
        world.notifyBlocksOfNeighborChange(i, j - 1, k, block, 0);
        world.notifyBlocksOfNeighborChange(i, j + 1, k, block, 0);
        world.notifyBlocksOfNeighborChange(i, j, k - 1, block, 0);
        world.notifyBlocksOfNeighborChange(i, j, k + 1, block, 0);
    }

    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).write(world.isRemote, "updateTick(world," + i + "," + j + "," + k + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        boolean prematureExit = false;
        for (IBlockRedstoneWirelessOverride override : this.overrides) {
            if (!override.beforeUpdateRedstoneWirelessTick(world, i, j, k, random)) continue;
            prematureExit = true;
        }
        if (prematureExit) {
            return;
        }
        try {
            this.updateRedstoneWirelessTick(world, i, j, k, random);
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).writeStackTrace(e);
        }
        for (IBlockRedstoneWirelessOverride override : this.overrides) {
            override.afterUpdateRedstoneWirelessTick(world, i, j, k, random);
        }
    }

    protected abstract void updateRedstoneWirelessTick(World var1, int var2, int var3, int var4, Random var5);

    public int isProvidingStrongPower(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        try {
            if (iblockaccess instanceof World) {
                LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).write(((World)iblockaccess).isRemote, "isPoweringTo(iblockaccess," + i + "," + j + "," + k + "," + l + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
                return this.isRedstoneWirelessPoweringTo((World)iblockaccess, i, j, k, l);
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).writeStackTrace(e);
        }
        return 0;
    }

    protected abstract int isRedstoneWirelessPoweringTo(World var1, int var2, int var3, int var4, int var5);

    public int isProvidingWeakPower(IBlockAccess world, int i, int j, int k, int l) {
        if (world instanceof World) {
            LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).write(((World)world).isRemote, "isIndirectlyPoweringTo(world," + i + "," + j + "," + k + "," + l + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
            try {
                return this.isRedstoneWirelessIndirectlyPoweringTo((World)world, i, j, k, l);
            }
            catch (Exception e) {
                LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).writeStackTrace(e);
            }
        }
        return 0;
    }

    protected abstract int isRedstoneWirelessIndirectlyPoweringTo(World var1, int var2, int var3, int var4, int var5);

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return this.isBlockRedstoneWirelessSolidOnSide(world, x, y, z, side);
    }

    protected abstract boolean isBlockRedstoneWirelessSolidOnSide(IBlockAccess var1, int var2, int var3, int var4, ForgeDirection var5);

    protected abstract boolean isBlockRedstoneWirelessOpaqueCube();

    public int getRenderType() {
        return BlockRedstoneWirelessRenderer.renderID;
    }
}

