/*
 * Decompiled with CFR 0.152.
 */
package us.everythingisawesome.threading;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.wikipedia.Wiki;
import us.everythingisawesome.WikiTool;
import us.everythingisawesome.WikiUtil;

public class RunnableFetchPage
implements Runnable {
    String page;
    String finalString;

    public RunnableFetchPage(String page) {
        this.page = page;
        this.finalString = "";
    }

    @Override
    public void run() {
        WikiUtil.state = WikiUtil.FetchState.SEARCHING;
        this.finalString = "";
        for (Wiki wiki : WikiTool.wikis) {
            WikiUtil.state = WikiUtil.FetchState.READING;
            try {
                this.finalString = this.finalString + wiki.getPageText(this.page);
            }
            catch (FileNotFoundException e) {
                WikiTool.log.info(this.page + " was not found on " + wiki.getDomain());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        WikiUtil.state = WikiUtil.FetchState.PARSING;
        this.finalString = this.removeGarbageContent(this.finalString);
        WikiUtil.cache.put(this.page, this.finalString);
        WikiUtil.resetFetch();
        WikiUtil.state = WikiUtil.FetchState.DONE;
    }

    private String removeGarbageContent(String input) {
        for (int i = 0; i < input.length() / 6; ++i) {
            input = input.replaceFirst("'''", "\u00a7l");
            input = input.replaceFirst("'''", "\u00a7r");
            input = input.replaceFirst("''", "\u00a7o");
            input = input.replaceFirst("''", "\u00a7r");
        }
        return input.replaceAll("\\{\\{cleanup\\}\\}\\n", "").replaceAll("\\{\\{[mM]inecraft\\}\\}\\n", "").replaceAll("\\[\\[(?=[^FILE])", "\u00a73").replaceAll("\\[\\[", "").replaceAll("\\]\\]", "\u00a7f");
    }
}

