/*
 * Decompiled with CFR 0.152.
 */
package us.everythingisawesome;

import java.util.TreeMap;
import us.everythingisawesome.WikiTool;
import us.everythingisawesome.threading.RunnableFetchPage;

public class WikiUtil {
    private static Thread fetchPageThread = null;
    public static FetchState state = FetchState.NONE;
    public static TreeMap<String, String> cache = new TreeMap();

    public static String getPage(String page) {
        if (cache.containsKey(page)) {
            return cache.get(page);
        }
        if (state == FetchState.DONE || state == FetchState.NONE) {
            WikiUtil.fetchPage(page);
            return "";
        }
        return "";
    }

    public static String getLastPage() {
        if (state == FetchState.DONE) {
            return cache.get(cache.lastKey());
        }
        return "";
    }

    public static void fetchPage(String page) {
        while (cache.size() > 15) {
            WikiTool.log.info("Removing " + cache.lastKey() + " from the cache! (Limit 15 cached pages)");
            cache.remove(cache.lastKey());
        }
        if (fetchPageThread != null) {
            WikiTool.log.info("Already fetching another page, please wait!");
        } else {
            fetchPageThread = new Thread(new RunnableFetchPage(page));
            fetchPageThread.start();
        }
    }

    public static void resetFetch() {
        fetchPageThread = null;
    }

    public static enum FetchState {
        NONE,
        SEARCHING,
        READING,
        PARSING,
        DONE;

    }
}

