/*
 * Decompiled with CFR 0.152.
 */
package us.everythingisawesome;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Mouse;
import org.wikipedia.Wiki;
import us.everythingisawesome.ui.GuiWikiButton;
import us.everythingisawesome.ui.GuiWikiScreen;

@Mod(modid="WikiTool", name="WikiTool", version="v@VERSION@")
public class WikiTool {
    public static ArrayList<Wiki> wikis = new ArrayList();
    public static Logger log;
    private GuiWikiButton button = new GuiWikiButton(5, 2);
    protected static TreeMap<String, String> guiEquivs;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        log = event.getModLog();
        log.info("Starting initialization of default wikis");
        Wiki ftbWiki = new Wiki("ftbwiki.org", "");
        ftbWiki.setUsingCompressedRequests(false);
        Wiki mcWiki = new Wiki("minecraft.gamepedia.com", "");
        mcWiki.setUsingCompressedRequests(false);
        wikis.add(mcWiki);
        wikis.add(ftbWiki);
        log.info("Finished initializing " + wikis.size() + " wikis.");
        log.info("Loading vanilla gui wiki pages");
        BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/assets/wikitool/guiwikiequiv.txt")));
        String line = "";
        try {
            while ((line = in.readLine()) != null) {
                String[] split = line.split("=");
                guiEquivs.put(split[0], split[1]);
            }
            log.info("Done loading " + guiEquivs.size() + " pages.");
        }
        catch (IOException e) {
            log.error("Error loading vanilla gui wiki pages. Skipping.");
        }
    }

    public static String getEquiv(Object clazz) {
        if (guiEquivs.containsKey(clazz.getClass().getName())) {
            return guiEquivs.get(clazz.getClass().getName());
        }
        return clazz.getClass().getName();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        for (String s : guiEquivs.keySet()) {
            log.info(s + " : " + guiEquivs.get(s));
        }
    }

    @SubscribeEvent
    public void RenderTickEvent(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!(event.type != TickEvent.Type.RENDER && event.type != TickEvent.Type.CLIENT || event.phase != TickEvent.Phase.END || mc.field_71462_r instanceof GuiWikiScreen || mc.field_71462_r == null)) {
            int mouseX = Mouse.getX() * mc.field_71462_r.field_146294_l / mc.field_71443_c;
            int mouseY = mc.field_71462_r.field_146295_m - Mouse.getY() * mc.field_71462_r.field_146295_m / mc.field_71440_d - 1;
            this.button.func_146112_a(Minecraft.func_71410_x(), mouseX, mouseY);
        }
    }

    public static void main(String[] args) {
        try {
            for (Wiki wiki : wikis) {
                System.out.println(wiki.getSiteInfo().get("Title"));
                for (String s : wiki.getAllCategories()) {
                    System.out.println(s);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        guiEquivs = new TreeMap();
    }
}

