/*
 * Decompiled with CFR 0.152.
 */
package com.countrygamer.weepingangels.Entity;

import com.countrygamer.core.common.lib.CoreUtil;
import com.countrygamer.weepingangels.Handlers.Player.ExtendedPlayer;
import com.countrygamer.weepingangels.WeepingAngelsMod;
import com.countrygamer.weepingangels.lib.Util;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class EntityWeepingAngel
extends EntityCreature {
    private boolean canSeeSkyAndDay;
    private int torchTimer;
    private int torchNextBreak;
    private boolean breakOnePerTick;
    private boolean didBreak;
    public boolean armMovement;
    public boolean aggressiveArmMovement;
    private float moveSpeed;
    private float maxSpeed = 50.0f;
    private float minSpeed = 0.3f;
    private final double closestPlayerRadius = 64.0;
    private double distanceToSeen = 5.0;
    private double minLight = 1.0;
    private boolean isQuantumLocked;
    private boolean isLockedByAngel;

    public EntityWeepingAngel(World world) {
        super(world);
        this.field_70728_aV = 50;
        this.field_70178_ae = true;
        this.isQuantumLocked = false;
        this.isLockedByAngel = false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(WeepingAngelsMod.maxHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.minSpeed);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)WeepingAngelsMod.attackStrength);
    }

    protected String func_70639_aQ() {
        return "weepingangels:stone";
    }

    protected String func_70621_aR() {
        return "weepingangels:light";
    }

    protected String func_70673_aS() {
        return "weepingangels:crumble";
    }

    protected boolean func_70650_aV() {
        return false;
    }

    public void func_70636_d() {
        this.func_82168_bl();
        float f = this.func_70013_c(1.0f);
        if (f > 0.5f) {
            this.field_70708_bq += 2;
        }
        super.func_70636_d();
    }

    public void func_70071_h_() {
        EntityPlayer player;
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u.func_151525_a() <= EnumDifficulty.PEACEFUL.func_151525_a()) {
            this.func_70106_y();
        }
        this.field_70701_bs = 0.0f;
        this.field_70702_br = 0.0f;
        this.moveSpeed = this.minSpeed;
        this.field_70703_bu = false;
        if (this.field_70170_p.func_72935_r()) {
            float f = this.func_70013_c(1.0f);
            this.canSeeSkyAndDay = f > 0.5f && this.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)) && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f;
        }
        if ((double)this.field_70170_p.func_72883_k(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)) > 1.0) {
            this.isQuantumLocked = Util.canBeSeenMulti(this.field_70170_p, this.field_70121_D, this.closestPlayerRadius, (EntityLivingBase)this);
        }
        if (this.field_70789_a == null && (player = (EntityPlayer)this.getClosestPlayer(EntityPlayer.class)) != null) {
            this.field_70789_a = player;
        }
        this.moveSpeed = this.field_70789_a != null ? this.maxSpeed : this.minSpeed;
        if (this.isQuantumLocked) {
            this.moveSpeed = 0.0f;
            if (this.field_70789_a instanceof EntityPlayer) {
                int maxTorchTicks = 200;
                if (this.field_70180_af.func_75679_c(18) < 0) {
                    this.field_70180_af.func_75692_b(18, (Object)0);
                }
                if (this.getLightValue() > 1.0 && !this.canSeeSkyAndDay && this.field_70180_af.func_75679_c(18) <= 0 && this.field_70789_a != null && this.findNearestTorch()) {
                    this.field_70180_af.func_75692_b(18, (Object)maxTorchTicks);
                }
                if (this.field_70180_af.func_75679_c(18) > 0) {
                    this.field_70180_af.func_75692_b(18, (Object)(this.field_70180_af.func_75679_c(18) - 1));
                }
            }
        }
        if (this.field_70789_a != null && !this.isQuantumLocked) {
            this.func_70625_a(this.field_70789_a, 100.0f, 100.0f);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.moveSpeed);
        int r = 10;
        double x = this.field_70165_t;
        double y = this.field_70163_u;
        double z = this.field_70161_v;
        int i = (int)x - r;
        while ((double)i < x + (double)r) {
            int k = (int)z - r;
            while ((double)k < z + (double)r) {
                int j = (int)y - r;
                while ((double)j < y + (double)r) {
                    if (this.field_70170_p.func_147439_a(i, j, k) == Blocks.field_150356_k || this.field_70170_p.func_147439_a(i, j, k) == Blocks.field_150353_l) {
                        this.func_70691_i(0.05f);
                    }
                    ++j;
                }
                ++k;
            }
            ++i;
        }
        this.renderMovement();
        super.func_70071_h_();
    }

    private boolean findNearestTorch() {
        int i = (int)this.field_70165_t;
        int j = (int)this.field_70163_u;
        int k = (int)this.field_70161_v;
        int radius = 10;
        int maxRadius = 100;
        for (int i1 = i - radius; i1 < i + radius; ++i1) {
            for (int k1 = k - radius; k1 < k + radius; ++k1) {
                for (int j1 = j - radius * 2; j1 < j + radius / 2; ++j1) {
                    Block block;
                    if (!(this.getDistance(i, j, k, i1, j1, k1) < (double)maxRadius) || (block = this.field_70170_p.func_147439_a(i1, j1, k1)) == null || block != Blocks.field_150478_aa) continue;
                    block.func_149697_b(this.field_70170_p, i1, j1, k1, 1, 1);
                    this.field_70170_p.func_147468_f(i1, j1, k1);
                    return true;
                }
            }
        }
        return false;
    }

    private void renderMovement() {
        if (!this.isQuantumLocked) {
            if (this.getAngelsNear().size() > 0) {
                this.field_70180_af.func_75692_b(17, (Object)0);
            }
            if (this.field_70789_a == null) {
                return;
            }
            if (this.field_70789_a instanceof EntityPlayer) {
                double distance = this.getDistancetoEntityToAttack();
                if (distance <= 5.0) {
                    this.field_70180_af.func_75692_b(16, (Object)1);
                    this.field_70180_af.func_75692_b(17, (Object)2);
                } else {
                    this.field_70180_af.func_75692_b(16, (Object)0);
                    this.field_70180_af.func_75692_b(17, (Object)0);
                    if (this.field_70146_Z.nextInt(100) > 80) {
                        this.field_70180_af.func_75692_b(17, (Object)1);
                    }
                }
            }
        }
    }

    public boolean func_70652_k(Entity par1Entity) {
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        boolean flag = par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f);
        return flag;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source == null) {
            return false;
        }
        if (source.func_76364_f() instanceof EntityPlayer) {
            boolean canHurt = false;
            EntityPlayer entityplayer = (EntityPlayer)source.func_76364_f();
            ItemStack itemStack = entityplayer.field_71071_by.func_70448_g();
            if (itemStack != null && itemStack.func_77973_b() == WeepingAngelsMod.sonicScrew) {
                super.func_70097_a(source, 0.25f * this.func_110138_aP());
                return true;
            }
            if (WeepingAngelsMod.pickOnly) {
                if (itemStack == null) {
                    canHurt = false;
                } else {
                    canHurt = itemStack.func_77973_b().canHarvestBlock(Blocks.field_150343_Z, itemStack);
                    if (this.field_70170_p.field_73013_u.func_151525_a() >= EnumDifficulty.NORMAL.func_151525_a()) {
                        canHurt = canHurt || itemStack.func_77973_b().func_150897_b(Blocks.field_150352_o);
                    }
                }
            } else {
                canHurt = true;
            }
            if (canHurt) {
                super.func_70097_a(source, damage);
                return true;
            }
        }
        return false;
    }

    protected void func_70785_a(Entity entity, float f) {
        if (entity != null && !Util.canBeSeenMulti(this.field_70170_p, this.field_70121_D, this.closestPlayerRadius, (EntityLivingBase)this) && entity instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)entity;
            if (!entityPlayer.field_71075_bZ.field_75098_d && this.getDistancetoEntityToAttack() <= 2.0) {
                if (WeepingAngelsMod.canPoison && this.field_70146_Z.nextInt(100) < WeepingAngelsMod.poisonChance) {
                    ExtendedPlayer playerProps = ExtendedPlayer.get(entityPlayer);
                    playerProps.setConvert(1);
                    playerProps.setAngelHealth(0.0f);
                    playerProps.setTicksTillAngelHeal(ExtendedPlayer.ticksPerHalfHeart);
                } else if (WeepingAngelsMod.canTeleport && this.field_70146_Z.nextInt(100) < WeepingAngelsMod.teleportChance) {
                    CoreUtil.teleportPlayer((EntityPlayer)entityPlayer, (int)0, (int)WeepingAngelsMod.teleportRangeMax, (double)entityPlayer.field_70165_t, (double)entityPlayer.field_70161_v, (boolean)true, (boolean)true);
                    this.field_70170_p.func_72956_a((Entity)entityPlayer, "weepingangels:teleport_activate", 1.0f, 1.0f);
                    entity = null;
                } else {
                    this.func_70652_k(entity);
                }
            }
        }
    }

    public float func_70783_a(int par1, int par2, int par3) {
        return 0.5f - this.field_70170_p.func_72801_o(par1, par2, par3);
    }

    public boolean func_70601_bi() {
        if (WeepingAngelsMod.spawnRate == 0) {
            return false;
        }
        boolean validYLevel = false;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int j2 = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int y = MathHelper.func_76128_c((double)(this.field_70163_u + (double)j2));
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        if (y <= WeepingAngelsMod.maxSpawnHeight) {
            validYLevel = true;
        }
        boolean entityMobCanSpawn = this.field_70170_p.field_73013_u != EnumDifficulty.EASY && this.isValidLightLevel() && super.func_70601_bi();
        return entityMobCanSpawn && validYLevel;
    }

    private double getLightValue() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        return this.field_70170_p.func_72957_l(i, j, k);
    }

    public int angryState() {
        return this.field_70180_af.func_75683_a(16);
    }

    public int armState() {
        return this.field_70180_af.func_75683_a(17);
    }

    private Entity getClosestPlayer(Class<?> entity) {
        List list = this.field_70170_p.func_72872_a(entity, this.field_70121_D.func_72314_b(this.closestPlayerRadius, 20.0, this.closestPlayerRadius));
        if (!list.isEmpty()) {
            return (Entity)list.get(0);
        }
        return null;
    }

    protected void func_70600_l(int par1) {
        if (WeepingAngelsMod.addonVortex) {
            this.func_145779_a(WeepingAngelsMod.chronon, 1);
        }
    }

    protected boolean isValidLightLevel() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_72972_b(EnumSkyBlock.Sky, i, j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), k = MathHelper.func_76128_c((double)this.field_70161_v)) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int l = this.field_70170_p.func_72957_l(i, j, k);
        if (this.field_70170_p.func_72911_I()) {
            int i1 = this.field_70170_p.field_73008_k;
            this.field_70170_p.field_73008_k = 10;
            l = this.field_70170_p.func_72957_l(i, j, k);
            this.field_70170_p.field_73008_k = i1;
        }
        return l <= this.field_70146_Z.nextInt(8);
    }

    private List<?> getAngelsNear() {
        return this.field_70170_p.func_72872_a(EntityWeepingAngel.class, this.field_70121_D.func_72314_b(20.0, 20.0, 20.0));
    }

    private boolean canBeSeenByAngel() {
        List<?> list = this.getAngelsNear();
        int angelsWatching = 0;
        for (int j = 0; j < list.size(); ++j) {
            EntityWeepingAngel angel = (EntityWeepingAngel)((Object)list.get(j));
            boolean same = this.field_70165_t == angel.field_70165_t && this.field_70163_u == angel.field_70163_u && this.field_70161_v == angel.field_70161_v;
            boolean bl = same = angel == this;
            if (same || !angel.canSeeAngel(this)) continue;
            ++angelsWatching;
        }
        return angelsWatching > 0;
    }

    private boolean canSeeAngel(EntityWeepingAngel entity) {
        if ((double)this.field_70170_p.func_72883_k(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)) <= 1.0) {
            return false;
        }
        if (this.field_70180_af.func_75683_a(17) >= 2) {
            return Util.isInFieldOfVision(this.field_70170_p, (EntityLivingBase)entity, (EntityLivingBase)this);
        }
        return false;
    }

    private boolean isEntityFacing(EntityLivingBase entity) {
        int directionOfEntity = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        double thisZ = this.field_70161_v;
        double thisX = this.field_70165_t;
        double entZ = entity.field_70161_v;
        double entX = entity.field_70165_t;
        if (directionOfEntity == 0 && thisZ > entZ) {
            return true;
        }
        if (directionOfEntity == 1 && thisX < entX) {
            return true;
        }
        if (directionOfEntity == 2 && thisZ < entZ) {
            return true;
        }
        return directionOfEntity == 3 && thisX > entX;
    }

    public double getDistance(int i, int j, int k, int l, int i1, int j1) {
        int k1 = l - i;
        int l1 = i1 - j;
        int i2 = j1 - k;
        return Math.sqrt(k1 * k1 + l1 * l1 + i2 * i2);
    }

    public double getDistancetoEntityToAttack() {
        if (this.field_70789_a instanceof EntityPlayer) {
            double d = this.field_70789_a.field_70165_t - this.field_70165_t;
            double d2 = this.field_70789_a.field_70163_u - this.field_70163_u;
            double d4 = this.field_70789_a.field_70161_v - this.field_70161_v;
            return MathHelper.func_76133_a((double)(d * d + d2 * d2 + d4 * d4));
        }
        EntityPlayer entityplayer = this.field_70170_p.func_72890_a((Entity)this, this.closestPlayerRadius);
        if (entityplayer != null) {
            double d1 = entityplayer.field_70165_t - this.field_70165_t;
            double d3 = entityplayer.field_70163_u - this.field_70163_u;
            double d5 = entityplayer.field_70161_v - this.field_70161_v;
            return MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3 + d5 * d5));
        }
        return 40000.0;
    }
}

