/*
 * Decompiled with CFR 0.152.
 */
package com.countrygamer.weepingangels.Client.Gui;

import com.countrygamer.core.Base.client.gui.GuiButtonArrow;
import com.countrygamer.core.Base.common.packet.AbstractPacket;
import com.countrygamer.core.common.Core;
import com.countrygamer.core.common.handler.packet.PacketTeleport;
import com.countrygamer.core.common.lib.CoreUtil;
import com.countrygamer.weepingangels.Handlers.Packet.PacketStoreCoords;
import com.countrygamer.weepingangels.WeepingAngelsMod;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiVortex
extends GuiScreen {
    public static final ResourceLocation bkgd = new ResourceLocation("weepingangels", "textures/gui/" + WeepingAngelsMod.vortexManName + ".png");
    private int leftOfGui;
    private int topOfGui;
    protected int xSize = 176;
    protected int ySize = 166;
    private final EntityPlayer thePlayer;
    private final ItemStack vortexStack;
    private GuiButton teleport;
    private GuiButton saveLocation;
    private GuiButton dimension;
    private GuiButton select;
    private GuiButton selectCurrent;
    private GuiTextField indexTextBox;
    private GuiTextField nameTextBox;
    private GuiTextField dimIDText;
    private GuiTextField newXTextBox;
    private GuiTextField newYTextBox;
    private GuiTextField newZTextBox;
    private int locationIndex = 0;
    private String indexName = "";
    private String dimName = "Overworld";
    private double coordX = 0.0;
    private double coordY = 0.0;
    private double coordZ = 0.0;
    private GuiButtonArrow up;
    private GuiButtonArrow down;

    public GuiVortex(EntityPlayer player) {
        this.vortexStack = player.func_70694_bm();
        this.thePlayer = player;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.leftOfGui = this.field_146294_l / 2 - this.xSize / 2;
        this.topOfGui = this.field_146295_m / 2 - this.ySize / 2;
        int xTextFields = this.leftOfGui + (int)(0.15 * (double)this.xSize);
        int yTextFields = (int)(0.64 * (double)this.ySize);
        int actionButtonsY = this.field_146295_m / 2 + (int)(0.2 * (double)this.ySize);
        int middleOfLeft = this.field_146294_l / 2 + this.xSize / 4;
        int middleOfRight = this.field_146294_l / 2 - this.xSize / 4;
        int buttonID = 0;
        this.field_146292_n.clear();
        this.dimension = new GuiButton(++buttonID, this.leftOfGui + (int)(0.1 * (double)this.xSize), this.topOfGui + (int)(0.285 * (double)this.ySize), 75, 20, "Overworld");
        this.field_146292_n.add(this.dimension);
        int arrowX = this.field_146294_l / 2 + this.xSize / 10;
        this.up = new GuiButtonArrow(++buttonID, arrowX, this.topOfGui + (int)(0.1 * (double)this.ySize), GuiButtonArrow.ButtonType.UP);
        this.field_146292_n.add(this.up);
        this.down = new GuiButtonArrow(++buttonID, arrowX, this.topOfGui + (int)(0.2 * (double)this.ySize), GuiButtonArrow.ButtonType.DOWN);
        this.field_146292_n.add(this.down);
        this.select = new GuiButton(++buttonID, arrowX, this.topOfGui + (int)(0.5 * (double)this.ySize), 50, 20, "Select");
        this.field_146292_n.add(this.select);
        int width = 160;
        this.selectCurrent = new GuiButton(++buttonID, middleOfLeft - width / 4, actionButtonsY, width / 2, 20, "Current XYZ");
        this.field_146292_n.add(this.selectCurrent);
        this.saveLocation = new GuiButton(++buttonID, middleOfRight - width / 4, actionButtonsY, width / 2, 20, "Save Location");
        this.field_146292_n.add(this.saveLocation);
        this.teleport = new GuiButton(++buttonID, this.field_146294_l / 2 - width / 2, actionButtonsY + 25, width, 20, "Teleport");
        this.field_146292_n.add(this.teleport);
        Keyboard.enableRepeatEvents((boolean)true);
        this.indexTextBox = new GuiTextField(this.field_146289_q, this.leftOfGui + (int)(0.25 * (double)this.xSize), this.topOfGui + (int)(0.12 * (double)this.ySize), 30, 12);
        this.setupTextField(this.indexTextBox);
        this.nameTextBox = new GuiTextField(this.field_146289_q, this.leftOfGui + (int)(0.25 * (double)this.xSize), this.topOfGui + (int)(0.21 * (double)this.ySize), 30, 12);
        this.setupTextField(this.nameTextBox);
        width = 70;
        this.newXTextBox = new GuiTextField(this.field_146289_q, xTextFields, yTextFields + 0, width, 12);
        this.setupTextField(this.newXTextBox);
        this.newYTextBox = new GuiTextField(this.field_146289_q, xTextFields, yTextFields + 12, width, 12);
        this.setupTextField(this.newYTextBox);
        this.newZTextBox = new GuiTextField(this.field_146289_q, xTextFields, yTextFields + 24, width, 12);
        this.setupTextField(this.newZTextBox);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146284_a(GuiButton guiB) {
        double[] coords;
        if (guiB.field_146127_k == this.dimension.field_146127_k) {
            String currentDimName = this.dimension.field_146126_j;
            ArrayList<String> dimNames = new ArrayList<String>();
            for (String key : Core.dimensions.keySet()) {
                dimNames.add(key);
            }
            String nextDimName = this.getNext(dimNames, currentDimName);
            WeepingAngelsMod.log.info(currentDimName + ":" + nextDimName);
            this.dimension.field_146126_j = nextDimName;
            this.func_73876_c();
        }
        if (guiB.field_146127_k == this.saveLocation.field_146127_k && (coords = this.getCoords()) != null) {
            int index;
            try {
                index = Integer.parseInt(this.indexTextBox.func_146179_b());
            }
            catch (NumberFormatException err) {
                this.field_146297_k.func_147108_a(null);
                this.thePlayer.func_146105_b((IChatComponent)new ChatComponentText("Your index is wrong."));
                this.thePlayer.func_146105_b((IChatComponent)new ChatComponentText("Please type a valid index."));
                return;
            }
            this.storeCoords(index, this.nameTextBox.func_146179_b(), (Integer)Core.dimensions.get(this.dimension.field_146126_j), coords[0], coords[1], coords[2]);
        }
        if (guiB.field_146127_k == this.up.field_146127_k) {
            this.loadNextIndex(this.locationIndex, -1);
            this.func_73876_c();
        }
        if (guiB.field_146127_k == this.down.field_146127_k) {
            this.loadNextIndex(this.locationIndex, 1);
            this.func_73876_c();
        }
        if (guiB.field_146127_k == this.select.field_146127_k) {
            this.indexTextBox.func_146180_a(this.locationIndex + "");
            this.nameTextBox.func_146180_a(this.indexName);
            this.dimension.field_146126_j = this.dimName;
            this.newXTextBox.func_146180_a(this.coordX + "");
            this.newYTextBox.func_146180_a(this.coordY + "");
            this.newZTextBox.func_146180_a(this.coordZ + "");
        }
        if (guiB.field_146127_k == this.selectCurrent.field_146127_k) {
            this.dimension.field_146126_j = (String)Core.dimensions1.get(this.thePlayer.field_71093_bK);
            this.newXTextBox.func_146180_a(this.round(this.thePlayer.field_70165_t, 2) + "");
            this.newYTextBox.func_146180_a(this.round(this.thePlayer.field_70163_u, 2) + "");
            this.newZTextBox.func_146180_a(this.round(this.thePlayer.field_70161_v, 2) + "");
        }
        if (guiB.field_146127_k == this.teleport.field_146127_k) {
            coords = this.getCoords();
            if (coords != null) {
                int dimID = (Integer)Core.dimensions.get(this.dimension.field_146126_j);
                this.field_146297_k.func_147108_a(null);
                PacketTeleport packet = new PacketTeleport(dimID, coords, false, false);
                Core.packetChannel.sendToServer((AbstractPacket)packet);
            } else if (Core.DEBUG) {
                // empty if block
            }
        }
    }

    protected void func_73869_a(char letter, int par2) {
        if (this.indexTextBox.func_146201_a(letter, par2)) {
            this.sendKeyPacket(this.indexTextBox);
        } else if (this.nameTextBox.func_146201_a(letter, par2)) {
            this.sendKeyPacket(this.nameTextBox);
        } else if (this.newXTextBox.func_146201_a(letter, par2)) {
            this.sendKeyPacket(this.newXTextBox);
        } else if (this.newYTextBox.func_146201_a(letter, par2)) {
            this.sendKeyPacket(this.newYTextBox);
        } else if (this.newZTextBox.func_146201_a(letter, par2)) {
            this.sendKeyPacket(this.newZTextBox);
        } else {
            super.func_73869_a(letter, par2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendKeyPacket(GuiTextField txtField) {
        PacketBuffer packetbuffer = new PacketBuffer(Unpooled.buffer());
        try {
            packetbuffer.func_150785_a(txtField.func_146179_b());
            this.field_146297_k.func_147114_u().func_147297_a((Packet)new C17PacketCustomPayload("MC|ItemName", (ByteBuf)packetbuffer));
        }
        catch (Exception exception) {
            LogManager.getLogger().error("Couldn't send command block info", (Throwable)exception);
        }
        finally {
            packetbuffer.release();
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
        this.indexTextBox.func_146192_a(par1, par2, par3);
        this.nameTextBox.func_146192_a(par1, par2, par3);
        this.newXTextBox.func_146192_a(par1, par2, par3);
        this.newYTextBox.func_146192_a(par1, par2, par3);
        this.newZTextBox.func_146192_a(par1, par2, par3);
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.drawGuiContainerBackgroundLayer(par3, par1, par2);
        this.drawGuiContainerForegroundLayer(par1, par2);
        super.func_73863_a(par1, par2, par3);
    }

    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        String s = WeepingAngelsMod.vortexManName;
        this.field_146289_q.func_78276_b(s, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(s) / 2, this.topOfGui + (int)(0.035 * (double)this.ySize), 0x404040);
        int gray = 0x404040;
        int x = this.leftOfGui + (int)(0.07 * (double)this.xSize);
        int y = this.topOfGui + (int)(0.435 * (double)this.ySize);
        this.func_73731_b(this.field_146289_q, "Index:", x, this.topOfGui + (int)(0.13 * (double)this.ySize), 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, "Name:", x, this.topOfGui + (int)(0.225 * (double)this.ySize), 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, "X:", x, y + 0, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, "Y:", x, y + 12, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, "Z:", x, y + 24, 0xFFFFFF);
        x = this.leftOfGui + (int)(0.63 * (double)this.xSize);
        String indexAndName = this.locationIndex + " : ";
        indexAndName = this.indexName.equals("") ? indexAndName + "None" : indexAndName + this.indexName;
        this.field_146289_q.func_78276_b(indexAndName, x + (int)(0.11 * (double)this.xSize), this.topOfGui + (int)(0.165 * (double)this.ySize), 0x404040);
        this.field_146289_q.func_78276_b(this.dimName, x, this.topOfGui + (int)(0.28 * (double)this.ySize), 0x404040);
        x = this.leftOfGui + (int)(0.65 * (double)this.xSize);
        int x2 = x + (int)(0.08 * (double)this.xSize);
        this.field_146289_q.func_78276_b("X:", x, this.topOfGui + (int)(0.35 * (double)this.ySize), 0x404040);
        this.field_146289_q.func_78276_b(this.coordX + "", x2, this.topOfGui + (int)(0.35 * (double)this.ySize), 0x404040);
        this.field_146289_q.func_78276_b("Y:", x, this.topOfGui + (int)(0.4 * (double)this.ySize), 0x404040);
        this.field_146289_q.func_78276_b(this.coordY + "", x2, this.topOfGui + (int)(0.4 * (double)this.ySize), 0x404040);
        this.field_146289_q.func_78276_b("Z:", x, this.topOfGui + (int)(0.45 * (double)this.ySize), 0x404040);
        this.field_146289_q.func_78276_b(this.coordZ + "", x2, this.topOfGui + (int)(0.45 * (double)this.ySize), 0x404040);
    }

    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(bkgd);
        int k = (this.field_146294_l - this.xSize) / 2;
        int l = (this.field_146295_m - this.ySize) / 2;
        this.func_73729_b(k, l, 0, 0, this.xSize, this.ySize);
        this.indexTextBox.func_146194_f();
        this.nameTextBox.func_146194_f();
        this.newXTextBox.func_146194_f();
        this.newYTextBox.func_146194_f();
        this.newZTextBox.func_146194_f();
    }

    private void setupTextField(GuiTextField textField) {
        textField.func_146193_g(-1);
        textField.func_146204_h(-1);
        textField.func_146185_a(true);
        textField.func_146203_f(6);
    }

    private void storeCoords(int index, String name, int dimID, double x, double y, double z) {
        if (this.vortexStack != null) {
            if (index <= 0 || index >= 11) {
                this.field_146297_k.func_147108_a(null);
                this.thePlayer.func_146105_b((IChatComponent)new ChatComponentText("Indexes cannot be less than 1,"));
                this.thePlayer.func_146105_b((IChatComponent)new ChatComponentText("nor greater than 10."));
                return;
            }
            NBTTagCompound tagCom = this.vortexStack.func_77942_o() ? this.vortexStack.func_77978_p() : new NBTTagCompound();
            NBTTagCompound coorsTag = tagCom.func_74775_l("Coords");
            if (coorsTag == null) {
                coorsTag = new NBTTagCompound();
            }
            NBTTagCompound coor = new NBTTagCompound();
            coor.func_74778_a("name", name);
            coor.func_74768_a("dim", dimID);
            coor.func_74780_a("x", x);
            coor.func_74780_a("y", y);
            coor.func_74780_a("z", z);
            coorsTag.func_74782_a(index + "", (NBTBase)coor);
            PacketStoreCoords packet = new PacketStoreCoords(coorsTag);
            WeepingAngelsMod.packetChannel.sendToServer((AbstractPacket)packet);
        }
    }

    private void printCoordinates() {
        if (this.vortexStack != null) {
            NBTTagCompound tagCom = this.vortexStack.func_77942_o() ? this.vortexStack.func_77978_p() : new NBTTagCompound();
            NBTTagCompound coorsTag = tagCom.func_74775_l("Coords");
            if (coorsTag == null) {
                return;
            }
            for (int i = 1; coorsTag.func_74781_a(i + "") != null && i <= 10; ++i) {
                NBTTagCompound coor = (NBTTagCompound)coorsTag.func_74781_a(i + "");
                int dimID = coor.func_74762_e("dim");
                double x = coor.func_74769_h("x");
                double y = coor.func_74769_h("y");
                double z = coor.func_74769_h("z");
            }
        }
    }

    private void guiDrawCentString(String str, int x, int y) {
        this.func_73732_a(this.field_146289_q, str, x, y, 0xFFFFFF);
    }

    private void guiDrawString(String str, int x, int y) {
        this.func_73731_b(this.field_146289_q, str, x, y, 0xFFFFFF);
    }

    public String getNext(List<String> list, String current) {
        int index = list.indexOf(current);
        if (++index >= list.size()) {
            return list.get(0);
        }
        return list.get(index);
    }

    private double[] getCoords() {
        try {
            double newX = Double.parseDouble(this.newXTextBox.func_146179_b());
            double newY = Double.parseDouble(this.newYTextBox.func_146179_b());
            double newZ = Double.parseDouble(this.newZTextBox.func_146179_b());
            return new double[]{newX, newY, newZ};
        }
        catch (NumberFormatException err) {
            this.field_146297_k.func_147108_a(null);
            this.thePlayer.func_146105_b((IChatComponent)new ChatComponentText("Your coordinates are wrong."));
            this.thePlayer.func_146105_b((IChatComponent)new ChatComponentText("Please type valid coordinates."));
            return null;
        }
    }

    private boolean loadNextIndex(int current, int i) {
        i = CoreUtil.posOrNeg((int)i);
        if (this.vortexStack != null && this.vortexStack.func_77942_o()) {
            int nextIndex = current + i;
            if (nextIndex < 0) {
                nextIndex = 10;
            } else if (nextIndex > 10) {
                nextIndex = 0;
            }
            NBTTagCompound tagCom = this.vortexStack.func_77978_p();
            NBTTagCompound coorsTag = tagCom.func_74775_l("Coords");
            NBTTagCompound coord = coorsTag.func_74775_l(nextIndex + "");
            if (coord == null) {
                return this.loadNextIndex(nextIndex, i);
            }
            this.locationIndex = nextIndex;
            this.indexName = coord.func_74779_i("name");
            this.dimName = (String)Core.dimensions1.get(coord.func_74762_e("dim"));
            this.coordX = coord.func_74769_h("x");
            this.coordY = coord.func_74769_h("y");
            this.coordZ = coord.func_74769_h("z");
            return true;
        }
        return false;
    }

    public double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, 4);
        return bd.doubleValue();
    }
}

