/*
 * Decompiled with CFR 0.152.
 */
package com.countrygamer.weepingangels;

import com.countrygamer.core.Base.common.item.ItemMetadataBase;
import com.countrygamer.core.Base.common.packet.PacketPipeline;
import com.countrygamer.core.common.Core;
import com.countrygamer.core.common.lib.CoreUtil;
import com.countrygamer.weepingangels.Blocks.BlockPlinth;
import com.countrygamer.weepingangels.Blocks.BlockWeepingAngelSpawn;
import com.countrygamer.weepingangels.Blocks.TileEnt.TileEntityPlinth;
import com.countrygamer.weepingangels.Client.Gui.GuiHandler;
import com.countrygamer.weepingangels.Entity.EntityStatue;
import com.countrygamer.weepingangels.Entity.EntityWeepingAngel;
import com.countrygamer.weepingangels.Handlers.EventHandler;
import com.countrygamer.weepingangels.Handlers.Packet.PacketStoreCoords;
import com.countrygamer.weepingangels.Items.ItemSonic;
import com.countrygamer.weepingangels.Items.ItemStatue;
import com.countrygamer.weepingangels.Items.ItemVortex;
import com.countrygamer.weepingangels.Items.ItemWADebug;
import com.countrygamer.weepingangels.World.WorldGenerator;
import com.countrygamer.weepingangels.proxy.ServerProxy;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.ShapedOreRecipe;

@Mod(modid="weepingangels", name="Weeping Angels Mod", version="2.0.0")
public class WeepingAngelsMod {
    public static final Logger log = Logger.getLogger("WeepingAngels");
    @Mod.Instance(value="weepingangels")
    public static WeepingAngelsMod instance;
    @SidedProxy(clientSide="com.countrygamer.weepingangels.proxy.ClientProxy", serverSide="com.countrygamer.weepingangels.proxy.ServerProxy")
    public static ServerProxy proxy;
    public static final PacketPipeline packetChannel;
    public static Block plinthBlock;
    public static Block blockWeepingAngelSpawn;
    public static Item statue;
    public static Item debugItem;
    public static String debugItemName;
    public static int entityWeepingAngelID;
    public static int maxSpawn;
    public static int spawnRate;
    public static int maxSpawnHeight;
    public static double maxHealth;
    public static int attackStrength;
    public static boolean canTeleport;
    public static int teleportChance;
    public static int teleportRangeMax;
    public static boolean canPoison;
    public static int poisonChance;
    public static int totalConvertTicks;
    public static boolean pickOnly;
    public static boolean addonVortex;
    public static boolean addonSonic;
    public static Item chronon;
    public static String chrononDustName;
    public static String chrononDiamondName;
    public static String chrononMetalName;
    public static Item vortexMan;
    public static String vortexManName;
    public static Item sonicScrew;
    public static String sonicScrewName;
    public static Achievement angelAchieve1;
    public static Achievement angelAchieve2;
    public static Achievement angelAchieve3;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
        this.config(event);
        this.handlers();
        proxy.registerRenderThings();
        this.items();
        this.blocks();
        this.entities();
        this.craftSmelt();
        this.achievements();
    }

    private void config(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        String angelStat = "Angel Stats";
        String angelSpawn = "Angel Spawn Options";
        String addon = "Addons";
        config.load();
        canPoison = CoreUtil.getAndComment((Configuration)config, (String)angelStat, (String)"Angel Can Poison", (String)"When attacked can the angel start the angel conversion. Overwrites 'Poison Chance Percentage' if false.", (boolean)true);
        poisonChance = CoreUtil.getAndComment((Configuration)config, (String)angelStat, (String)"Poison Chance Percentage", (String)"Out of 100, what percentage of attacks can an angel start an angel conversion. Default 5%", (int)5);
        canTeleport = CoreUtil.getAndComment((Configuration)config, (String)angelStat, (String)"Angel Can Cause Teleport", (String)"Determines if an angel can teleport the player. If false, will override all other teleportation of player stats.", (boolean)true);
        teleportChance = CoreUtil.getAndComment((Configuration)config, (String)angelStat, (String)"Teleport Chance Percentage", (String)"Out of 100, what percentage of attacks can an angel teleport the player. Default 20%", (int)20);
        teleportRangeMax = CoreUtil.getAndComment((Configuration)config, (String)angelStat, (String)"Teleport Range (Maximum)", (String)"Maximum number of blocks an angel can teleport the player. Default 60", (int)60);
        attackStrength = CoreUtil.getAndComment((Configuration)config, (String)angelStat, (String)"Attack Strength", (String)"How many half hearts of damage the angel can deal. Default 6 (3 hearts)", (int)6);
        pickOnly = CoreUtil.getAndComment((Configuration)config, (String)angelStat, (String)"Hurt Angel with PickAxe only", (String)"", (boolean)true);
        spawnRate = CoreUtil.getAndComment((Configuration)config, (String)angelSpawn, (String)"Spawn Frequency", (String)"If you make this higher it will spawn more often. Default 2", (int)2);
        maxSpawn = CoreUtil.getAndComment((Configuration)config, (String)angelSpawn, (String)"Max per group spawn", (String)"When the mob has been chosen to be spawned there will spawn between 1 and X of them. Default 2", (int)2);
        maxSpawnHeight = CoreUtil.getAndComment((Configuration)config, (String)angelSpawn, (String)"Max Spawn Y-Level", (String)"The maximum height at which angels can spawn.", (int)40);
        addonVortex = CoreUtil.getAndComment((Configuration)config, (String)addon, (String)("Enable " + vortexManName), (String)"Enable the add-on for the Vortex Manipulator.", (boolean)true);
        addonSonic = CoreUtil.getAndComment((Configuration)config, (String)addon, (String)("Enable " + sonicScrewName), (String)"Enable the add-on for the Sonic Screwdriver.", (boolean)true);
        config.save();
    }

    private void achievements() {
        String angelAchieve = "";
        angelAchieve = "AngelAchieve1";
        angelAchieve1 = new Achievement(angelAchieve, angelAchieve, 9, 1, statue, AchievementList.field_76023_s).func_75987_b().func_75971_g();
        angelAchieve = "AngelAchieve2";
        angelAchieve2 = new Achievement(angelAchieve, angelAchieve, 8, 3, statue, angelAchieve1).func_75987_b().func_75971_g();
        angelAchieve = "AngelAchieve3";
        angelAchieve3 = new Achievement(angelAchieve, angelAchieve, 10, 3, statue, angelAchieve1).func_75987_b().func_75971_g();
    }

    private void handlers() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenerator(), (int)0);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    public void items() {
        statue = new ItemStatue("weepingangels", "Weeping Angel Statue", EntityStatue.class).func_77637_a(CreativeTabs.field_78026_f).func_77625_d(64);
        Core.addItemToTab((Item)statue);
        if (addonVortex || addonSonic) {
            this.chronon();
        }
        if (addonVortex) {
            this.vortex();
        }
        if (addonSonic) {
            this.sonic();
        }
        if (Core.DEBUG) {
            debugItem = new ItemWADebug("weepingangels", debugItemName);
            Core.addItemToTab((Item)debugItem);
        }
    }

    private void chronon() {
        chronon = new ItemMetadataBase("weepingangels", new String[]{chrononDustName, chrononDiamondName, chrononMetalName});
        Core.addItemToTab((Item)chronon);
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(chronon, 1, 1), (Object[])new Object[]{Items.field_151045_i, new ItemStack(chronon, 1, 0), new ItemStack(chronon, 1, 0)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(chronon, 1, 2), (Object[])new Object[]{"xxx", "ccc", "xxx", Character.valueOf('x'), Items.field_151042_j, Character.valueOf('c'), new ItemStack(chronon, 1, 1)});
    }

    private void vortex() {
        vortexMan = new ItemVortex("weepingangels", vortexManName);
        Core.addItemToTab((Item)vortexMan);
        GameRegistry.addRecipe((ItemStack)new ItemStack(vortexMan), (Object[])new Object[]{"xxx", "xcx", "xxx", Character.valueOf('x'), new ItemStack(chronon, 1, 2), Character.valueOf('c'), Items.field_151061_bv});
    }

    private void sonic() {
        sonicScrew = new ItemSonic("weepingangels", sonicScrewName);
        Core.addItemToTab((Item)sonicScrew);
        GameRegistry.addRecipe((ItemStack)new ItemStack(sonicScrew), (Object[])new Object[]{" ge", "lig", "rl ", Character.valueOf('g'), Items.field_151043_k, Character.valueOf('e'), Items.field_151166_bC, Character.valueOf('l'), Items.field_151116_aA, Character.valueOf('i'), Items.field_151042_j, Character.valueOf('r'), Items.field_151137_ax});
    }

    public void blocks() {
        TileEntity.func_145826_a(TileEntityPlinth.class, (String)"weepingangels_Plinth");
        plinthBlock = new BlockPlinth(TileEntityPlinth.class, Material.field_151576_e);
        plinthBlock.func_149711_c(2.0f).func_149752_b(10.0f);
        plinthBlock.func_149672_a(Block.field_149769_e);
        plinthBlock.func_149663_c("Plinth");
        GameRegistry.registerBlock((Block)plinthBlock, (String)"Plinth");
        blockWeepingAngelSpawn = new BlockWeepingAngelSpawn().func_149711_c(0.5f);
        blockWeepingAngelSpawn.func_149663_c("weepingangelspawn");
        Core.addBlockToTab((Block)blockWeepingAngelSpawn);
        GameRegistry.registerBlock((Block)blockWeepingAngelSpawn, (String)"Weeping Angel Spawn Block");
    }

    public void entities() {
        EntityRegistry.registerModEntity(EntityWeepingAngel.class, (String)"Weeping Angel", (int)1, (Object)instance, (int)80, (int)3, (boolean)false);
        EntityList.field_75623_d.put(entityWeepingAngelID, EntityWeepingAngel.class);
        EntityList.field_75627_a.put(entityWeepingAngelID, new EntityList.EntityEggInfo(entityWeepingAngelID, 0x808080, 0xD1D1D1));
        if (spawnRate > 0) {
            for (int i = 0; i < BiomeGenBase.func_150565_n().length; ++i) {
                if (BiomeGenBase.func_150565_n()[i] == null) continue;
                EntityRegistry.addSpawn(EntityWeepingAngel.class, (int)spawnRate, (int)1, (int)maxSpawn, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.func_150565_n()[i]});
            }
        }
    }

    public void craftSmelt() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockWeepingAngelSpawn, new Object[]{"xxx", "xcx", "xxx", Character.valueOf('x'), "stone", Character.valueOf('c'), statue}));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        packetChannel.initalise("weepingangels");
        packetChannel.registerPacket(PacketStoreCoords.class);
        this.iChun_Morph();
    }

    private void iChun_Morph() {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        packetChannel.postInitialise();
    }

    static {
        packetChannel = new PacketPipeline();
        debugItemName = "Debugger";
        maxHealth = 20.0;
        totalConvertTicks = 2400;
        chrononDustName = "Chronon Dust";
        chrononDiamondName = "Chronon Diamond";
        chrononMetalName = "Chronon Metal";
        vortexManName = "Vortex Manipulator";
        sonicScrewName = "Sonic Screwdriver";
    }
}

