/*
 * Decompiled with CFR 0.152.
 */
package com.countrygamer.weepingangels.Handlers.Packet;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;

public class ServerPacketHandler {
    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
        ByteBufInputStream bbis = new ByteBufInputStream(event.packet.payload());
        DataInputStream inputStream = new DataInputStream((InputStream)bbis);
        if (event.packet.channel().equals("WepAng_vortex")) {
            this.handleVortex(inputStream, (EntityPlayer)player);
        } else if (event.packet.channel().equals("WepAng_statue")) {
            // empty if block
        }
    }

    private void handleVortex(DataInputStream inputStream, EntityPlayer player) {
        try {
            ItemStack stack = ServerPacketHandler.readItemStack(inputStream);
            NBTTagCompound tagCom = stack.func_77978_p();
            player.func_70062_b(0, stack);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public static ItemStack readItemStack(DataInput par0DataInput) throws IOException {
        ItemStack itemstack = null;
        short short1 = par0DataInput.readShort();
        System.out.println("[RECIEVING]itemstack id: " + short1);
        if (short1 >= 0) {
            byte b0 = par0DataInput.readByte();
            short short2 = par0DataInput.readShort();
            itemstack = new ItemStack(Item.func_150899_d((int)short1), (int)b0, (int)short2);
            itemstack.field_77990_d = ServerPacketHandler.readNBTTagCompound(par0DataInput);
            System.out.println("[RECIEVING]itemstack stacksize: " + b0);
            System.out.println("[RECIEVING]itemstack damage: " + short2);
        }
        return itemstack;
    }

    public static NBTTagCompound readNBTTagCompound(DataInput par0DataInput) throws IOException {
        short short1 = par0DataInput.readShort();
        System.out.println("[RECIEVING]abyte length: " + short1);
        if (short1 < 0) {
            return null;
        }
        byte[] abyte = new byte[short1];
        par0DataInput.readFully(abyte);
        return CompressedStreamTools.func_74792_a((byte[])abyte);
    }

    public static void writeItemStack(ItemStack par0ItemStack, DataOutput par1DataOutput) throws IOException {
        if (par0ItemStack == null) {
            par1DataOutput.writeShort(-1);
        } else {
            par1DataOutput.writeShort(Item.func_150891_b((Item)par0ItemStack.func_77973_b()));
            par1DataOutput.writeByte(par0ItemStack.field_77994_a);
            par1DataOutput.writeShort(par0ItemStack.func_77960_j());
            NBTTagCompound nbttagcompound = null;
            if (par0ItemStack.func_77973_b().func_77645_m() || par0ItemStack.func_77973_b().func_77651_p()) {
                nbttagcompound = par0ItemStack.field_77990_d;
            }
            ServerPacketHandler.writeNBTTagCompound(nbttagcompound, par1DataOutput);
            System.out.println("[SENDING]itemstack item: " + par0ItemStack.func_77973_b().func_77658_a());
            System.out.println("[SENDING]itemstack stacksize: " + par0ItemStack.field_77994_a);
            System.out.println("[SENDING]itemstack damage: " + par0ItemStack.func_77960_j());
        }
    }

    protected static void writeNBTTagCompound(NBTTagCompound par0NBTTagCompound, DataOutput par1DataOutput) throws IOException {
        if (par0NBTTagCompound == null) {
            par1DataOutput.writeShort(-1);
        } else {
            byte[] abyte = CompressedStreamTools.func_74798_a((NBTTagCompound)par0NBTTagCompound);
            par1DataOutput.writeShort((short)abyte.length);
            par1DataOutput.write(abyte);
            System.out.println("[SENDING]abyte length: " + (short)abyte.length);
            System.out.println("[SENDING]abyte: " + abyte);
        }
    }
}

