/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import mcp.mobius.waila.Waila;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;

public class AccessHelper {
    public static Field getDeclaredField(String classname, String fieldname) {
        try {
            Class<?> class_ = Class.forName(classname);
            Field field_ = class_.getDeclaredField(fieldname);
            field_.setAccessible(true);
            return field_;
        }
        catch (NoSuchFieldException e) {
            Waila.log.warning(String.format("== Field %s %s not found !\n", classname, fieldname));
            return null;
        }
        catch (SecurityException e) {
            Waila.log.warning(String.format("== Field %s %s security exception !\n", classname, fieldname));
            return null;
        }
        catch (ClassNotFoundException e) {
            Waila.log.warning(String.format("== Class %s not found !\n", classname));
            return null;
        }
    }

    public static Object getField(String classname, String fieldname, Object instance) {
        try {
            Class<?> class_ = Class.forName(classname);
            Field field_ = class_.getDeclaredField(fieldname);
            field_.setAccessible(true);
            return field_.get(instance);
        }
        catch (NoSuchFieldException e) {
            Waila.log.warning(String.format("== Field %s %s not found !\n", classname, fieldname));
            return null;
        }
        catch (SecurityException e) {
            Waila.log.warning(String.format("== Field %s %s security exception !\n", classname, fieldname));
            return null;
        }
        catch (ClassNotFoundException e) {
            Waila.log.warning(String.format("== Class %s not found !\n", classname));
            return null;
        }
        catch (IllegalArgumentException e) {
            Waila.log.warning(String.format("== %s\n", e));
            return null;
        }
        catch (IllegalAccessException e) {
            Waila.log.warning(String.format("== %s\n", e));
            return null;
        }
    }

    public static Object getFieldExcept(String classname, String fieldname, Object instance) throws Exception {
        Class<?> class_ = Class.forName(classname);
        Field field_ = class_.getDeclaredField(fieldname);
        field_.setAccessible(true);
        return field_.get(instance);
    }

    public static Block getBlock(String classname, String fieldname) {
        Field field_ = AccessHelper.getDeclaredField(classname, fieldname);
        try {
            return (Block)field_.get(Block.class);
        }
        catch (Exception e) {
            System.out.printf("%s\n", e);
            Waila.log.warning(String.format("== ERROR GETTING BLOCK %s %s\n", classname, fieldname));
            return null;
        }
    }

    public static Item getItem(String classname, String fieldname) {
        Field field_ = AccessHelper.getDeclaredField(classname, fieldname);
        try {
            return (Item)field_.get(Item.class);
        }
        catch (Exception e) {
            System.out.printf("%s\n", e);
            Waila.log.warning(String.format("== ERROR GETTING ITEM %s %s\n", classname, fieldname));
            return null;
        }
    }

    public static ArrayList<IRecipe> getCraftingRecipes(ItemStack stack) {
        ArrayList<IRecipe> recipes = new ArrayList<IRecipe>();
        for (IRecipe recipe : (ArrayList)CraftingManager.func_77594_a().func_77592_b()) {
            if (recipe == null || recipe.func_77571_b() == null || !recipe.func_77571_b().func_77969_a(stack)) continue;
            recipes.add(recipe);
        }
        return recipes;
    }

    public static void cleanCraftingRecipes(ItemStack stack) {
        for (IRecipe recipe : AccessHelper.getCraftingRecipes(stack)) {
            CraftingManager.func_77594_a().func_77592_b().remove(recipe);
        }
    }
}

