/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import cpw.mods.fml.common.FMLCommonHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.HashSet;
import mcp.mobius.waila.network.IWailaMessage;
import mcp.mobius.waila.network.Message0x04EntNBTData;
import mcp.mobius.waila.network.WailaPacketHandler;
import mcp.mobius.waila.utils.NBTUtil;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.DimensionManager;

public class Message0x03EntRequest
extends SimpleChannelInboundHandler<Message0x03EntRequest>
implements IWailaMessage {
    public int dim;
    public int id;
    public HashSet<String> keys = new HashSet();

    public Message0x03EntRequest() {
    }

    public Message0x03EntRequest(Entity ent, HashSet<String> keys) {
        this.dim = ent.field_70170_p.field_73011_w.field_76574_g;
        this.id = ent.func_145782_y();
        this.keys = keys;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, IWailaMessage msg, ByteBuf target) throws Exception {
        target.writeInt(this.dim);
        target.writeInt(this.id);
        target.writeInt(this.keys.size());
        for (String key : this.keys) {
            WailaPacketHandler.INSTANCE.writeString(target, key);
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf dat, IWailaMessage rawmsg) {
        try {
            Message0x03EntRequest msg = (Message0x03EntRequest)rawmsg;
            msg.dim = dat.readInt();
            msg.id = dat.readInt();
            int nkeys = dat.readInt();
            for (int i = 0; i < nkeys; ++i) {
                this.keys.add(WailaPacketHandler.INSTANCE.readString(dat));
            }
        }
        catch (Exception e) {
            WailaExceptionHandler.handleErr(e, this.getClass().toString(), null);
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, Message0x03EntRequest msg) throws Exception {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        Entity entity = DimensionManager.getWorld((int)msg.dim).func_73045_a(msg.id);
        if (entity != null) {
            try {
                NBTTagCompound tag = new NBTTagCompound();
                entity.func_70109_d(tag);
                ctx.writeAndFlush((Object)new Message0x04EntNBTData(NBTUtil.createTag(tag, msg.keys))).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, entity.getClass().toString(), null);
            }
        }
    }
}

