/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import cpw.mods.fml.common.FMLCommonHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.HashSet;
import mcp.mobius.waila.network.IWailaMessage;
import mcp.mobius.waila.network.Message0x02TENBTData;
import mcp.mobius.waila.network.WailaPacketHandler;
import mcp.mobius.waila.utils.NBTUtil;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.DimensionManager;

public class Message0x01TERequest
extends SimpleChannelInboundHandler<Message0x01TERequest>
implements IWailaMessage {
    public int dim;
    public int posX;
    public int posY;
    public int posZ;
    public HashSet<String> keys = new HashSet();

    public Message0x01TERequest() {
    }

    public Message0x01TERequest(TileEntity ent, HashSet<String> keys) {
        this.dim = ent.func_145831_w().field_73011_w.field_76574_g;
        this.posX = ent.field_145851_c;
        this.posY = ent.field_145848_d;
        this.posZ = ent.field_145849_e;
        this.keys = keys;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, IWailaMessage msg, ByteBuf target) throws Exception {
        target.writeInt(this.dim);
        target.writeInt(this.posX);
        target.writeInt(this.posY);
        target.writeInt(this.posZ);
        target.writeInt(this.keys.size());
        for (String key : this.keys) {
            WailaPacketHandler.INSTANCE.writeString(target, key);
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf dat, IWailaMessage rawmsg) {
        try {
            Message0x01TERequest msg = (Message0x01TERequest)rawmsg;
            msg.dim = dat.readInt();
            msg.posX = dat.readInt();
            msg.posY = dat.readInt();
            msg.posZ = dat.readInt();
            int nkeys = dat.readInt();
            for (int i = 0; i < nkeys; ++i) {
                this.keys.add(WailaPacketHandler.INSTANCE.readString(dat));
            }
        }
        catch (Exception e) {
            WailaExceptionHandler.handleErr(e, this.getClass().toString(), null);
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, Message0x01TERequest msg) throws Exception {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        TileEntity entity = DimensionManager.getWorld((int)msg.dim).func_147438_o(msg.posX, msg.posY, msg.posZ);
        if (entity != null) {
            try {
                NBTTagCompound tag = new NBTTagCompound();
                entity.func_145841_b(tag);
                ctx.writeAndFlush((Object)new Message0x02TENBTData(NBTUtil.createTag(tag, msg.keys))).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, entity.getClass().toString(), null);
            }
        }
    }
}

