/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.vanillamc;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import mcp.mobius.waila.cbcore.LangUtil;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityMobSpawner;

public class HUDHandlerVanilla
implements IWailaDataProvider {
    static Block mobSpawner = Blocks.field_150474_ac;
    static Block crops = Blocks.field_150464_aj;
    static Block melonStem = Blocks.field_150394_bc;
    static Block pumpkinStem = Blocks.field_150393_bb;
    static Block carrot = Blocks.field_150459_bM;
    static Block potato = Blocks.field_150469_bN;
    static Block lever = Blocks.field_150442_at;
    static Block repeaterIdle = Blocks.field_150413_aR;
    static Block repeaterActv = Blocks.field_150416_aS;
    static Block comparatorIdl = Blocks.field_150441_bU;
    static Block comparatorAct = Blocks.field_150455_bV;
    static Block redstone = Blocks.field_150488_af;
    static Block jukebox = Blocks.field_150421_aI;
    static Block cocoa = Blocks.field_150375_by;
    static Block netherwart = Blocks.field_150388_bm;
    static Block silverfish = Blocks.field_150418_aU;

    @Override
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Block block = accessor.getBlock();
        if (block == silverfish && config.getConfig("vanilla.silverfish")) {
            int metadata = accessor.getMetadata();
            switch (metadata) {
                case 0: {
                    return new ItemStack(Blocks.field_150348_b);
                }
                case 1: {
                    return new ItemStack(Blocks.field_150347_e);
                }
                case 2: {
                    return new ItemStack(Blocks.field_150336_V);
                }
            }
            return null;
        }
        if (block == redstone) {
            return new ItemStack(Items.field_151137_ax);
        }
        return null;
    }

    @Override
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        String name;
        Block block = accessor.getBlock();
        if (block == mobSpawner && accessor.getTileEntity() instanceof TileEntityMobSpawner && config.getConfig("vanilla.spawntype")) {
            name = currenttip.get(0);
            String mobname = ((TileEntityMobSpawner)accessor.getTileEntity()).func_145881_a().func_98276_e();
            currenttip.set(0, String.format("%s (%s)", name, mobname));
        }
        if (block == redstone) {
            name = currenttip.get(0).replaceFirst(String.format(" %s", accessor.getMetadata()), "");
            currenttip.set(0, name);
        }
        return currenttip;
    }

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Block block = accessor.getBlock();
        boolean iscrop = crops.getClass().isInstance(block);
        if (config.getConfig("general.showcrop") && (iscrop || block == melonStem || block == pumpkinStem || block == carrot || block == potato)) {
            float growthValue = (float)accessor.getMetadata() / 7.0f * 100.0f;
            if ((double)growthValue < 100.0) {
                currenttip.add(String.format("%s : %.0f %%", LangUtil.translateG("hud.msg.growth", new Object[0]), Float.valueOf(growthValue)));
            } else {
                currenttip.add(String.format("%s : %s", LangUtil.translateG("hud.msg.growth", new Object[0]), LangUtil.translateG("hud.msg.mature", new Object[0])));
            }
            return currenttip;
        }
        if (block == cocoa && config.getConfig("general.showcrop")) {
            float growthValue = (float)(accessor.getMetadata() >> 2) / 2.0f * 100.0f;
            if ((double)growthValue < 100.0) {
                currenttip.add(String.format("%s : %.0f %%", LangUtil.translateG("hud.msg.growth", new Object[0]), Float.valueOf(growthValue)));
            } else {
                currenttip.add(String.format("%s : %s", LangUtil.translateG("hud.msg.growth", new Object[0]), LangUtil.translateG("hud.msg.mature", new Object[0])));
            }
            return currenttip;
        }
        if (block == netherwart && config.getConfig("general.showcrop")) {
            float growthValue = (float)accessor.getMetadata() / 3.0f * 100.0f;
            if ((double)growthValue < 100.0) {
                currenttip.add(String.format("%s : %.0f %%", LangUtil.translateG("hud.msg.growth", new Object[0]), Float.valueOf(growthValue)));
            } else {
                currenttip.add(String.format("%s : %s", LangUtil.translateG("hud.msg.growth", new Object[0]), LangUtil.translateG("hud.msg.mature", new Object[0])));
            }
            return currenttip;
        }
        if (config.getConfig("vanilla.leverstate") && block == lever) {
            String redstoneOn = (accessor.getMetadata() & 8) == 0 ? LangUtil.translateG("hud.msg.off", new Object[0]) : LangUtil.translateG("hud.msg.on", new Object[0]);
            currenttip.add(String.format("%s : %s", LangUtil.translateG("hud.msg.state", new Object[0]), redstoneOn));
            return currenttip;
        }
        if (config.getConfig("vanilla.repeater") && (block == repeaterIdle || block == repeaterActv)) {
            int tick = (accessor.getMetadata() >> 2) + 1;
            if (tick == 1) {
                currenttip.add(String.format("%s : %s tick", LangUtil.translateG("hud.msg.delay", new Object[0]), tick));
            } else {
                currenttip.add(String.format("%s : %s ticks", LangUtil.translateG("hud.msg.delay", new Object[0]), tick));
            }
            return currenttip;
        }
        if (config.getConfig("vanilla.comparator") && (block == comparatorIdl || block == comparatorAct)) {
            String mode = (accessor.getMetadata() >> 2 & 1) == 0 ? LangUtil.translateG("hud.msg.comparator", new Object[0]) : LangUtil.translateG("hud.msg.substractor", new Object[0]);
            currenttip.add("Mode : " + mode);
            return currenttip;
        }
        if (config.getConfig("vanilla.redstone") && block == redstone) {
            currenttip.add(String.format("%s : %s", LangUtil.translateG("hud.msg.power", new Object[0]), accessor.getMetadata()));
            return currenttip;
        }
        return currenttip;
    }

    @Override
    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public static void register() {
        ModuleRegistrar.instance().addConfig("VanillaMC", "vanilla.spawntype");
        ModuleRegistrar.instance().addConfig("VanillaMC", "vanilla.leverstate");
        ModuleRegistrar.instance().addConfig("VanillaMC", "vanilla.repeater");
        ModuleRegistrar.instance().addConfig("VanillaMC", "vanilla.comparator");
        ModuleRegistrar.instance().addConfig("VanillaMC", "vanilla.redstone");
        ModuleRegistrar.instance().addConfig("VanillaMC", "vanilla.silverfish");
        ModuleRegistrar.instance().addConfigRemote("VanillaMC", "vanilla.jukebox");
        HUDHandlerVanilla provider = new HUDHandlerVanilla();
        ModuleRegistrar.instance().registerStackProvider(provider, silverfish.getClass());
        ModuleRegistrar.instance().registerStackProvider(provider, redstone.getClass());
        ModuleRegistrar.instance().registerHeadProvider(provider, mobSpawner.getClass());
        ModuleRegistrar.instance().registerBodyProvider(provider, crops.getClass());
        ModuleRegistrar.instance().registerBodyProvider(provider, melonStem.getClass());
        ModuleRegistrar.instance().registerBodyProvider(provider, pumpkinStem.getClass());
        ModuleRegistrar.instance().registerBodyProvider(provider, lever.getClass());
        ModuleRegistrar.instance().registerBodyProvider(provider, repeaterIdle.getClass());
        ModuleRegistrar.instance().registerBodyProvider(provider, repeaterActv.getClass());
        ModuleRegistrar.instance().registerBodyProvider(provider, comparatorIdl.getClass());
        ModuleRegistrar.instance().registerBodyProvider(provider, comparatorAct.getClass());
        ModuleRegistrar.instance().registerHeadProvider(provider, redstone.getClass());
        ModuleRegistrar.instance().registerBodyProvider(provider, redstone.getClass());
        ModuleRegistrar.instance().registerBodyProvider(provider, jukebox.getClass());
        ModuleRegistrar.instance().registerBodyProvider(provider, cocoa.getClass());
        ModuleRegistrar.instance().registerBodyProvider(provider, netherwart.getClass());
        ModuleRegistrar.instance().registerSyncedNBTKey("*", mobSpawner.getClass());
        ModuleRegistrar.instance().registerSyncedNBTKey("*", crops.getClass());
        ModuleRegistrar.instance().registerSyncedNBTKey("*", melonStem.getClass());
        ModuleRegistrar.instance().registerSyncedNBTKey("*", pumpkinStem.getClass());
        ModuleRegistrar.instance().registerSyncedNBTKey("*", carrot.getClass());
        ModuleRegistrar.instance().registerSyncedNBTKey("*", potato.getClass());
        ModuleRegistrar.instance().registerSyncedNBTKey("*", lever.getClass());
        ModuleRegistrar.instance().registerSyncedNBTKey("*", repeaterIdle.getClass());
        ModuleRegistrar.instance().registerSyncedNBTKey("*", repeaterActv.getClass());
        ModuleRegistrar.instance().registerSyncedNBTKey("*", comparatorIdl.getClass());
        ModuleRegistrar.instance().registerSyncedNBTKey("*", comparatorAct.getClass());
        ModuleRegistrar.instance().registerSyncedNBTKey("*", redstone.getClass());
        ModuleRegistrar.instance().registerSyncedNBTKey("*", jukebox.getClass());
        ModuleRegistrar.instance().registerSyncedNBTKey("*", cocoa.getClass());
        ModuleRegistrar.instance().registerSyncedNBTKey("*", netherwart.getClass());
        ModuleRegistrar.instance().registerSyncedNBTKey("*", silverfish.getClass());
    }
}

