/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.railcraft;

import java.util.List;
import mcp.mobius.waila.addons.railcraft.RailcraftModule;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.cbcore.LangUtil;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class HUDHandlerTank
implements IWailaDataProvider {
    @Override
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    @Override
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("railcraft.fluidamount")) {
            return currenttip;
        }
        try {
            IFluidTank tank = (IFluidTank)RailcraftModule.ITankTile_getTank.invoke(RailcraftModule.ITankTile.cast(accessor.getTileEntity()), new Object[0]);
            if (tank == null) {
                return currenttip;
            }
            FluidStack fluid = tank.getFluid();
            String name = currenttip.get(0);
            try {
                name = name + String.format(" < %s >", fluid.getFluid().getLocalizedName());
            }
            catch (NullPointerException f) {
                name = name + " " + LangUtil.translateG("hud.msg.empty", new Object[0]);
            }
            currenttip.set(0, name);
        }
        catch (Exception e) {
            currenttip = WailaExceptionHandler.handleErr(e, accessor.getTileEntity().getClass().getName(), currenttip);
        }
        return currenttip;
    }

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("railcraft.fluidamount")) {
            return currenttip;
        }
        try {
            IFluidTank tank = (IFluidTank)RailcraftModule.ITankTile_getTank.invoke(RailcraftModule.ITankTile.cast(accessor.getTileEntity()), new Object[0]);
            if (tank == null) {
                return currenttip;
            }
            FluidStack fluid = tank.getFluid();
            if (fluid != null) {
                currenttip.add(String.format("%d / %d mB", fluid.amount, tank.getInfo().capacity));
            } else {
                currenttip.add(String.format("0 / %d mB", tank.getInfo().capacity));
            }
        }
        catch (Exception e) {
            currenttip = WailaExceptionHandler.handleErr(e, accessor.getTileEntity().getClass().getName(), currenttip);
        }
        return currenttip;
    }

    @Override
    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }
}

