/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.ic2;

import java.util.List;
import mcp.mobius.waila.addons.ic2.IC2Module;
import mcp.mobius.waila.addons.ic2.IC2Upgrades;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.cbcore.LangUtil;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.item.ItemStack;

public class HUDHandlerTEStandardMachine
implements IWailaDataProvider {
    @Override
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    @Override
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        try {
            IC2Upgrades upgrades = IC2Module.getUpgrades(accessor);
            int baseConsumption = IC2Module.TESM_DefaultEnergyConsume.getInt(accessor.getTileEntity());
            int baseOpTime = IC2Module.TESM_DefaultOperationLength.getInt(accessor.getTileEntity());
            int baseStorage = IC2Module.TESM_DefaultEnergyStorage.getInt(accessor.getTileEntity());
            long consumption = Math.round(Math.min((double)baseConsumption * Math.pow(1.6, upgrades.overclocker), 2.147483647E9));
            double stackOpLen = (double)baseOpTime * 64.0 * Math.pow(0.7, upgrades.overclocker);
            int opPerTick = (int)Math.min(Math.ceil(64.0 / stackOpLen), 2.147483647E9);
            int opTime = (int)Math.round(stackOpLen * (double)opPerTick / 64.0);
            int storage = Math.round(Math.min((long)(baseStorage + 10000 * upgrades.storage) + (long)opTime * consumption, Integer.MAX_VALUE));
            int maxinput = (Integer)IC2Module.IES_GetMaxSafeInput.invoke((Object)accessor.getTileEntity(), new Object[0]) * (int)Math.pow(4.0, Math.min(4, upgrades.transform));
            double stored = IC2Module.getStoredEnergy(accessor);
            String storedStr = LangUtil.translateG("hud.msg.stored", new Object[0]);
            String powerStr = LangUtil.translateG("hud.msg.power", new Object[0]);
            String maxPowerStr = LangUtil.translateG("hud.msg.maxpower", new Object[0]);
            if (ConfigHandler.instance().getConfig("ic2.storage") && stored >= 0.0) {
                currenttip.add(String.format("%s%s\u00a7f%d\u00a7r / \u00a7f%d\u00a7r EU", storedStr, SpecialChars.TAB + SpecialChars.ALIGNRIGHT, Math.round(Math.min(stored, (double)storage)), storage));
            }
            if (ConfigHandler.instance().getConfig("ic2.consump") && consumption > 0L) {
                currenttip.add(String.format("%s%s\u00a7f%d\u00a7r EU/t", powerStr, SpecialChars.TAB + SpecialChars.ALIGNRIGHT, consumption));
            }
            if (ConfigHandler.instance().getConfig("ic2.inputeu") && maxinput > 0) {
                currenttip.add(String.format("%s%s\u00a7f%d\u00a7r EU/t", maxPowerStr, SpecialChars.TAB + SpecialChars.ALIGNRIGHT, maxinput));
            }
        }
        catch (Exception e) {
            currenttip = WailaExceptionHandler.handleErr(e, accessor.getTileEntity().getClass().getName(), currenttip);
        }
        return currenttip;
    }

    @Override
    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }
}

