/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.api.impl.DataAccessorBlock;
import mcp.mobius.waila.api.impl.DataAccessorEntity;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import mcp.mobius.waila.utils.Constants;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class RayTracing {
    private static RayTracing _instance;
    private MovingObjectPosition target = null;
    private ItemStack targetStack = null;
    private Entity targetEntity = null;
    private Minecraft mc = Minecraft.func_71410_x();

    private RayTracing() {
    }

    public static RayTracing instance() {
        if (_instance == null) {
            _instance = new RayTracing();
        }
        return _instance;
    }

    public void fire() {
        if (this.mc.field_71476_x != null && this.mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
            this.target = this.mc.field_71476_x;
            this.targetStack = null;
            return;
        }
        EntityLivingBase viewpoint = this.mc.field_71451_h;
        if (viewpoint == null) {
            return;
        }
        this.target = this.rayTrace(viewpoint, 4.0, 0.0f);
        if (this.target == null) {
            return;
        }
    }

    public MovingObjectPosition getTarget() {
        return this.target;
    }

    public ItemStack getTargetStack() {
        this.targetStack = this.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK ? this.getIdentifierStack() : null;
        return this.targetStack;
    }

    public Entity getTargetEntity() {
        this.targetEntity = this.target.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY ? this.getIdentifierEntity() : null;
        return this.targetEntity;
    }

    public MovingObjectPosition rayTrace(EntityLivingBase entity, double par1, float par3) {
        Vec3 vec3 = entity.func_70666_h(par3);
        if (entity.func_70047_e() != 0.12f) {
            vec3.field_72448_b += (double)entity.func_70047_e();
        }
        Vec3 vec31 = entity.func_70676_i(par3);
        Vec3 vec32 = vec3.func_72441_c(vec31.field_72450_a * par1, vec31.field_72448_b * par1, vec31.field_72449_c * par1);
        if (ConfigHandler.instance().getConfig("general", Constants.CFG_WAILA_LIQUID, true)) {
            return entity.field_70170_p.func_72901_a(vec3, vec32, true);
        }
        return entity.field_70170_p.func_72901_a(vec3, vec32, false);
    }

    public ItemStack getIdentifierStack() {
        WorldClient world = this.mc.field_71441_e;
        ArrayList<ItemStack> items = this.getIdentifierItems();
        if (items.isEmpty()) {
            return null;
        }
        Collections.sort(items, new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack stack0, ItemStack stack1) {
                return stack1.func_77960_j() - stack0.func_77960_j();
            }
        });
        return items.get(0);
    }

    public Entity getIdentifierEntity() {
        ArrayList<Entity> ents = new ArrayList<Entity>();
        if (this.target == null) {
            return null;
        }
        if (ModuleRegistrar.instance().hasOverrideEntityProviders(this.target.field_72308_g)) {
            ents.add(ModuleRegistrar.instance().getOverrideEntityProviders(this.target.field_72308_g).get(0).getWailaOverride(DataAccessorEntity.instance, ConfigHandler.instance()));
        }
        if (ents.size() > 0) {
            return (Entity)ents.get(0);
        }
        return this.target.field_72308_g;
    }

    public ArrayList<ItemStack> getIdentifierItems() {
        IShearable shearable;
        ItemStack providerStack;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (this.target == null) {
            return items;
        }
        EntityClientPlayerMP player = this.mc.field_71439_g;
        WorldClient world = this.mc.field_71441_e;
        int x = this.target.field_72311_b;
        int y = this.target.field_72312_c;
        int z = this.target.field_72309_d;
        Block mouseoverBlock = world.func_147439_a(x, y, z);
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (mouseoverBlock == null) {
            return items;
        }
        if (ModuleRegistrar.instance().hasStackProviders(mouseoverBlock) && (providerStack = ModuleRegistrar.instance().getStackProviders(mouseoverBlock).get(0).getWailaStack(DataAccessorBlock.instance, ConfigHandler.instance())) != null) {
            items.add(providerStack);
        }
        if (tileEntity != null && ModuleRegistrar.instance().hasStackProviders(tileEntity) && (providerStack = ModuleRegistrar.instance().getStackProviders(tileEntity).get(0).getWailaStack(DataAccessorBlock.instance, ConfigHandler.instance())) != null) {
            items.add(providerStack);
        }
        if (items.size() > 0) {
            return items;
        }
        if (world.func_147438_o(x, y, z) == null) {
            try {
                ItemStack block = new ItemStack(mouseoverBlock, 1, world.func_72805_g(x, y, z));
                items.add(block);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (items.size() > 0) {
            return items;
        }
        try {
            ItemStack pick = mouseoverBlock.getPickBlock(this.target, (World)world, x, y, z);
            if (pick != null) {
                items.add(pick);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (items.size() > 0) {
            return items;
        }
        if (mouseoverBlock instanceof IShearable && (shearable = (IShearable)mouseoverBlock).isShearable(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)world, x, y, z)) {
            items.addAll(shearable.onSheared(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)world, x, y, z, 0));
        }
        if (items.size() == 0) {
            items.add(0, new ItemStack(mouseoverBlock, 1, world.func_72805_g(x, y, z)));
        }
        return items;
    }
}

