/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.gui.client;

import com.vanhal.progressiveautomation.entities.TileMiner;
import com.vanhal.progressiveautomation.gui.client.BaseGUI;
import com.vanhal.progressiveautomation.gui.container.ContainerMiner;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class GUIMiner
extends BaseGUI {
    public static final ResourceLocation texture = new ResourceLocation("progressiveautomation", "textures/gui/Miner.png");
    protected int infoScreenX = 38;
    protected int infoScreenW = 66;
    protected int infroScreenY1 = 17;
    protected int infroScreenY2 = 27;
    protected int infroScreenY3 = 37;
    private TileMiner miner;

    public GUIMiner(InventoryPlayer inv, TileEntity entity) {
        super(new ContainerMiner(inv, entity), texture);
        this.miner = (TileMiner)entity;
    }

    @Override
    protected void drawText() {
        this.drawString("Miner", 5, GRAY);
        this.drawString("Range: " + this.miner.getRange(), this.infoScreenX, this.infoScreenW, this.infroScreenY3, WHITE);
        boolean readyToMine = true;
        if (this.miner.isInventoryFull()) {
            this.drawString("Full", this.infoScreenX, this.infoScreenW, this.infroScreenY2, RED);
            readyToMine = false;
        } else if (this.miner.func_70301_a(0) == null && !this.miner.isBurning()) {
            this.drawString("Need Fuel", this.infoScreenX, this.infoScreenW, this.infroScreenY2, RED);
            readyToMine = false;
        } else if (this.miner.func_70301_a(1) == null) {
            this.drawString("Need Cobble", this.infoScreenX, this.infoScreenW, this.infroScreenY2, RED);
            readyToMine = false;
        } else if (this.miner.func_70301_a(2) == null) {
            this.drawString("Need Pickaxe", this.infoScreenX, this.infoScreenW, this.infroScreenY2, RED);
            readyToMine = false;
        } else if (this.miner.func_70301_a(3) == null) {
            this.drawString("Need Shovel", this.infoScreenX, this.infoScreenW, this.infroScreenY2, RED);
            readyToMine = false;
        } else {
            this.drawString(this.miner.getMinedBlocks() + "/" + this.miner.getMineBlocks(), this.infoScreenX, this.infoScreenW, this.infroScreenY2, BLUE);
        }
        if (!readyToMine) {
            this.drawString("Not Ready", this.infoScreenX, this.infoScreenW, this.infroScreenY1, RED);
        } else if (this.miner.getMinedBlocks() == this.miner.getMineBlocks()) {
            this.drawString("Finished", this.infoScreenX, this.infoScreenW, this.infroScreenY1, BLUE);
        } else if (this.miner.isSearching()) {
            this.drawString("Searching", this.infoScreenX, this.infoScreenW, this.infroScreenY1, GREEN);
        } else {
            this.drawString("Mining", this.infoScreenX, this.infoScreenW, this.infroScreenY1, GREEN);
        }
    }

    @Override
    protected void drawElements() {
        this.drawFlame(this.miner.getPercentDone(), 10, 34);
    }
}

