/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.gui.container;

import com.vanhal.progressiveautomation.entities.BaseTileEntity;
import com.vanhal.progressiveautomation.entities.TileMiner;
import com.vanhal.progressiveautomation.gui.container.BaseContainer;
import com.vanhal.progressiveautomation.gui.slots.SlotItem;
import com.vanhal.progressiveautomation.gui.slots.SlotTool;
import com.vanhal.progressiveautomation.ref.ToolInfo;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;

public class ContainerMiner
extends BaseContainer {
    protected ItemStack updateType;
    protected int lastMinedBlocks = -1;
    protected int lastMineBlocks = -1;
    protected int lastUpgrades = -1;

    public ContainerMiner(InventoryPlayer inv, TileEntity entity) {
        super((BaseTileEntity)entity, 11, 52);
        TileMiner miner = (TileMiner)entity;
        this.updateType = ToolInfo.getUpgradeType(miner.getMiningLevel());
        this.func_75146_a(new SlotItem(new ItemStack(Blocks.field_150347_e), (IInventory)miner, 1, 11, 16));
        this.func_75146_a(new SlotTool(ToolInfo.TYPE_PICKAXE, miner.getMiningLevel(), (IInventory)miner, 2, 37, 52));
        this.func_75146_a(new SlotTool(ToolInfo.TYPE_SHOVEL, miner.getMiningLevel(), (IInventory)miner, 3, 63, 52));
        this.func_75146_a(new SlotItem(this.updateType, (IInventory)miner, 4, 89, 52));
        this.func_75146_a(new Slot((IInventory)miner, 5, 112, 16));
        this.func_75146_a(new Slot((IInventory)miner, 6, 130, 16));
        this.func_75146_a(new Slot((IInventory)miner, 7, 148, 16));
        this.func_75146_a(new Slot((IInventory)miner, 8, 112, 34));
        this.func_75146_a(new Slot((IInventory)miner, 9, 130, 34));
        this.func_75146_a(new Slot((IInventory)miner, 10, 148, 34));
        this.func_75146_a(new Slot((IInventory)miner, 11, 112, 52));
        this.func_75146_a(new Slot((IInventory)miner, 12, 130, 52));
        this.func_75146_a(new Slot((IInventory)miner, 13, 148, 52));
        this.addPlayerInventory(inv);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack func_82846_b(EntityPlayer player, int slot) {
        ItemStack stack = null;
        Slot slotObject = (Slot)this.field_75151_b.get(slot);
        if (slotObject == null || !slotObject.func_75216_d()) return stack;
        ItemStack stackInSlot = slotObject.func_75211_c();
        stack = stackInSlot.func_77946_l();
        if (slot < this.entity.func_70302_i_()) {
            if (!this.func_75135_a(stackInSlot, this.entity.func_70302_i_(), this.field_75151_b.size(), true)) {
                return null;
            }
        } else if (stackInSlot.func_77969_a(new ItemStack(Blocks.field_150347_e))) {
            if (!this.func_75135_a(stackInSlot, 1, 2, false)) {
                return null;
            }
        } else if (ToolInfo.getType(stackInSlot.func_77973_b()) == ToolInfo.TYPE_PICKAXE) {
            if (ToolInfo.getLevel(stackInSlot.func_77973_b()) > ((TileMiner)this.entity).getMiningLevel()) return null;
            if (!this.func_75135_a(stackInSlot, 2, 3, false)) {
                return null;
            }
        } else if (ToolInfo.getType(stackInSlot.func_77973_b()) == ToolInfo.TYPE_SHOVEL) {
            if (ToolInfo.getLevel(stackInSlot.func_77973_b()) > ((TileMiner)this.entity).getMiningLevel()) return null;
            if (!this.func_75135_a(stackInSlot, 3, 4, false)) {
                return null;
            }
        } else if (TileEntityFurnace.func_145952_a((ItemStack)stackInSlot) > 0 ? !this.func_75135_a(stackInSlot, 0, 1, false) : (stackInSlot.func_77969_a(this.updateType) ? !this.func_75135_a(stackInSlot, 4, 5, false) : !this.func_75135_a(stackInSlot, 5, 14, false))) {
            return null;
        }
        if (stackInSlot.field_77994_a == 0) {
            slotObject.func_75215_d(null);
            return stack;
        } else {
            slotObject.func_75218_e();
        }
        return stack;
    }

    @Override
    public void sendUpdates(ICrafting i) {
        TileMiner miner = (TileMiner)this.entity;
        if (this.lastMineBlocks != miner.getMineBlocks()) {
            this.lastMineBlocks = miner.getMineBlocks();
            i.func_71112_a((Container)this, 2, this.lastMineBlocks);
        }
        if (this.lastMinedBlocks != miner.getMinedBlocks()) {
            this.lastMinedBlocks = miner.getMinedBlocks();
            i.func_71112_a((Container)this, 3, this.lastMinedBlocks);
        }
        if (this.lastUpgrades != miner.getUpgrades()) {
            this.lastUpgrades = miner.getUpgrades();
            i.func_71112_a((Container)this, 4, this.lastUpgrades);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int i, int value) {
        super.func_75137_b(i, value);
        if (i == 2) {
            ((TileMiner)this.entity).setMineBlocks(value);
        } else if (i == 3) {
            ((TileMiner)this.entity).setMinedBlocks(value);
        } else if (i == 4) {
            ((TileMiner)this.entity).setUpgrades(value);
        }
    }
}

