/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.entities;

import com.vanhal.progressiveautomation.entities.BaseTileEntity;
import com.vanhal.progressiveautomation.ref.ToolInfo;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import org.lwjgl.util.Point;

public class TileMiner
extends BaseTileEntity {
    protected int totalMineBlocks = -1;
    protected int currentMineBlocks = 0;
    protected boolean invFull = false;
    protected int numUpgrades = 0;
    protected int mineLevel;
    protected int currentColumn = 0;
    protected int currentYLevel = 0;
    protected Block currentBlock = null;
    protected int miningTime = 0;
    protected int miningWith = 0;
    protected int lastPick = -1;
    protected int lastShovel = -1;
    protected int lastUpgrades = 0;

    public TileMiner() {
        super(13);
        this.setMiningLevel(ToolInfo.LEVEL_WOOD);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("MineBlocks", this.totalMineBlocks);
        nbt.func_74768_a("MinedBlocks", this.currentMineBlocks);
        nbt.func_74768_a("NumUpgrades", this.numUpgrades);
        nbt.func_74757_a("InvFull", this.invFull);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.totalMineBlocks = nbt.func_74762_e("MineBlocks");
        this.currentMineBlocks = nbt.func_74762_e("MinedBlocks");
        this.numUpgrades = nbt.func_74762_e("NumUpgrades");
        this.invFull = nbt.func_74767_n("InvFull");
    }

    public int getMiningLevel() {
        return this.mineLevel;
    }

    public void setMiningLevel(int level) {
        this.mineLevel = level;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.checkForChanges();
            this.checkInventory();
            if (!this.isDone() && this.isBurning() && !this.invFull) {
                this.mine();
            }
        }
    }

    public void scanBlocks() {
        this.currentMineBlocks = 0;
        this.totalMineBlocks = 0;
        for (int i = 1; i <= this.getRange(); ++i) {
            Point currentPoint = TileMiner.spiral(i, this.field_145851_c, this.field_145849_e);
            boolean bedrock = false;
            int newY = this.field_145848_d - 1;
            while (!bedrock) {
                int result = this.canMineBlock(currentPoint.getX(), newY, currentPoint.getY());
                if (result >= 1) {
                    ++this.totalMineBlocks;
                } else if (result == -1) {
                    ++this.totalMineBlocks;
                    ++this.currentMineBlocks;
                }
                if (--newY >= 0) continue;
                bedrock = true;
            }
        }
    }

    public int canMineBlock(int x, int y, int z) {
        Block tryBlock = this.field_145850_b.func_147439_a(x, y, z);
        if (tryBlock != null && tryBlock.func_149712_f(this.field_145850_b, x, y, z) >= 0.0f && tryBlock.getHarvestLevel(0) >= 0) {
            boolean mine = false;
            if (tryBlock == Blocks.field_150347_e) {
                return -1;
            }
            if (tryBlock.getHarvestTool(0) == "pickaxe") {
                if (this.getToolMineLevel(2) >= tryBlock.getHarvestLevel(this.field_145850_b.func_72805_g(x, y, z))) {
                    return 2;
                }
            } else if (tryBlock.getHarvestTool(0) == "shovel") {
                if (this.getToolMineLevel(3) >= tryBlock.getHarvestLevel(this.field_145850_b.func_72805_g(x, y, z))) {
                    return 3;
                }
            } else {
                return 1;
            }
        }
        return 0;
    }

    public void mine() {
        if (this.slots[1] == null || this.slots[2] == null || this.slots[3] == null) {
            return;
        }
        if (this.currentBlock != null) {
            if (this.miningTime <= 0) {
                this.miningTime = 0;
                Point currentPoint = TileMiner.spiral(this.currentColumn, this.field_145851_c, this.field_145849_e);
                if (this.field_145850_b.func_147438_o(currentPoint.getX(), this.currentYLevel, currentPoint.getY()) instanceof IInventory) {
                    IInventory inv = (IInventory)this.field_145850_b.func_147438_o(currentPoint.getX(), this.currentYLevel, currentPoint.getY());
                    for (int i = 0; i < inv.func_70302_i_(); ++i) {
                        if (inv.func_70301_a(i) == null) continue;
                        this.addToInventory(inv.func_70301_a(i));
                        inv.func_70299_a(i, null);
                    }
                }
                int silkTouch = 0;
                if (this.miningWith != 1) {
                    silkTouch = EnchantmentHelper.func_77506_a((int)Enchantment.field_77348_q.field_77352_x, (ItemStack)this.slots[this.miningWith]);
                }
                if (silkTouch > 0) {
                    ItemStack item = new ItemStack(this.currentBlock);
                    this.addToInventory(item);
                } else {
                    int fortuneLevel = 0;
                    if (this.miningWith != 1) {
                        fortuneLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)this.slots[this.miningWith]);
                    }
                    ArrayList items = this.currentBlock.getDrops(this.field_145850_b, currentPoint.getX(), this.currentYLevel, currentPoint.getY(), this.field_145850_b.func_72805_g(currentPoint.getX(), this.currentYLevel, currentPoint.getY()), fortuneLevel);
                    for (ItemStack item : items) {
                        this.addToInventory(item);
                    }
                }
                this.field_145850_b.func_147475_p(currentPoint.getX(), this.currentYLevel, currentPoint.getY());
                this.field_145850_b.func_147449_b(currentPoint.getX(), this.currentYLevel, currentPoint.getY(), Blocks.field_150347_e);
                --this.slots[1].field_77994_a;
                if (this.slots[1].field_77994_a == 0) {
                    this.slots[1] = null;
                }
                ++this.currentMineBlocks;
                this.currentBlock = null;
                if (this.miningWith != 1 && this.slots[this.miningWith].func_96631_a(1, this.RND)) {
                    this.slots[this.miningWith] = null;
                }
            } else {
                --this.miningTime;
            }
        } else if (!this.isDone()) {
            this.currentBlock = this.getNextBlock();
            if (this.currentBlock != null) {
                Point currentPoint = TileMiner.spiral(this.currentColumn, this.field_145851_c, this.field_145849_e);
                this.miningTime = (int)Math.ceil((double)this.currentBlock.func_149712_f(this.field_145850_b, currentPoint.getX(), this.currentYLevel, currentPoint.getY()) * 1.5 * 20.0);
                if (this.miningWith != 1) {
                    ItemTool tool = (ItemTool)this.slots[this.miningWith].func_77973_b();
                    float miningSpeed = tool.getDigSpeed(this.slots[this.miningWith], this.currentBlock, this.field_145850_b.func_72805_g(currentPoint.getX(), this.currentYLevel, currentPoint.getY()));
                    int eff = EnchantmentHelper.func_77506_a((int)Enchantment.field_77349_p.field_77352_x, (ItemStack)this.slots[this.miningWith]);
                    if (eff > 0) {
                        for (int i = 0; i < eff; ++i) {
                            miningSpeed *= 1.3f;
                        }
                    }
                    this.miningTime = (int)Math.ceil((float)this.miningTime / miningSpeed);
                }
            }
        }
        if (this.isDone()) {
            this.scanBlocks();
            this.currentColumn = this.getRange();
        }
    }

    public Block getNextBlock() {
        Point currentPoint = TileMiner.spiral(this.currentColumn, this.field_145851_c, this.field_145849_e);
        this.miningWith = this.canMineBlock(currentPoint.getX(), this.currentYLevel, currentPoint.getY());
        while (this.miningWith <= 0 && this.currentYLevel >= 0) {
            if (this.miningWith > 0) {
                return this.field_145850_b.func_147439_a(currentPoint.getX(), this.currentYLevel, currentPoint.getY());
            }
            --this.currentYLevel;
            this.miningWith = this.canMineBlock(currentPoint.getX(), this.currentYLevel, currentPoint.getY());
        }
        if (this.miningWith > 0) {
            return this.field_145850_b.func_147439_a(currentPoint.getX(), this.currentYLevel, currentPoint.getY());
        }
        if (this.currentYLevel < 0) {
            this.currentYLevel = this.field_145848_d - 1;
            --this.currentColumn;
            if (this.currentColumn < 0) {
                this.scanBlocks();
                this.currentColumn = this.getRange();
            } else {
                return this.getNextBlock();
            }
        }
        return null;
    }

    public int getRange() {
        return this.numUpgrades + 1;
    }

    protected int getCurrentUpgrades() {
        if (this.func_70301_a(4) == null) {
            return 0;
        }
        return this.func_70301_a((int)4).field_77994_a;
    }

    public int getToolMineLevel(int slot) {
        if (this.func_70301_a(slot) != null && this.func_70301_a(slot).func_77973_b() instanceof ItemTool) {
            ItemTool tool = (ItemTool)this.func_70301_a(slot).func_77973_b();
            return ToolInfo.getHarvestLevel((Item)tool);
        }
        return -1;
    }

    public int getMinedBlocks() {
        return this.currentMineBlocks;
    }

    public void setMinedBlocks(int value) {
        this.currentMineBlocks = value;
    }

    public int getMineBlocks() {
        return this.totalMineBlocks;
    }

    public void setMineBlocks(int value) {
        this.totalMineBlocks = value;
    }

    public boolean isInventoryFull() {
        return this.invFull;
    }

    public boolean isDone() {
        return this.totalMineBlocks == this.currentMineBlocks && this.totalMineBlocks > 0;
    }

    public boolean isSearching() {
        return this.currentBlock != null;
    }

    public int getUpgrades() {
        return this.numUpgrades;
    }

    public void setUpgrades(int value) {
        this.numUpgrades = value;
    }

    public void addUpgrades(int addValue) {
        this.numUpgrades += addValue;
    }

    public void checkForChanges() {
        boolean update = false;
        if (this.slots[2] == null && this.lastPick >= 0) {
            this.lastPick = -1;
            update = true;
        } else if (this.slots[2] != null && ToolInfo.getLevel(this.slots[2].func_77973_b()) != this.lastPick) {
            this.lastPick = ToolInfo.getLevel(this.slots[2].func_77973_b());
            update = true;
        }
        if (this.slots[3] == null && this.lastShovel >= 0) {
            this.lastShovel = -1;
            update = true;
        } else if (this.slots[3] != null && ToolInfo.getLevel(this.slots[3].func_77973_b()) != this.lastShovel) {
            this.lastShovel = ToolInfo.getLevel(this.slots[3].func_77973_b());
            update = true;
        }
        if (this.getCurrentUpgrades() != this.lastUpgrades) {
            this.addUpgrades(this.getCurrentUpgrades());
            this.slots[4] = null;
            this.lastUpgrades = this.getCurrentUpgrades();
            update = true;
        }
        if (update) {
            this.scanBlocks();
            this.currentColumn = this.getRange();
            this.currentBlock = null;
            this.miningTime = 0;
            this.currentYLevel = this.field_145848_d - 1;
        }
    }

    public static Point spiral(int n, int x, int y) {
        int dy;
        int dx;
        int k = (int)Math.ceil((Math.sqrt(n) - 1.0) / 2.0);
        int t = 2 * k + 1;
        int m = t * t;
        if (n >= m - --t) {
            dx = k - (m - n);
            dy = -k;
        } else if (n >= (m -= t) - t) {
            dx = -k;
            dy = -k + (m - n);
        } else if (n >= (m -= t) - t) {
            dx = -k + (m - n);
            dy = k;
        } else {
            dx = k;
            dy = k - (m - n - t);
        }
        return new Point(x + dx, y + dy);
    }

    @Override
    public boolean readyToBurn() {
        return this.totalMineBlocks > 0 && this.currentMineBlocks < this.totalMineBlocks && this.slots[1] != null && this.slots[2] != null && this.slots[3] != null;
    }

    public void checkInventory() {
        for (int i = 5; i <= 13; ++i) {
            if (this.slots[i] != null) {
                int moveTo = -1;
                if (this.slots[i].func_77969_a(new ItemStack(Blocks.field_150347_e))) {
                    moveTo = 1;
                } else if (this.getBurnTime(this.slots[i]) > 0) {
                    if (this.slots[0] == null) {
                        moveTo = 0;
                    } else if (this.slots[i].func_77969_a(this.slots[0])) {
                        moveTo = 0;
                    }
                }
                if (moveTo < 0) continue;
                if (this.slots[moveTo] == null) {
                    this.slots[moveTo] = this.slots[i];
                    this.slots[i] = null;
                    continue;
                }
                if (this.slots[moveTo].field_77994_a >= this.slots[moveTo].func_77976_d()) continue;
                int avail = this.slots[moveTo].func_77976_d() - this.slots[moveTo].field_77994_a;
                if (avail >= this.slots[i].field_77994_a) {
                    this.slots[moveTo].field_77994_a += this.slots[i].field_77994_a;
                    this.slots[i] = null;
                    continue;
                }
                this.slots[i].field_77994_a -= avail;
                this.slots[moveTo].field_77994_a += avail;
                continue;
            }
            this.invFull = false;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) instanceof IInventory) {
            IInventory externalInv = (IInventory)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
            for (int i = 5; i <= 13; ++i) {
                if (this.slots[i] == null) continue;
                this.addtoExtInventory(externalInv, i);
            }
        }
    }

    public boolean addtoExtInventory(IInventory inv, int fromSlot) {
        int i;
        for (i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null || !inv.func_70301_a(i).func_77969_a(this.slots[fromSlot]) || inv.func_70301_a((int)i).field_77994_a >= inv.func_70301_a(i).func_77976_d()) continue;
            int avail = inv.func_70301_a(i).func_77976_d() - inv.func_70301_a((int)i).field_77994_a;
            if (avail >= this.slots[fromSlot].field_77994_a) {
                inv.func_70301_a((int)i).field_77994_a += this.slots[fromSlot].field_77994_a;
                this.slots[fromSlot] = null;
                return true;
            }
            this.slots[fromSlot].field_77994_a -= avail;
            inv.func_70301_a((int)i).field_77994_a += avail;
        }
        if (this.slots[fromSlot] != null && this.slots[fromSlot].field_77994_a > 0) {
            for (i = 0; i < inv.func_70302_i_(); ++i) {
                if (inv.func_70301_a(i) != null) continue;
                inv.func_70299_a(i, this.slots[fromSlot]);
                this.slots[fromSlot] = null;
                return true;
            }
        }
        return false;
    }

    public boolean addToInventory(ItemStack item) {
        int i;
        for (i = 5; i <= 13; ++i) {
            if (this.slots[i] == null || item == null || !this.slots[i].func_77969_a(item) || this.slots[i].field_77994_a >= this.slots[i].func_77976_d()) continue;
            int avail = this.slots[i].func_77976_d() - this.slots[i].field_77994_a;
            if (avail >= item.field_77994_a) {
                this.slots[i].field_77994_a += item.field_77994_a;
                item = null;
                return true;
            }
            item.field_77994_a -= avail;
            this.slots[i].field_77994_a += avail;
        }
        if (item != null && item.field_77994_a > 0) {
            for (i = 5; i <= 13; ++i) {
                if (this.slots[i] != null) continue;
                this.slots[i] = item;
                item = null;
                return true;
            }
        }
        if (item != null && item.field_77994_a == 0) {
            item = null;
        }
        if (item != null) {
            EntityItem entItem = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 1.5f), (double)((float)this.field_145849_e + 0.5f), item);
            entItem.field_145804_b = 1;
            float f3 = 0.05f;
            entItem.field_70159_w = (float)this.field_145850_b.field_73012_v.nextGaussian() * f3;
            entItem.field_70181_x = (float)this.field_145850_b.field_73012_v.nextGaussian() * f3 + 0.2f;
            entItem.field_70179_y = (float)this.field_145850_b.field_73012_v.nextGaussian() * f3;
            this.field_145850_b.func_72838_d((Entity)entItem);
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 1 && stack.func_77969_a(new ItemStack(Blocks.field_150347_e))) {
            return true;
        }
        if (slot == 2 && ToolInfo.getType(stack.func_77973_b()) == ToolInfo.TYPE_PICKAXE) {
            if (ToolInfo.getLevel(stack.func_77973_b()) <= this.getMiningLevel()) {
                return true;
            }
        } else if (slot == 3 && ToolInfo.getType(stack.func_77973_b()) == ToolInfo.TYPE_SHOVEL) {
            if (ToolInfo.getLevel(stack.func_77973_b()) <= this.getMiningLevel()) {
                return true;
            }
        } else {
            if (slot == 0 && TileEntityFurnace.func_145952_a((ItemStack)stack) > 0 && ToolInfo.getType(stack.func_77973_b()) == -1) {
                return true;
            }
            if (slot == 4 && stack.func_77969_a(ToolInfo.getUpgradeType(this.getMiningLevel()))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int[] func_94128_d(int var1) {
        int[] output = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
        return output;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot >= 5;
    }
}

