/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.entities;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;

public class BaseTileEntity
extends TileEntity
implements ISidedInventory {
    protected ItemStack[] slots;
    protected int progress = 0;
    protected int burnLevel = 0;
    protected Random RND = new Random();

    public BaseTileEntity(int numSlots) {
        this.slots = new ItemStack[numSlots + 1];
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList contents = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            ItemStack stack = this.slots[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            contents.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Contents", (NBTBase)contents);
        nbt.func_74768_a("Progress", this.progress);
        nbt.func_74768_a("BurnLevel", this.burnLevel);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList contents = nbt.func_150295_c("Contents", 10);
        for (int i = 0; i < contents.func_74745_c(); ++i) {
            NBTTagCompound tag = contents.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot >= this.slots.length) continue;
            this.slots[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.progress = nbt.func_74762_e("Progress");
        this.burnLevel = nbt.func_74762_e("BurnLevel");
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isBurning()) {
                if (this.readyToBurn() && this.slots[0] != null && this.isFuel()) {
                    this.burnLevel = this.progress = this.getBurnTime();
                    --this.slots[0].field_77994_a;
                    if (this.slots[0].field_77994_a == 0) {
                        this.slots[0] = null;
                    }
                }
            } else {
                --this.progress;
                if (this.progress <= 0) {
                    this.progress = 0;
                    this.burnLevel = 0;
                }
            }
        }
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int value) {
        this.progress = value;
    }

    public int getBurnLevel() {
        return this.burnLevel;
    }

    public void setBurnLevel(int value) {
        this.burnLevel = value;
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.slots[slot];
    }

    public ItemStack func_70298_a(int slot, int amt) {
        if (this.slots[slot] != null) {
            ItemStack newStack;
            if (this.slots[slot].field_77994_a <= amt) {
                newStack = this.slots[slot];
                this.slots[slot] = null;
            } else {
                newStack = this.slots[slot].func_77979_a(amt);
                if (this.slots[slot].field_77994_a == 0) {
                    this.slots[slot] = null;
                }
            }
            return newStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.slots[slot] != null) {
            ItemStack stack = this.slots[slot];
            this.slots[slot] = null;
            return stack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.slots[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return false;
    }

    public int[] func_94128_d(int var1) {
        return null;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (this.slots[slot] != null) {
            int availSpace = this.func_70297_j_() - this.slots[slot].field_77994_a;
            return availSpace > 0;
        }
        return true;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return false;
    }

    public boolean readyToBurn() {
        return true;
    }

    public boolean isBurning() {
        return this.progress > 0;
    }

    public float getPercentDone() {
        if (this.isBurning() && this.burnLevel > 0) {
            float done = this.progress;
            return done /= (float)this.burnLevel;
        }
        return 0.0f;
    }

    public int getScaledDone(int scale) {
        return (int)Math.floor((float)scale * this.getPercentDone());
    }

    public int getBurnTime() {
        return this.getBurnTime(this.slots[0]);
    }

    public int getBurnTime(ItemStack item) {
        return TileEntityFurnace.func_145952_a((ItemStack)item);
    }

    public boolean isFuel() {
        return this.getBurnTime() > 0;
    }
}

