/*
 * Decompiled with CFR 0.152.
 */
package exterminatorJeff.undergroundBiomes.worldGen;

import exterminatorJeff.undergroundBiomes.api.NamedVanillaBlock;
import exterminatorJeff.undergroundBiomes.common.UndergroundBiomes;
import exterminatorJeff.undergroundBiomes.common.WorldGenManager;
import exterminatorJeff.undergroundBiomes.constructs.util.Zeno410Logger;
import exterminatorJeff.undergroundBiomes.worldGen.BiomeGenUndergroundBase;
import exterminatorJeff.undergroundBiomes.worldGen.UBStoneCodes;
import java.util.Random;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class BiomeUndergroundDecorator {
    private final WorldGenManager worldGen;
    public static Logger logger = new Zeno410Logger("BiomeUndergroundDecorator").logger();

    public BiomeUndergroundDecorator(WorldGenManager _worldGen) {
        this.worldGen = _worldGen;
    }

    public void decorate(World par1World, Random par2Random, int x, int z) {
        this.replaceBlocksForUndergroundBiome(x, z, par1World);
    }

    public void replaceBlocksForUndergroundBiome(int par_x, int par_z, World currentWorld) {
        int generationHeight = UndergroundBiomes.generateHeight();
        BiomeGenUndergroundBase[] undergroundBiomesForGeneration = new BiomeGenUndergroundBase[256];
        undergroundBiomesForGeneration = this.worldGen.loadUndergroundBlockGeneratorData(undergroundBiomesForGeneration, par_x, par_z, 16, 16);
        for (int x = par_x; x < par_x + 16; ++x) {
            for (int z = par_z; z < par_z + 16; ++z) {
                BiomeGenUndergroundBase currentBiome = undergroundBiomesForGeneration[x - par_x + (z - par_z) * 16];
                int variation = (int)(currentBiome.strataNoise.noise((double)x / 55.533, (double)z / 55.533, 3, 1.0, 0.5) * 10.0 - 5.0);
                for (int y = 1; y < generationHeight; ++y) {
                    Block currentBlock = currentWorld.func_147439_a(x, y, z);
                    if (!NamedVanillaBlock.stone.matches(currentBlock)) continue;
                    UBStoneCodes strata = currentBiome.getStrataBlockAtLayer(y + variation);
                    currentWorld.func_147465_d(x, y, z, strata.block, strata.metadata, 2);
                }
            }
        }
    }

    public void replaceChunkBlocks(Chunk chunk, int par_x, int par_z) {
        this.worldGen.setGenerated(par_x, par_z);
        int generationHeight = UndergroundBiomes.generateHeight();
        BiomeGenUndergroundBase[] undergroundBiomesForGeneration = new BiomeGenUndergroundBase[256];
        undergroundBiomesForGeneration = this.worldGen.loadUndergroundBlockGeneratorData(undergroundBiomesForGeneration, par_x *= 16, par_z *= 16, 16, 16);
        for (int inChunkX = 0; inChunkX < 16; ++inChunkX) {
            for (int inChunkZ = 0; inChunkZ < 16; ++inChunkZ) {
                BiomeGenUndergroundBase currentBiome = undergroundBiomesForGeneration[inChunkX + inChunkZ * 16];
                int variation = (int)(currentBiome.strataNoise.noise((double)(inChunkX + par_x) / 55.533, (double)(inChunkZ + par_z) / 55.533, 3, 1.0, 0.5) * 10.0 - 5.0);
                for (int y = 1; y < generationHeight; ++y) {
                    Block currentBlock = chunk.func_150810_a(inChunkX, y, inChunkZ);
                    if (inChunkZ != 0 || inChunkZ != 0 || y == 32) {
                        // empty if block
                    }
                    if (!NamedVanillaBlock.stone.matches(currentBlock)) continue;
                    UBStoneCodes strata = currentBiome.getStrataBlockAtLayer(y + variation);
                    chunk.func_150807_a(inChunkX, y, inChunkZ, strata.block, strata.metadata);
                }
            }
        }
    }

    public UBStoneCodes fillerBlock(int par_x, int par_z) {
        BiomeGenUndergroundBase[] undergroundBiomesForGeneration = new BiomeGenUndergroundBase[256];
        undergroundBiomesForGeneration = this.worldGen.loadUndergroundBlockGeneratorData(undergroundBiomesForGeneration, par_x, par_z, 16, 16);
        BiomeGenUndergroundBase currentBiome = undergroundBiomesForGeneration[136];
        return currentBiome.fillerBlockCodes;
    }
}

