/*
 * Decompiled with CFR 0.152.
 */
package exterminatorJeff.undergroundBiomes.common;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLModIdMappingEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import exterminatorJeff.undergroundBiomes.api.IDs;
import exterminatorJeff.undergroundBiomes.api.NamedSlabPair;
import exterminatorJeff.undergroundBiomes.api.NamedVanillaBlock;
import exterminatorJeff.undergroundBiomes.api.NamedVanillaItem;
import exterminatorJeff.undergroundBiomes.common.CommonProxy;
import exterminatorJeff.undergroundBiomes.common.CreativeTabModBlocks;
import exterminatorJeff.undergroundBiomes.common.DimensionManager;
import exterminatorJeff.undergroundBiomes.common.FuelManager;
import exterminatorJeff.undergroundBiomes.common.block.BlockIgneousCobblestone;
import exterminatorJeff.undergroundBiomes.common.block.BlockIgneousStone;
import exterminatorJeff.undergroundBiomes.common.block.BlockIgneousStoneBrick;
import exterminatorJeff.undergroundBiomes.common.block.BlockMetadataBase;
import exterminatorJeff.undergroundBiomes.common.block.BlockMetamorphicCobblestone;
import exterminatorJeff.undergroundBiomes.common.block.BlockMetamorphicStone;
import exterminatorJeff.undergroundBiomes.common.block.BlockMetamorphicStoneBrick;
import exterminatorJeff.undergroundBiomes.common.block.BlockSedimentaryStone;
import exterminatorJeff.undergroundBiomes.common.block.BlockStoneSlab;
import exterminatorJeff.undergroundBiomes.common.block.StoneSlabPair;
import exterminatorJeff.undergroundBiomes.common.command.CommandOreDictifyStone;
import exterminatorJeff.undergroundBiomes.common.item.ItemFossilPiece;
import exterminatorJeff.undergroundBiomes.common.item.ItemLigniteCoal;
import exterminatorJeff.undergroundBiomes.common.item.ItemMetadataBlock;
import exterminatorJeff.undergroundBiomes.common.item.ItemMetadataSlab;
import exterminatorJeff.undergroundBiomes.constructs.UndergroundBiomesConstructs;
import exterminatorJeff.undergroundBiomes.constructs.item.ItemUBStairs;
import exterminatorJeff.undergroundBiomes.constructs.util.UBCodeLocations;
import exterminatorJeff.undergroundBiomes.constructs.util.WatchList;
import exterminatorJeff.undergroundBiomes.constructs.util.Zeno410Logger;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@Mod(modid="UndergroundBiomes", name="Underground Biomes", version="0.5")
public class UndergroundBiomes {
    public static Logger logger = new Zeno410Logger("UndergroundBiomes").logger();
    private static UndergroundBiomes instance;
    public static World world;
    public static boolean addOreDictRecipes;
    public static boolean vanillaStoneBiomes;
    public Configuration config;
    private DimensionManager dimensionManager;
    private WatchList defaultIDSetter;
    private boolean runningConfigIDs = false;
    public static String textures;
    public static CreativeTabModBlocks tabModBlocks;
    public static CreativeTabModBlocks tabModItems;
    public static long worldSeed;
    private boolean gotWorldSeed;
    public static BlockMetadataBase igneousStone;
    public static BlockMetadataBase igneousCobblestone;
    public static BlockMetadataBase igneousStoneBrick;
    public static BlockMetadataBase metamorphicStone;
    public static BlockMetadataBase metamorphicCobblestone;
    public static BlockMetadataBase metamorphicStoneBrick;
    public static BlockMetadataBase sedimentaryStone;
    public static Item ligniteCoal;
    public static Item fossilPiece;
    public static StoneSlabPair igneousBrickSlab;
    public static StoneSlabPair metamorphicBrickSlab;
    public static StoneSlabPair igneousStoneSlab;
    public static StoneSlabPair metamorphicStoneSlab;
    public static StoneSlabPair igneousCobblestoneSlab;
    public static StoneSlabPair metamorphicCobblestoneSlab;
    public static StoneSlabPair sedimentaryStoneSlab;
    public static ArrayList<String> fortuneAffected;
    public static ArrayList<ItemStack> nuggets;
    private static String[] nuggetStrings;
    private int igneousStoneID;
    private int igneousCobblestoneID;
    private int igneousStoneBrickID;
    private int metamorphicStoneID;
    private int metamorphicCobblestoneID;
    private int metamorphicStoneBrickID;
    private int sedimentaryStoneID;
    private int ligniteCoalID;
    private int fossilPieceID;
    private int igneousBrickSlabHalfID;
    private int igneousBrickSlabFullID;
    private int metamorphicBrickSlabHalfID;
    private int metamorphicBrickSlabFullID;
    private int igneousStoneSlabHalfID;
    private int igneousStoneSlabFullID;
    private int metamorphicStoneSlabHalfID;
    private int metamorphicStoneSlabFullID;
    private int igneousCobblestoneSlabHalfID;
    private int igneousCobblestoneSlabFullID;
    private int metamorphicCobblestoneSlabHalfID;
    private int metamorphicCobblestoneSlabFullID;
    private int sedimentaryStoneSlabHalfID;
    private int sedimentaryStoneSlabFullID;
    public final UBCodeLocations ubCodeLocations = new UBCodeLocations();
    private List<Integer> includeDimensionIDs;
    private List<Integer> excludeDimensionIDs;
    private String includeDimensions;
    private String excludeDimensions;
    private int vanillaStoneCrafting;
    public static boolean replaceCobblestone;
    public static float hardnessModifier;
    public static float resistanceModifier;
    private static int generateHeight;
    public UndergroundBiomesConstructs constructs;
    private static boolean buttonsOn;
    private static boolean stairsOn;
    private static boolean wallsOn;
    private static boolean harmoniousStrata;
    private static boolean changeStoneProducts;
    private static boolean replaceVillageGravel;
    private static boolean crashOnProblems;
    private static boolean forceConfigIds;
    public static int biomeSize;
    @SidedProxy(clientSide="exterminatorJeff.undergroundBiomes.client.ClientProxy", serverSide="exterminatorJeff.undergroundBiomes.common.CommonProxy")
    public static CommonProxy proxy;
    public static String blockCategory;
    public static String itemCategory;

    public UndergroundBiomes() {
        instance = this;
    }

    public static UndergroundBiomes instance() {
        return instance;
    }

    public boolean gotWorldSeed() {
        return this.gotWorldSeed;
    }

    public static final int generateHeight() {
        return generateHeight;
    }

    public static boolean buttonsOn() {
        return buttonsOn;
    }

    public static boolean stairsOn() {
        return stairsOn;
    }

    public static boolean wallsOn() {
        return wallsOn;
    }

    public static boolean harmoniousStrata() {
        return harmoniousStrata;
    }

    public static boolean changeStoneProducts() {
        return changeStoneProducts;
    }

    public static boolean replaceVillageGravel() {
        return replaceVillageGravel;
    }

    public static boolean crashOnProblems() {
        return crashOnProblems;
    }

    public static boolean forceConfigIds() {
        return forceConfigIds;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.config.load();
        this.igneousStoneID = this.config.get(blockCategory, "Igneous Stone ID:", 209).getInt();
        this.metamorphicStoneID = this.config.get(blockCategory, "Metamorphic Stone ID:", 210).getInt();
        this.sedimentaryStoneID = this.config.get(blockCategory, "Sedimentary Stone ID:", 211).getInt();
        this.igneousCobblestoneID = this.config.get(blockCategory, "Igneous Cobblestone ID:", 200).getInt();
        this.metamorphicCobblestoneID = this.config.get(blockCategory, "Metamorphic Cobblestone ID:", 201).getInt();
        this.igneousStoneBrickID = this.config.get(blockCategory, "Igneous Brick ID:", 202).getInt();
        this.metamorphicStoneBrickID = this.config.get(blockCategory, "Metamorphic Brick ID:", 203).getInt();
        this.igneousBrickSlabHalfID = this.config.get(blockCategory, "Igneous Stone Brick Slab ID (half):", 205).getInt();
        this.igneousBrickSlabFullID = this.config.get(blockCategory, "Igneous Stone Brick Slab ID (full):", 206).getInt();
        this.metamorphicBrickSlabHalfID = this.config.get(blockCategory, "Metamorphic Stone Brick Slab ID (half):", 207).getInt();
        this.metamorphicBrickSlabFullID = this.config.get(blockCategory, "Metamorphic Stone Brick Slab ID (full):", 208).getInt();
        this.igneousStoneSlabHalfID = this.config.get(blockCategory, "Igneous Stone Slab ID (half):", 215).getInt();
        this.igneousStoneSlabFullID = this.config.get(blockCategory, "Igneous Stone Slab ID (full):", 216).getInt();
        this.metamorphicStoneSlabHalfID = this.config.get(blockCategory, "Metamorphic Stone Slab ID (half):", 217).getInt();
        this.metamorphicStoneSlabFullID = this.config.get(blockCategory, "Metamorphic Stone Slab ID (full):", 218).getInt();
        this.igneousCobblestoneSlabHalfID = this.config.get(blockCategory, "Igneous Stone Cobblestone Slab ID (half):", 219).getInt();
        this.igneousCobblestoneSlabFullID = this.config.get(blockCategory, "Igneous Stone Cobblestone Slab ID (full):", 220).getInt();
        this.metamorphicCobblestoneSlabHalfID = this.config.get(blockCategory, "Metamorphic Stone Cobblestone Slab ID (half):", 221).getInt();
        this.metamorphicCobblestoneSlabFullID = this.config.get(blockCategory, "Metamorphic Stone Cobblestone Slab ID (full):", 222).getInt();
        this.sedimentaryStoneSlabHalfID = this.config.get(blockCategory, "Sedimentary Stone Slab ID (half):", 223).getInt();
        this.sedimentaryStoneSlabFullID = this.config.get(blockCategory, "Sedimentary Stone Slab ID (full):", 224).getInt();
        this.ligniteCoalID = this.config.get(blockCategory, "Lignite Item ID:", 5500).getInt();
        this.fossilPieceID = this.config.get(itemCategory, "fossilPiece", 5501).getInt();
        biomeSize = this.config.get("general", "biomeSize", 3, "Warning: exponential").getInt();
        addOreDictRecipes = this.config.get("general", "oreDictifyStone", true, "Modify all recipes to include Underground Biomes blocks").getBoolean(true);
        vanillaStoneBiomes = this.config.get("general", "vanillaStoneBiomes", false, "Will cause sharp biome transitions if changed while playing the same world").getBoolean(false);
        this.excludeDimensions = this.config.get("general", "excludeDimensionIDs", "-1,1", "Comma-separated list of dimension IDs, used only if include list is *").getString();
        this.includeDimensions = this.config.get("general", "includeDimensionIDs", "*", "Comma-separated list of dimension IDs, put * to use exclude list").getString();
        this.vanillaStoneCrafting = this.config.get("general", "vanillaStoneCrafting", 4, "0 = none; 1 = one rock; 2 = with redstone; 3 = 2x2 stone, lose 3; 4 = 2x2 stone").getInt();
        hardnessModifier = (float)this.config.get("general", "hardnessModifier", 1.5, "Increase to make stone longer to mine. Normal is 1.5").getDouble(1.5);
        resistanceModifier = (float)this.config.get("general", "resistanceModifier", 6.0, "Increase to make stone more resistant to explosions. Normal is 6.0").getDouble(6.0);
        replaceCobblestone = this.config.get("general", "replaceCobblestone", true, "Swap vanilla cobble and slabs with Underground Biomes where appropriate, plus some village changes").getBoolean(true);
        generateHeight = this.config.get("general", "generateHeight", 256, "Highest block to generated UB stone for").getInt();
        buttonsOn = this.config.get("general", "UndergroundBiomesButtons", true, "Provide Buttons for non-brick Underground Biomes blocks").getBoolean(true);
        stairsOn = this.config.get("general", "UndergroundBiomesStairs", true, "Provide Stairs for Underground Biomes blocks").getBoolean(true);
        wallsOn = this.config.get("general", "UndergroundBiomesWalls", true, "Provide Walls for Underground Biomes blocks").getBoolean(true);
        harmoniousStrata = this.config.get("general", "HarmoniousStrata", false, "Avoid jarring strata transitions").getBoolean(false);
        replaceVillageGravel = this.config.get("general", "ReplaceVillageGravel", false, "Replace village gravel with brick").getBoolean(false);
        crashOnProblems = this.config.get("general", "CrashOnProblems", false, "Crash rather than try to get by when encountering problems").getBoolean(false);
        forceConfigIds = this.config.get("general", "ForceConfigIds", false, "(for worlds created pre-1.7) Force IDs to config values").getBoolean(false);
        if (this.includeDimensions.equals("*")) {
            this.excludeDimensionIDs = new ArrayList<Integer>();
            for (String v : this.excludeDimensions.split(",")) {
                this.excludeDimensionIDs.add(Integer.parseInt(v));
            }
        } else {
            this.includeDimensionIDs = new ArrayList<Integer>();
            for (String v : this.includeDimensions.split(",")) {
                this.includeDimensionIDs.add(Integer.parseInt(v));
            }
        }
        this.dimensionManager = new DimensionManager(this.config);
        this.config.save();
        fortuneAffected = new ArrayList();
        nuggets = new ArrayList();
        nuggets.add(new ItemStack((Item)Item.field_150901_e.func_82594_a("goldNugget"), 1, 0));
        tabModBlocks = new CreativeTabModBlocks("undergroundBiomesBlocks");
        tabModItems = new CreativeTabModBlocks("undergroundBiomesItems");
        proxy.registerRenderThings();
        igneousStone = new BlockIgneousStone();
        IDs.igneousStoneName.gameRegister(igneousStone, ItemMetadataBlock.class);
        igneousCobblestone = new BlockIgneousCobblestone();
        IDs.igneousCobblestoneName.gameRegister(igneousCobblestone, ItemMetadataBlock.class);
        igneousStoneBrick = new BlockIgneousStoneBrick();
        IDs.igneousStoneBrickName.gameRegister(igneousStoneBrick, ItemMetadataBlock.class);
        metamorphicStone = new BlockMetamorphicStone();
        IDs.metamorphicStoneName.gameRegister(metamorphicStone, ItemMetadataBlock.class);
        metamorphicCobblestone = new BlockMetamorphicCobblestone();
        IDs.metamorphicCobblestoneName.gameRegister(metamorphicCobblestone, ItemMetadataBlock.class);
        metamorphicStoneBrick = new BlockMetamorphicStoneBrick();
        IDs.metamorphicStoneBrickName.gameRegister(metamorphicStoneBrick, ItemMetadataBlock.class);
        sedimentaryStone = new BlockSedimentaryStone();
        IDs.sedimentaryStoneName.gameRegister(sedimentaryStone, ItemMetadataBlock.class);
        igneousBrickSlab = this.stoneSlabPair(igneousStoneBrick, IDs.igneousBrickSlabName);
        metamorphicBrickSlab = this.stoneSlabPair(metamorphicStoneBrick, IDs.metamorphicBrickSlabName);
        igneousStoneSlab = this.stoneSlabPair(igneousStone, IDs.igneousStoneSlabName);
        metamorphicStoneSlab = this.stoneSlabPair(metamorphicStone, IDs.metamorphicStoneSlabName);
        igneousCobblestoneSlab = this.stoneSlabPair(igneousCobblestone, IDs.igneousCobblestoneSlabName);
        metamorphicCobblestoneSlab = this.stoneSlabPair(metamorphicCobblestone, IDs.metamorphicCobblestoneSlabName);
        sedimentaryStoneSlab = this.stoneSlabPair(sedimentaryStone, IDs.sedimentaryStoneSlabName);
        ligniteCoal = new ItemLigniteCoal(this.ligniteCoalID);
        fossilPiece = new ItemFossilPiece(this.fossilPieceID);
        fortuneAffected.add(ligniteCoal.func_77658_a());
        UndergroundBiomes.tabModItems.item = ligniteCoal;
        proxy.setUpBlockNames();
        this.constructs = new UndergroundBiomesConstructs();
        this.constructs.preInit(this.config);
        this.config.save();
        this.defaultIDSetter = this.defaultIDs();
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public StoneSlabPair stoneSlabPair(BlockMetadataBase material, NamedSlabPair slabPairName) {
        BlockStoneSlab half = new BlockStoneSlab(false, material, slabPairName);
        BlockStoneSlab full = new BlockStoneSlab(true, material, slabPairName);
        GameRegistry.registerBlock((Block)half, ItemMetadataSlab.class, (String)slabPairName.half.internal(), (String)IDs.ubPrefix(), (Object[])new Object[]{full});
        GameRegistry.registerBlock((Block)full, ItemMetadataSlab.class, (String)slabPairName.full.internal(), (String)IDs.ubPrefix(), (Object[])new Object[]{half});
        return new StoneSlabPair(half, full);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        this.addOreDicts();
        this.addRecipes();
        this.constructs.load(event);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
        if (replaceCobblestone) {
            MinecraftForge.EVENT_BUS.register((Object)this.dimensionManager);
            MinecraftForge.TERRAIN_GEN_BUS.register((Object)this.dimensionManager);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) throws Exception {
        if (addOreDictRecipes) {
            UndergroundBiomes.oreDictifyStone();
        }
        for (String s : nuggetStrings) {
            ArrayList stacks = OreDictionary.getOres((String)s);
            if (stacks.size() <= 0) continue;
            nuggets.add((ItemStack)stacks.get(0));
        }
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            // empty if block
        }
        this.constructs.postInit(event);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerAboutToStartEvent event) {
        logger.info("server about to start");
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        logger.info("server starting");
        event.registerServerCommand((ICommand)new CommandOreDictifyStone());
    }

    @Mod.EventHandler
    public void onMissingMapping(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping missing : event.get()) {
            logger.info(missing.name + " " + missing.type.toString());
        }
        throw new RuntimeException();
    }

    @Mod.EventHandler
    public void adjustMappings(FMLModIdMappingEvent event) {
        boolean oldIDs = false;
        logger.info("remapping");
        ImmutableList remappings = event.remappedIds;
        for (FMLModIdMappingEvent.ModRemapping remapping : remappings) {
            logger.info(remapping.tag + " from " + remapping.oldId + " to " + remapping.newId);
            if (remapping.tag.equals("inecraft:bed") && remapping.oldId < 256) {
                oldIDs = true;
            }
            if (remapping.tag.equals("Minecraft:bed") && remapping.oldId < 256) {
                oldIDs = true;
            }
            if (remapping.tag.equals("inecraft:wheat") && remapping.oldId < 256) {
                oldIDs = true;
            }
            if (!remapping.tag.equals("Minecraft:wheat") || remapping.oldId >= 256) continue;
            oldIDs = true;
        }
        if (oldIDs) {
            this.forceConfigIDs();
            this.runningConfigIDs = true;
        }
    }

    public void addRecipes() {
        if (!addOreDictRecipes) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(NamedVanillaBlock.furnace.block(), 1), new Object[]{"XXX", "X X", "XXX", Character.valueOf('X'), UndergroundBiomes.oreCobblestoneName()}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(NamedVanillaBlock.lever.block(), 1), new Object[]{"I", "X", Character.valueOf('X'), UndergroundBiomes.oreCobblestoneName(), Character.valueOf('I'), NamedVanillaItem.stick.cachedItem()}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(NamedVanillaBlock.piston.block(), 1), new Object[]{"WWW", "CIC", "CRC", Character.valueOf('W'), NamedVanillaBlock.planks.block(), Character.valueOf('C'), UndergroundBiomes.oreCobblestoneName(), Character.valueOf('I'), NamedVanillaItem.ingotIron.cachedItem(), Character.valueOf('R'), NamedVanillaItem.redstone.cachedItem()}));
            if (!UndergroundBiomes.stairsOn()) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(NamedVanillaBlock.stairsCobblestone.block(), 4), new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), UndergroundBiomes.oreCobblestoneName()}));
            }
            if (!UndergroundBiomes.wallsOn()) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(NamedVanillaBlock.cobblestone_wall.block(), 1), new Object[]{"XXX", "XXX", Character.valueOf('X'), UndergroundBiomes.oreCobblestoneName()}));
            }
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(NamedVanillaItem.axeStone.cachedItem(), 1), new Object[]{"XX ", "XW ", " W ", Character.valueOf('X'), UndergroundBiomes.oreCobblestoneName(), Character.valueOf('W'), NamedVanillaItem.stick.cachedItem()}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(NamedVanillaItem.pickaxeStone.cachedItem(), 1), new Object[]{"XXX", " W ", " W ", Character.valueOf('X'), UndergroundBiomes.oreCobblestoneName(), Character.valueOf('W'), NamedVanillaItem.stick.cachedItem()}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(NamedVanillaItem.hoeStone.cachedItem(), 1), new Object[]{"XX ", " W ", " W ", Character.valueOf('X'), UndergroundBiomes.oreCobblestoneName(), Character.valueOf('W'), NamedVanillaItem.stick.cachedItem()}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(NamedVanillaItem.shovelStone.cachedItem(), 1), new Object[]{" X ", " W ", " W ", Character.valueOf('X'), UndergroundBiomes.oreCobblestoneName(), Character.valueOf('W'), NamedVanillaItem.stick.cachedItem()}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(NamedVanillaItem.swordStone.cachedItem(), 1), new Object[]{"X", "X", "W", Character.valueOf('X'), UndergroundBiomes.oreCobblestoneName(), Character.valueOf('W'), NamedVanillaItem.stick.cachedItem()}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(NamedVanillaItem.brewingStand.cachedItem(), 1), new Object[]{" B ", "XXX", Character.valueOf('X'), UndergroundBiomes.oreCobblestoneName(), Character.valueOf('B'), NamedVanillaItem.blazeRod.cachedItem()}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(NamedVanillaBlock.dispenser.block(), 1), new Object[]{"XXX", "XBX", "XRX", Character.valueOf('X'), UndergroundBiomes.oreCobblestoneName(), Character.valueOf('B'), NamedVanillaItem.bow.cachedItem(), Character.valueOf('R'), NamedVanillaItem.redstone.cachedItem()}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(NamedVanillaBlock.stone_pressure_plate.block(), 1), new Object[]{"XX", Character.valueOf('X'), UndergroundBiomes.oreStoneName()}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(NamedVanillaItem.redstoneRepeater.cachedItem(), 1), new Object[]{"TRT", "XXX", Character.valueOf('X'), UndergroundBiomes.oreStoneName(), Character.valueOf('T'), NamedVanillaBlock.torchRedstoneActive.block(), Character.valueOf('R'), NamedVanillaItem.redstone.cachedItem()}));
            if (!UndergroundBiomes.stairsOn()) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(NamedVanillaBlock.stairsStoneBrick.block(), 4), new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), "stoneBricks"}));
            }
            if (!UndergroundBiomes.buttonsOn()) {
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(NamedVanillaBlock.stoneButton.block(), 1), new Object[]{UndergroundBiomes.oreStoneName()}));
            }
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack(NamedVanillaItem.coal.cachedItem(), 1), (Object[])new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), ligniteCoal});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151100_aR, 1, 15), (Object[])new Object[]{new ItemStack(fossilPiece, 1, Short.MAX_VALUE)});
        switch (this.vanillaStoneCrafting) {
            case 1: {
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(NamedVanillaBlock.cobblestone.block(), 1), new Object[]{UndergroundBiomes.oreCobblestoneName()}));
                break;
            }
            case 2: {
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(NamedVanillaBlock.cobblestone.block(), 1), new Object[]{NamedVanillaItem.redstone.cachedItem(), UndergroundBiomes.oreCobblestoneName()}));
                break;
            }
            case 3: {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(NamedVanillaBlock.cobblestone.block(), 1), new Object[]{"XX", "XX", Character.valueOf('X'), UndergroundBiomes.oreCobblestoneName()}));
                break;
            }
            case 4: {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(NamedVanillaBlock.cobblestone.block(), 4), new Object[]{"XX", "XX", Character.valueOf('X'), UndergroundBiomes.oreCobblestoneName()}));
                break;
            }
        }
        for (int i = 0; i < 8; ++i) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)UndergroundBiomes.igneousBrickSlab.half, 6, i), (Object[])new Object[]{"XXX", Character.valueOf('X'), new ItemStack((Block)igneousStoneBrick, 1, i)});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)UndergroundBiomes.metamorphicBrickSlab.half, 6, i), (Object[])new Object[]{"XXX", Character.valueOf('X'), new ItemStack((Block)metamorphicStoneBrick, 1, i)});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)UndergroundBiomes.igneousStoneSlab.half, 6, i), (Object[])new Object[]{"XXX", Character.valueOf('X'), new ItemStack((Block)igneousStone, 1, i)});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)UndergroundBiomes.metamorphicStoneSlab.half, 6, i), (Object[])new Object[]{"XXX", Character.valueOf('X'), new ItemStack((Block)metamorphicStone, 1, i)});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)UndergroundBiomes.igneousCobblestoneSlab.half, 6, i), (Object[])new Object[]{"XXX", Character.valueOf('X'), new ItemStack((Block)igneousCobblestone, 1, i)});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)UndergroundBiomes.metamorphicCobblestoneSlab.half, 6, i), (Object[])new Object[]{"XXX", Character.valueOf('X'), new ItemStack((Block)metamorphicCobblestone, 1, i)});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)UndergroundBiomes.sedimentaryStoneSlab.half, 6, i), (Object[])new Object[]{"XXX", Character.valueOf('X'), new ItemStack((Block)sedimentaryStone, 1, i)});
            FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack((Block)metamorphicCobblestone, 1, i), new ItemStack((Block)metamorphicStone, 1, i), 0.1f);
            FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack((Block)igneousCobblestone, 1, i), new ItemStack((Block)igneousStone, 1, i), 0.1f);
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)metamorphicStoneBrick, 4, i), (Object[])new Object[]{"xx", "xx", Character.valueOf('x'), new ItemStack((Block)metamorphicStone, 1, i)});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)igneousStoneBrick, 4, i), (Object[])new Object[]{"xx", "xx", Character.valueOf('x'), new ItemStack((Block)igneousStone, 1, i)});
        }
        GameRegistry.registerFuelHandler((IFuelHandler)new FuelManager());
    }

    public void addOreDicts() {
        OreDictionary.registerOre((String)UndergroundBiomes.oreStoneName(), (ItemStack)new ItemStack((Block)igneousStone, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)UndergroundBiomes.oreStoneName(), (ItemStack)new ItemStack((Block)metamorphicStone, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)UndergroundBiomes.oreCobblestoneName(), (ItemStack)new ItemStack((Block)igneousCobblestone, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)UndergroundBiomes.oreCobblestoneName(), (ItemStack)new ItemStack((Block)metamorphicCobblestone, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"stoneBricks", (ItemStack)new ItemStack((Block)igneousStoneBrick, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"stoneBricks", (ItemStack)new ItemStack((Block)metamorphicStoneBrick, 1, Short.MAX_VALUE));
    }

    public static int oreDictifyStone() throws Exception {
        ItemStack output;
        int numReplaced = 0;
        HashMap<ItemStack, String> replacements = new HashMap<ItemStack, String>();
        replacements.put(new ItemStack(NamedVanillaBlock.stone.block(), 1, Short.MAX_VALUE), UndergroundBiomes.oreStoneName());
        replacements.put(new ItemStack(NamedVanillaBlock.cobblestone.block(), 1, Short.MAX_VALUE), UndergroundBiomes.oreCobblestoneName());
        replacements.put(new ItemStack(NamedVanillaBlock.stoneBrick.block(), 1, Short.MAX_VALUE), "stoneBricks");
        ItemStack[] replaceStacks = replacements.keySet().toArray(new ItemStack[replacements.keySet().size()]);
        ItemStack[] exclusions = new ItemStack[]{new ItemStack(NamedVanillaBlock.stairsStoneBrick.block()), new ItemStack(NamedVanillaBlock.stoneBrick.block()), new ItemStack(NamedVanillaBlock.stoneSingleSlab.block(), 1, 5)};
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        Constructor shapedConstr = ShapedOreRecipe.class.getDeclaredConstructor(ShapedRecipes.class, Map.class);
        Constructor shapelessConstr = ShapelessOreRecipe.class.getDeclaredConstructor(ShapelessRecipes.class, Map.class);
        shapedConstr.setAccessible(true);
        shapelessConstr.setAccessible(true);
        if (buttonsOn) {
            Iterator iterator = CraftingManager.func_77594_a().func_77592_b().iterator();
            while (iterator.hasNext()) {
                IRecipe recipe = (IRecipe)iterator.next();
                if (recipe == null || (output = recipe.func_77571_b()) == null || !NamedVanillaBlock.stoneButton.matches(output.func_77973_b())) continue;
                iterator.remove();
            }
        }
        for (ItemStack stack : replacements.keySet()) {
            OreDictionary.registerOre((String)((String)replacements.get(stack)), (ItemStack)stack);
        }
        for (int i = 0; i < recipes.size(); ++i) {
            ShapedRecipes recipe;
            Object obj = recipes.get(i);
            output = ((IRecipe)obj).func_77571_b();
            if (output != null && UndergroundBiomes.containsMatch(false, exclusions, output) || UndergroundBiomesConstructs.overridesRecipe((IRecipe)obj)) continue;
            if (obj instanceof ShapedRecipes) {
                recipe = (ShapedRecipes)obj;
                if (!UndergroundBiomes.containsMatch(true, recipe.field_77574_d, replaceStacks)) continue;
                recipes.set(i, (ShapedOreRecipe)shapedConstr.newInstance(recipe, replacements));
                ++numReplaced;
                System.out.println("Changed shaped recipe for " + output.func_82833_r());
                continue;
            }
            if (obj instanceof ShapelessRecipes) {
                recipe = (ShapelessRecipes)obj;
                if (!UndergroundBiomes.containsMatch(true, recipe.field_77579_b.toArray(new ItemStack[recipe.field_77579_b.size()]), replaceStacks)) continue;
                recipes.set(i, (ShapelessOreRecipe)shapelessConstr.newInstance(recipe, replacements));
                ++numReplaced;
                System.out.println("Changed shapeless recipe for " + output.func_82833_r());
                continue;
            }
            if (obj instanceof ShapedOreRecipe) {
                recipe = (ShapedOreRecipe)obj;
                if (!UndergroundBiomes.containsMatchReplaceInplace(true, recipe.getInput(), replaceStacks, replacements)) continue;
                ++numReplaced;
                System.out.println("Changed shaped ore recipe for " + output.func_82833_r());
                continue;
            }
            if (!(obj instanceof ShapelessOreRecipe) || !UndergroundBiomes.containsMatchReplaceInplace(true, (recipe = (ShapelessOreRecipe)obj).getInput(), replaceStacks, replacements)) continue;
            ++numReplaced;
            System.out.println("Changed shapeless ore recipe for " + output.func_82833_r());
        }
        return numReplaced;
    }

    private static boolean containsMatch(boolean strict, ItemStack[] inputs, ItemStack ... targets) {
        try {
            for (ItemStack input : inputs) {
                for (ItemStack target : targets) {
                    if (!OreDictionary.itemMatches((ItemStack)target, (ItemStack)input, (boolean)strict)) continue;
                    return true;
                }
            }
        }
        catch (NullPointerException e) {
            return false;
        }
        return false;
    }

    private static boolean containsMatchReplaceInplace(boolean strict, Object inputArrayOrList, ItemStack[] targets, Map<ItemStack, String> replacements) {
        boolean replaced = false;
        if (inputArrayOrList instanceof ArrayList) {
            ArrayList inputList = (ArrayList)inputArrayOrList;
            for (int i = 0; i < inputList.size(); ++i) {
                Object input = inputList.get(i);
                if (!(input instanceof ItemStack)) continue;
                for (ItemStack target : targets) {
                    if (!OreDictionary.itemMatches((ItemStack)target, (ItemStack)((ItemStack)input), (boolean)strict)) continue;
                    inputList.set(i, OreDictionary.getOres((String)replacements.get(target)));
                    replaced = true;
                }
            }
        } else {
            Object[] inputArray = (Object[])inputArrayOrList;
            for (int i = 0; i < inputArray.length; ++i) {
                Object input = inputArray[i];
                if (!(input instanceof ItemStack)) continue;
                for (ItemStack target : targets) {
                    if (!OreDictionary.itemMatches((ItemStack)target, (ItemStack)((ItemStack)input), (boolean)strict)) continue;
                    inputArray[i] = OreDictionary.getOres((String)replacements.get(target));
                    replaced = true;
                }
            }
        }
        return replaced;
    }

    public static long getWorldSeed() {
        return worldSeed;
    }

    public static World getWorld() {
        return world;
    }

    public boolean inChunkGenerationAllowed(int id) {
        return this.dimensionManager.inChunkGenerationAllowed(id);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!this.gotWorldSeed) {
            world = event.world;
            worldSeed = world.func_72905_C();
            this.gotWorldSeed = true;
        }
        UndergroundBiomes.tabModBlocks.item = ItemMetadataBlock.itemFrom(IDs.igneousStoneBrickName);
        this.dimensionManager.setupGenerators(event);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        this.gotWorldSeed = false;
        this.ubCodeLocations.clear();
        this.dimensionManager.unload();
        if (this.runningConfigIDs) {
            this.defaultIDSetter.redoAsNeeded();
            this.runningConfigIDs = false;
        }
    }

    @SubscribeEvent
    public void onBiomeDecorate(DecorateBiomeEvent.Post event) {
        this.dimensionManager.onBiomeDecorate(event);
    }

    @SubscribeEvent
    public void registerOre(OreDictionary.OreRegisterEvent event) {
        if (Arrays.asList(nuggets).contains(event.Name)) {
            nuggets.add(event.Ore);
        }
    }

    public static String oreStoneName() {
        if (UndergroundBiomes.forgeVersion() < 934) {
            return "stoneSmooth";
        }
        return "stone";
    }

    public static String oreCobblestoneName() {
        if (UndergroundBiomes.forgeVersion() < 934) {
            return "stoneCobble";
        }
        return "cobblestone";
    }

    public static int forgeVersion() {
        return ForgeVersion.getBuildVersion();
    }

    private WatchList configList() {
        WatchList forcing = new WatchList();
        forcing.addChangeWithItem(this.igneousStoneID, igneousStone);
        forcing.addChangeWithItem(this.metamorphicStoneID, metamorphicStone);
        forcing.addChangeWithItem(this.sedimentaryStoneID, sedimentaryStone);
        forcing.addChangeWithItem(this.igneousCobblestoneID, igneousCobblestone);
        forcing.addChangeWithItem(this.metamorphicCobblestoneID, metamorphicCobblestone);
        forcing.addChangeWithItem(this.igneousStoneBrickID, igneousStoneBrick);
        forcing.addChangeWithItem(this.metamorphicStoneBrickID, metamorphicStoneBrick);
        forcing.addChangeWithItem(this.igneousBrickSlabHalfID, (Block)UndergroundBiomes.igneousBrickSlab.half);
        forcing.addChangeWithItem(this.igneousBrickSlabFullID, (Block)UndergroundBiomes.igneousBrickSlab.full);
        forcing.addChangeWithItem(this.metamorphicBrickSlabHalfID, (Block)UndergroundBiomes.metamorphicBrickSlab.half);
        forcing.addChangeWithItem(this.metamorphicBrickSlabFullID, (Block)UndergroundBiomes.metamorphicBrickSlab.full);
        forcing.addChangeWithItem(this.igneousStoneSlabHalfID, (Block)UndergroundBiomes.igneousStoneSlab.half);
        forcing.addChangeWithItem(this.igneousStoneSlabFullID, (Block)UndergroundBiomes.igneousStoneSlab.full);
        forcing.addChangeWithItem(this.metamorphicStoneSlabHalfID, (Block)UndergroundBiomes.metamorphicStoneSlab.half);
        forcing.addChangeWithItem(this.metamorphicStoneSlabFullID, (Block)UndergroundBiomes.metamorphicStoneSlab.full);
        forcing.addChangeWithItem(this.igneousCobblestoneSlabHalfID, (Block)UndergroundBiomes.igneousCobblestoneSlab.half);
        forcing.addChangeWithItem(this.igneousCobblestoneSlabFullID, (Block)UndergroundBiomes.igneousCobblestoneSlab.full);
        forcing.addChangeWithItem(this.metamorphicCobblestoneSlabHalfID, (Block)UndergroundBiomes.metamorphicCobblestoneSlab.half);
        forcing.addChangeWithItem(this.metamorphicCobblestoneSlabFullID, (Block)UndergroundBiomes.metamorphicCobblestoneSlab.full);
        forcing.addChangeWithItem(this.sedimentaryStoneSlabHalfID, (Block)UndergroundBiomes.sedimentaryStoneSlab.half);
        forcing.addChangeWithItem(this.sedimentaryStoneSlabFullID, (Block)UndergroundBiomes.sedimentaryStoneSlab.full);
        forcing.addChange(this.constructs.stoneButtonID(), this.constructs.stoneButton().construct);
        forcing.addChange(this.constructs.stoneStairID(), this.constructs.stoneStair().construct);
        forcing.addChange(this.constructs.stoneWallID(), this.constructs.stoneWall().construct);
        return forcing;
    }

    private WatchList defaultIDs() {
        WatchList forcing = new WatchList();
        forcing.addWithItem(igneousStone);
        forcing.addWithItem(metamorphicStone);
        forcing.addWithItem(sedimentaryStone);
        forcing.addWithItem(igneousCobblestone);
        forcing.addWithItem(metamorphicCobblestone);
        forcing.addWithItem(igneousStoneBrick);
        forcing.addWithItem(metamorphicStoneBrick);
        forcing.addWithItem((Block)UndergroundBiomes.igneousBrickSlab.half);
        forcing.addWithItem((Block)UndergroundBiomes.igneousBrickSlab.full);
        forcing.addWithItem((Block)UndergroundBiomes.metamorphicBrickSlab.half);
        forcing.addWithItem((Block)UndergroundBiomes.metamorphicBrickSlab.full);
        forcing.addWithItem((Block)UndergroundBiomes.igneousStoneSlab.half);
        forcing.addWithItem((Block)UndergroundBiomes.igneousStoneSlab.full);
        forcing.addWithItem((Block)UndergroundBiomes.metamorphicStoneSlab.half);
        forcing.addWithItem((Block)UndergroundBiomes.metamorphicStoneSlab.full);
        forcing.addWithItem((Block)UndergroundBiomes.igneousCobblestoneSlab.half);
        forcing.addWithItem((Block)UndergroundBiomes.igneousCobblestoneSlab.full);
        forcing.addWithItem((Block)UndergroundBiomes.metamorphicCobblestoneSlab.half);
        forcing.addWithItem((Block)UndergroundBiomes.metamorphicCobblestoneSlab.full);
        forcing.addWithItem((Block)UndergroundBiomes.sedimentaryStoneSlab.half);
        forcing.addWithItem((Block)UndergroundBiomes.sedimentaryStoneSlab.full);
        forcing.add(this.constructs.stoneButton().construct);
        forcing.add(this.constructs.stoneStair().construct);
        forcing.add(this.constructs.stoneWall().construct);
        return forcing;
    }

    private void forceConfigIDs() {
        WatchList forcing = this.configList();
        try {
            for (String warning : forcing.problems()) {
                logger.info(warning);
            }
            logger.info("forcing config IDs ");
            forcing.redoAsNeeded();
            for (String warning : forcing.problems()) {
                logger.info(warning);
            }
        }
        catch (Exception e) {
            logger.info("redoerror " + e.toString());
        }
        WatchList check = new WatchList();
        check.add(this.constructs.stoneButton().construct);
        check.add(this.constructs.stoneStair().construct);
        check.add(this.constructs.stoneWall().construct);
        for (ItemUBStairs item : ItemUBStairs.instances) {
            check.add((Item)item);
        }
        for (String warning : check.problems()) {
            logger.info(warning);
        }
    }

    static {
        addOreDictRecipes = true;
        vanillaStoneBiomes = false;
        textures = "/exterminatorJeff/undergroundBiomes/textures.png";
        nuggetStrings = new String[]{"nuggetIron", "nuggetCopper", "nuggetTin", "nuggetSilver", "nuggetLead", "nuggetAluminium", "nuggetNaturalAluminium", "nuggetNickel", "nuggetPlatinum", "nuggetElectrum", "nuggetZinc"};
        generateHeight = 256;
        biomeSize = 45;
        blockCategory = "block";
        itemCategory = "item";
    }
}

