/*
 * Decompiled with CFR 0.152.
 */
package exterminatorJeff.undergroundBiomes.constructs;

import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import exterminatorJeff.undergroundBiomes.common.UndergroundBiomes;
import exterminatorJeff.undergroundBiomes.common.block.BlockMetadataBase;
import exterminatorJeff.undergroundBiomes.constructs.IconTrap;
import exterminatorJeff.undergroundBiomes.constructs.block.UBButtonGroup;
import exterminatorJeff.undergroundBiomes.constructs.block.UBStairsGroup;
import exterminatorJeff.undergroundBiomes.constructs.block.UBWallGroup;
import exterminatorJeff.undergroundBiomes.constructs.entity.UndergroundBiomesTileEntity;
import exterminatorJeff.undergroundBiomes.constructs.util.UndergroundBiomesBlockList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButtonStone;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockWall;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.config.Configuration;

public class UndergroundBiomesConstructs {
    public static int subdivisionBlockCount = 4;
    private UBStairsGroup stoneStair;
    private int stoneStairID;
    private UBWallGroup stoneWall;
    private int stoneWallID;
    private UBButtonGroup stoneButton;
    private int stoneButtonID;
    private BlockMetadataBase iconTrap;
    public Configuration config;
    private UndergroundBiomesBlockList ubBlockList;
    public static String blockCategory = "block";
    public static String itemCategory = "item";

    public int stoneStairID() {
        return this.stoneStairID;
    }

    public UBStairsGroup stoneStair() {
        return this.stoneStair;
    }

    public int stoneWallID() {
        return this.stoneWallID;
    }

    public UBWallGroup stoneWall() {
        return this.stoneWall;
    }

    public int stoneButtonID() {
        return this.stoneButtonID;
    }

    public UBButtonGroup stoneButton() {
        return this.stoneButton;
    }

    public void preInit(Configuration config) {
        this.config = config;
        this.ubBlockList = new UndergroundBiomesBlockList();
        GameRegistry.registerTileEntity(UndergroundBiomesTileEntity.class, (String)"UndergroundBiomesTileEntity");
        this.iconTrap = new IconTrap();
        if (UndergroundBiomes.buttonsOn()) {
            this.preInitButtons();
        }
        if (UndergroundBiomes.stairsOn()) {
            this.preInitStairs();
        }
        if (UndergroundBiomes.wallsOn()) {
            this.preInitWalls();
        }
    }

    public void preInitStairs() {
        this.stoneStair = new UBStairsGroup();
        this.stoneStairID = this.config.get(blockCategory, "Universal Biomes Stairs ID:", 212).getInt();
        this.stoneStair.baseBlock = this.iconTrap;
        this.stoneStair.define(this.stoneStairID);
    }

    public void preInitWalls() {
        this.stoneWall = new UBWallGroup();
        this.stoneWallID = this.config.get(blockCategory, "Universal Biomes Wall ID:", 213).getInt();
        this.stoneWall.baseBlock = this.ubBlockList.sedimentaryStone;
        this.stoneWall.define(this.stoneWallID);
    }

    public void preInitButtons() {
        this.stoneButton = new UBButtonGroup();
        this.stoneButtonID = this.config.get(blockCategory, "Universal Biomes Button ID:", 214).getInt();
        this.stoneButton.baseBlock = this.ubBlockList.sedimentaryStone;
        this.stoneButton.define(this.stoneButtonID);
    }

    public void load(FMLInitializationEvent event) {
        if (UndergroundBiomes.buttonsOn()) {
            this.loadButtons();
        }
        if (UndergroundBiomes.stairsOn()) {
            this.loadStairs();
        }
        if (UndergroundBiomes.wallsOn()) {
            this.loadWalls();
        }
    }

    private void loadStairs() {
        this.stoneStair.addRecipes();
    }

    private void loadWalls() {
        this.stoneWall.addRecipes();
    }

    private void loadButtons() {
        this.stoneButton.addRecipes();
    }

    public void postInit(FMLPostInitializationEvent event) throws Exception {
    }

    public static boolean overridesRecipe(IRecipe recipe) {
        if (recipe == null) {
            return false;
        }
        Item output = null;
        try {
            output = recipe.func_77571_b().func_77973_b();
        }
        catch (Exception e) {
            return false;
        }
        if (!(output instanceof ItemBlock)) {
            return false;
        }
        Block blockMade = ((ItemBlock)output).field_150939_a;
        if (UndergroundBiomes.buttonsOn() && blockMade instanceof BlockButtonStone) {
            return true;
        }
        if (UndergroundBiomes.stairsOn() && blockMade instanceof BlockStairs) {
            return true;
        }
        if (UndergroundBiomes.wallsOn() && blockMade instanceof BlockWall) {
            return true;
        }
        if (blockMade instanceof BlockSlab) {
            return !blockMade.func_149662_c();
        }
        return false;
    }
}

