/*
 * Decompiled with CFR 0.152.
 */
package exterminatorJeff.undergroundBiomes.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import exterminatorJeff.undergroundBiomes.api.NamedBlock;
import exterminatorJeff.undergroundBiomes.common.UndergroundBiomes;
import exterminatorJeff.undergroundBiomes.constructs.util.Zeno410Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public abstract class BlockMetadataBase
extends Block {
    protected IIcon[] textures = new IIcon[]{null, null, null, null, null, null, null, null};
    protected boolean replaceableByOre = true;
    public static Logger logger = new Zeno410Logger("BlockMetadataBase").logger();
    public final NamedBlock namer;
    public static final int metadatas = 8;

    public BlockMetadataBase(NamedBlock block) {
        super(Material.field_151576_e);
        this.func_149663_c(block.internal());
        this.func_149647_a(UndergroundBiomes.tabModBlocks);
        this.namer = block;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        for (int i = 0; i < 8; ++i) {
            this.textures[i] = iconRegister.func_94245_a("undergroundbiomes:" + this.getBlockName(i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return this.textures[metadata & 7];
    }

    @SideOnly(value=Side.CLIENT)
    protected String func_149641_N() {
        return this.field_149768_d == null ? "MISSING_ICON_BLOCK_" + BlockMetadataBase.func_149682_b((Block)this) + "_" + this.func_149739_a() : this.field_149768_d;
    }

    public void func_149666_a(Item id, CreativeTabs tabs, List list) {
        for (int i = 0; i < 8; ++i) {
            list.add(new ItemStack(id, 1, i));
        }
    }

    public int func_149692_a(int metadata) {
        return metadata & 7;
    }

    public boolean isReplaceableOreGen(World world, int x, int y, int z, Block target) {
        return this.replaceableByOre;
    }

    public float getBlockHardness(int meta) {
        return this.field_149782_v;
    }

    public float getBlockExplosionResistance(int meta) {
        return this.field_149781_w;
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return this.getBlockExplosionResistance(this.func_149643_k(world, x, y, z) & 7);
    }

    public float func_149712_f(World world, int x, int y, int z) {
        return this.getBlockHardness(this.func_149643_k(world, x, y, z) & 7);
    }

    protected ItemStack func_149644_j(int metadata) {
        return new ItemStack((Block)this, 1, metadata & 7);
    }

    public ItemStack itemDropped(int metadata, Random random, int fortune, int y) {
        return new ItemStack((Block)this, 1, metadata & 7);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int count = 1;
        ItemStack stack = this.itemDropped(metadata, world.field_73012_v, fortune, y);
        if (fortune != 0 && UndergroundBiomes.fortuneAffected.contains(stack.func_77973_b().func_77658_a())) {
            int j = world.field_73012_v.nextInt(fortune + 2);
            count = j < 1 ? 1 : j;
        }
        for (int i = 0; i < count; ++i) {
            ret.add(stack);
        }
        return ret;
    }

    public abstract String getBlockTypeName(int var1);

    public abstract boolean hasRareDrops();

    public String getBlockName(int index) {
        return this.getBlockTypeName(index);
    }
}

