/*
 * Decompiled with CFR 0.152.
 */
package exterminatorJeff.undergroundBiomes.common;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import exterminatorJeff.undergroundBiomes.api.UBAPIHook;
import exterminatorJeff.undergroundBiomes.api.UBDimensionalStrataColumnProvider;
import exterminatorJeff.undergroundBiomes.api.UBStrataColumnProvider;
import exterminatorJeff.undergroundBiomes.common.UndergroundBiomes;
import exterminatorJeff.undergroundBiomes.common.WorldGenManager;
import exterminatorJeff.undergroundBiomes.constructs.util.Consumable;
import exterminatorJeff.undergroundBiomes.constructs.util.DimensionSet;
import exterminatorJeff.undergroundBiomes.constructs.util.Zeno410Logger;
import exterminatorJeff.undergroundBiomes.worldGen.UBBlockProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.world.WorldEvent;

public class DimensionManager {
    public static Logger logger = new Zeno410Logger("DimensionManager").logger();
    private Map<Integer, WorldGenManager> worldGenManagers = new HashMap<Integer, WorldGenManager>();
    private boolean serverAdjusted = false;
    private boolean dimensionSpecificSeeds = false;
    private boolean inChunkGeneration;
    private final DimensionSet.Include includeDimensionIDs;
    private final DimensionSet.Exclude excludeDimensionIDs;
    private final Consumable<String> includeDimensions;
    private final Consumable<String> excludeDimensions;
    private final DimensionSet.Include inChunkGenerationIncludeIDs;
    private final DimensionSet.Exclude inChunkGenerationExcludeIDs;
    private final Consumable<String> inChunkGenerationInclude;
    private final Consumable<String> inChunkGenerationExclude;
    private List<Integer> inChunkDimensionIDs = new ArrayList<Integer>();
    private WorldGenManager villageWorldGenManager;

    public boolean inChunkGeneration() {
        return this.inChunkGeneration;
    }

    public long dimensionSeed(int dimension) {
        if (this.dimensionSpecificSeeds) {
            return UndergroundBiomes.worldSeed + (long)(dimension * 100);
        }
        return UndergroundBiomes.worldSeed;
    }

    public WorldGenManager worldGenManager(int dimension) {
        WorldGenManager result = this.worldGenManagers.get(dimension);
        if (result == null) {
            result = new WorldGenManager(this.dimensionSeed(dimension), dimension);
            this.worldGenManagers.put(dimension, result);
        }
        return result;
    }

    public DimensionManager(Configuration config) {
        this.dimensionSpecificSeeds = config.get("general", "DimensionSpecificSeeds", false, "Use different seeds in different dimensions").getBoolean(false);
        this.inChunkGeneration = config.get("general", "InChunkGeneration", true, "Change stones during chunk generation").getBoolean(true);
        this.excludeDimensions = new Consumable<String>(config.get("general", "excludeDimensionIDs", "-1,1", "Comma-separated list of dimension IDs, used only if include list is *").getString());
        this.includeDimensions = new Consumable<String>(config.get("general", "includeDimensionIDs", "*", "Comma-separated list of dimension IDs, put * to use exclude list").getString());
        this.includeDimensionIDs = new DimensionSet.Include(this.includeDimensions.use());
        this.excludeDimensionIDs = new DimensionSet.Exclude(this.excludeDimensions.use());
        this.inChunkGenerationExclude = new Consumable<String>(config.get("general", "inChunkDimensionExclusions", "-1,1", "Comma-separated list of dimension to only use old decoration-phase generation, used only if inclusion list is *").getString());
        this.inChunkGenerationInclude = new Consumable<String>(config.get("general", "inChunkDimensionInclusions", "0", "Comma-separated list of dimension IDs to allow new chunk-phase decoration, put * to use exclusion list").getString());
        this.inChunkGenerationIncludeIDs = new DimensionSet.Include(this.inChunkGenerationInclude.use());
        this.inChunkGenerationExcludeIDs = new DimensionSet.Exclude(this.inChunkGenerationExclude.use());
        UBAPIHook.ubAPIHook.dimensionalStrataColumnProvider = new StrataColumnProvider();
    }

    public void onBiomeDecorate(DecorateBiomeEvent.Post event) {
        int id = event.world.field_73011_w.field_76574_g;
        if (!this.includeDimensionIDs.isIncluded(id, this.excludeDimensionIDs)) {
            return;
        }
        WorldGenManager worldGen = this.worldGenManager(id);
        if (worldGen == null) {
            System.out.println("UndergroundBiomes warning: onBiomeDecorate before onWorldLoad! Ignoring.");
            return;
        }
        if (this.inChunkDimensionIDs.contains(id)) {
            worldGen.decorateIfNeeded(event);
        } else {
            worldGen.onBiomeDecorate(event);
        }
    }

    public void setupGenerators(WorldEvent.Load event) {
        try {
            MinecraftServer server = MinecraftServer.func_71276_C();
            if (server == null) {
                return;
            }
            if (this.serverAdjusted) {
                return;
            }
            WorldServer[] serverList = server.field_71305_c;
            for (int i = 0; i < serverList.length; ++i) {
                if (serverList[i] == null) continue;
                int id = serverList[i].field_73011_w.field_76574_g;
                WorldGenManager worldGen = this.worldGenManager(id);
                if (!this.includeDimensionIDs.isIncluded(id, this.excludeDimensionIDs)) continue;
                serverList[i].func_82736_K().func_82764_b("mobGriefing", "false");
                if (!this.inChunkGeneration()) {
                    return;
                }
                if (!this.inChunkGenerationIncludeIDs.isIncluded(id, this.inChunkGenerationExcludeIDs)) continue;
                serverList[i].field_73011_w.field_76578_c.func_76938_b();
                worldGen.setChunkProvider((World)serverList[i]);
                worldGen.setServedChunkProvider(serverList[i]);
                this.inChunkDimensionIDs.add(id);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.serverAdjusted = true;
    }

    public void unload() {
        this.inChunkDimensionIDs = new ArrayList<Integer>();
        this.serverAdjusted = false;
        this.worldGenManagers = new HashMap<Integer, WorldGenManager>();
    }

    public boolean inChunkGenerationAllowed(int id) {
        if (!this.inChunkGeneration()) {
            return false;
        }
        if (!this.includeDimensionIDs.isIncluded(id, this.excludeDimensionIDs)) {
            return false;
        }
        return this.inChunkGenerationIncludeIDs.isIncluded(id, this.inChunkGenerationExcludeIDs);
    }

    @SubscribeEvent
    public void preBiomeDecorate(DecorateBiomeEvent.Pre event) {
        int id = event.world.field_73011_w.field_76574_g;
        this.villageWorldGenManager = this.worldGenManager(id);
        if (UndergroundBiomes.instance().gotWorldSeed() && UndergroundBiomes.replaceCobblestone) {
            this.villageWorldGenManager.preBiomeDecorate(event);
        }
    }

    @SubscribeEvent
    public void onVillageSelectBlock(BiomeEvent.GetVillageBlockID e) {
        if (UndergroundBiomes.instance().gotWorldSeed()) {
            this.villageWorldGenManager.onVillageSelectBlock(e);
        }
    }

    @SubscribeEvent
    public void onVillageSelectMeta(BiomeEvent.GetVillageBlockMeta e) {
        if (UndergroundBiomes.instance().gotWorldSeed()) {
            this.villageWorldGenManager.onVillageSelectMeta(e);
        }
    }

    private class StrataColumnProvider
    implements UBDimensionalStrataColumnProvider {
        private StrataColumnProvider() {
        }

        @Override
        public UBStrataColumnProvider ubStrataColumnProvider(int dimension) {
            return new UBBlockProvider(DimensionManager.this.worldGenManager(dimension));
        }
    }
}

