/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.asm;

import codechicken.lib.asm.ObfMapping;
import com.google.common.base.Throwables;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NameHelper {
    private static Pattern mDescPattern;
    private static Method mGetFieldMap;
    private static Method mGetMethodMap;

    public static ObfMapping getMapping(String className) {
        if (ObfMapping.obfuscated) {
            String newName = FMLDeobfuscatingRemapper.INSTANCE.unmap(className);
            if (newName.equals(className)) {
                return new ObfMapping("");
            }
            return new ObfMapping(newName);
        }
        return new ObfMapping(className);
    }

    private static String mapDescription(String desc) {
        if (mDescPattern == null) {
            mDescPattern = Pattern.compile("L([\\w\\$\\<\\>_\\/]+);");
        }
        Matcher match = mDescPattern.matcher(desc);
        StringBuffer result = new StringBuffer();
        while (match.find()) {
            String mapped = FMLDeobfuscatingRemapper.INSTANCE.unmap(match.group(1));
            match.appendReplacement(result, "L" + mapped + ";");
        }
        match.appendTail(result);
        return result.toString();
    }

    private static String unmapName(String name, String owner, String desc) {
        Map map;
        if (mGetFieldMap == null) {
            try {
                mGetFieldMap = FMLDeobfuscatingRemapper.class.getDeclaredMethod("getFieldMap", String.class);
                mGetFieldMap.setAccessible(true);
                mGetMethodMap = FMLDeobfuscatingRemapper.class.getDeclaredMethod("getMethodMap", String.class);
                mGetMethodMap.setAccessible(true);
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        boolean method = false;
        try {
            if (desc.contains("(")) {
                map = (Map)mGetMethodMap.invoke((Object)FMLDeobfuscatingRemapper.INSTANCE, owner);
                method = true;
            } else {
                map = (Map)mGetFieldMap.invoke((Object)FMLDeobfuscatingRemapper.INSTANCE, owner);
            }
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e);
            throw new RuntimeException(e);
        }
        if (map == null) {
            System.out.println("No mapping for " + name);
            return name;
        }
        for (Map.Entry ent : map.entrySet()) {
            if (!((String)ent.getValue()).equals(name)) continue;
            if (method) {
                return ((String)ent.getKey()).substring(0, ((String)ent.getKey()).indexOf(40));
            }
            return ((String)ent.getKey()).split(":")[0];
        }
        return name;
    }

    public static ObfMapping getMapping(String owner, String name, String desc) {
        if (ObfMapping.obfuscated) {
            owner = FMLDeobfuscatingRemapper.INSTANCE.unmap(owner);
            desc = NameHelper.mapDescription(desc);
            return new ObfMapping(owner, NameHelper.unmapName(name, owner, desc), desc);
        }
        return new ObfMapping(owner, name, desc);
    }
}

