/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.api;

import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import schmoller.tubes.api.BlockInstance;
import schmoller.tubes.api.HandlerRegistry;
import schmoller.tubes.api.Payload;
import schmoller.tubes.api.PayloadRegistry;
import schmoller.tubes.api.Position;
import schmoller.tubes.api.ProviderRegistry;
import schmoller.tubes.api.interfaces.IPayloadHandler;
import schmoller.tubes.inventory.AnyHandler;

public class InteractionHandler {
    public static boolean isInteractable(IBlockAccess world, int x, int y, int z, int side) {
        IPayloadHandler handler = InteractionHandler.getHandler(null, world, x, y, z);
        if (handler == null) {
            return false;
        }
        return handler.isSideAccessable(side ^ 1);
    }

    private static IPayloadHandler buildMultiHandler(IBlockAccess world, int x, int y, int z) {
        ArrayList<IPayloadHandler> handlers = new ArrayList<IPayloadHandler>();
        for (Class<? extends Payload> payloadClass : PayloadRegistry.instance().getPayloadTypes()) {
            IPayloadHandler handler = InteractionHandler.getHandler(payloadClass, world, x, y, z);
            if (handler == null) continue;
            handlers.add(handler);
        }
        return new AnyHandler(handlers);
    }

    public static IPayloadHandler getHandler(Class<? extends Payload> payloadClass, IBlockAccess world, Position position) {
        return InteractionHandler.getHandler(payloadClass, world, position.x, position.y, position.z);
    }

    public static IPayloadHandler getHandler(Class<? extends Payload> payloadClass, IBlockAccess world, int x, int y, int z) {
        TMultiPart part;
        BlockInstance object;
        Object interfaceObject;
        if (payloadClass == null) {
            return InteractionHandler.buildMultiHandler(world, x, y, z);
        }
        Block block = world.func_147439_a(x, y, z);
        Class<?> interfaceClass = PayloadRegistry.instance().getPayload(payloadClass).interfaceClass;
        if (block != null && (interfaceObject = ProviderRegistry.provideFor(interfaceClass, object = new BlockInstance(world, x, y, z))) != null) {
            return HandlerRegistry.getHandler(payloadClass, interfaceObject);
        }
        TileEntity ent = world.func_147438_o(x, y, z);
        interfaceObject = ProviderRegistry.provideFor(interfaceClass, ent);
        if (interfaceObject != null) {
            return HandlerRegistry.getHandler(payloadClass, interfaceObject);
        }
        if (ent instanceof TileMultipart && (part = ((TileMultipart)ent).partMap(6)) != null && (interfaceObject = ProviderRegistry.provideFor(interfaceClass, part)) != null) {
            return HandlerRegistry.getHandler(payloadClass, interfaceObject);
        }
        if (interfaceClass.isInstance(ent)) {
            return HandlerRegistry.getHandler(payloadClass, ent);
        }
        return null;
    }
}

