/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.api;

import com.google.common.base.Throwables;
import java.lang.reflect.Constructor;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraftforge.fluids.IFluidHandler;
import schmoller.tubes.api.FluidPayload;
import schmoller.tubes.api.ItemPayload;
import schmoller.tubes.api.Payload;
import schmoller.tubes.api.interfaces.IPayloadHandler;
import schmoller.tubes.inventory.BasicFluidHandler;
import schmoller.tubes.inventory.BasicInvHandler;
import schmoller.tubes.inventory.SidedInvHandler;

public class HandlerRegistry {
    private static HashMap<Class<? extends Payload>, HashMap<Class<?>, Constructor<? extends IPayloadHandler>>> mHandlers = new HashMap();

    public static void registerHandler(Class<? extends Payload> payloadClass, Class<?> handledClass, Class<? extends IPayloadHandler> handlerClass) {
        HashMap<Class<Object>, Constructor<IPayloadHandler<Object>>> map = mHandlers.get(payloadClass);
        if (map == null) {
            map = new HashMap();
            mHandlers.put(payloadClass, map);
        }
        try {
            Constructor<? extends IPayloadHandler> constructor = handlerClass.getConstructor(handledClass);
            map.put(handledClass, constructor);
        }
        catch (Exception e) {
            System.out.println("Failed to register inventory handler '" + handlerClass.getName() + "' for '" + handledClass.getName() + "'");
            e.printStackTrace();
        }
    }

    private static int getDistance(Class<?> from, Class<?> to) {
        ArrayDeque toSearch = new ArrayDeque();
        toSearch.add(new AbstractMap.SimpleEntry(from, 0));
        while (!toSearch.isEmpty()) {
            Map.Entry entry = (Map.Entry)toSearch.poll();
            int dist = (Integer)entry.getValue();
            if (((Class)entry.getKey()).equals(to)) {
                return dist;
            }
            for (Class<?> clazz : ((Class)entry.getKey()).getInterfaces()) {
                if (clazz.equals(to)) {
                    return dist;
                }
                toSearch.add(new AbstractMap.SimpleEntry(clazz, dist + 1));
            }
            if (((Class)entry.getKey()).getSuperclass() == null || ((Class)entry.getKey()).getSuperclass().equals(Object.class)) continue;
            toSearch.add(new AbstractMap.SimpleEntry(((Class)entry.getKey()).getSuperclass(), dist + 1));
        }
        return -1;
    }

    public static IPayloadHandler<?> getHandler(Class<? extends Payload> payloadType, Object object) {
        HashMap<Class<?>, Constructor<IPayloadHandler>> handlers = mHandlers.get(payloadType);
        if (handlers == null) {
            return null;
        }
        int minDist = Integer.MAX_VALUE;
        Constructor<? extends IPayloadHandler> min = null;
        for (Map.Entry<Class<?>, Constructor<IPayloadHandler>> entry : handlers.entrySet()) {
            int dist = HandlerRegistry.getDistance(object.getClass(), entry.getKey());
            if (dist == -1 || dist >= minDist) continue;
            minDist = dist;
            min = entry.getValue();
        }
        if (min != null) {
            try {
                return (IPayloadHandler)min.newInstance(object);
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    static {
        HandlerRegistry.registerHandler(ItemPayload.class, IInventory.class, BasicInvHandler.class);
        HandlerRegistry.registerHandler(ItemPayload.class, ISidedInventory.class, SidedInvHandler.class);
        HandlerRegistry.registerHandler(FluidPayload.class, IFluidHandler.class, BasicFluidHandler.class);
    }
}

