/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class CompoundList<E>
implements List<E> {
    private List<E> mA;
    private List<E> mB;

    public CompoundList(List<E> a, List<E> b) {
        this.mA = a;
        this.mB = b;
    }

    @Override
    public int size() {
        return this.mA.size() + this.mB.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mA.isEmpty() && this.mB.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.mA.contains(o) || this.mB.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E get(int index) {
        if (index < this.mA.size()) {
            return this.mA.get(index);
        }
        return this.mB.get(index);
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        int index = this.mA.indexOf(o);
        if (index != -1) {
            return index;
        }
        index = this.mB.indexOf(o);
        if (index != -1) {
            return index + this.mA.size();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int index = this.mA.lastIndexOf(o);
        if (index != -1) {
            return index;
        }
        index = this.mB.lastIndexOf(o);
        if (index != -1) {
            return index + this.mA.size();
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new CompoundIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    private class CompoundIterator
    implements ListIterator<E> {
        private ListIterator<E> mItA;
        private ListIterator<E> mItB;
        private int mIndex;

        public CompoundIterator(int index) {
            this.mIndex = index;
            if (this.mIndex < CompoundList.this.mA.size()) {
                this.mItA = CompoundList.this.mA.listIterator(index);
            } else {
                this.mItB = CompoundList.this.mB.listIterator(index - CompoundList.this.mA.size());
            }
        }

        @Override
        public boolean hasNext() {
            return this.mIndex < CompoundList.this.size();
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object returned = null;
            int last = this.mIndex;
            returned = this.mIndex < CompoundList.this.mA.size() ? (Object)this.mItA.next() : (Object)this.mItB.next();
            ++this.mIndex;
            if (last < CompoundList.this.mA.size() && this.mIndex >= CompoundList.this.mA.size()) {
                this.mItB = CompoundList.this.mB.listIterator(this.mIndex - CompoundList.this.mA.size());
            }
            return returned;
        }

        @Override
        public boolean hasPrevious() {
            return this.mIndex > 0;
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            Object returned = null;
            int last = this.mIndex;
            returned = this.mIndex < CompoundList.this.mA.size() ? (Object)this.mItA.previous() : (Object)this.mItB.previous();
            --this.mIndex;
            if (last >= CompoundList.this.mA.size() && this.mIndex < CompoundList.this.mA.size()) {
                this.mItA = CompoundList.this.mA.listIterator(this.mIndex);
            }
            return returned;
        }

        @Override
        public int nextIndex() {
            return this.mIndex;
        }

        @Override
        public int previousIndex() {
            return this.mIndex - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }
}

