/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes;

import codechicken.microblock.BlockMicroMaterial;
import codechicken.microblock.MicroMaterialRegistry;
import codechicken.microblock.handler.MicroblockProxy;
import codechicken.multipart.MultiPartRegistry;
import codechicken.multipart.TMultiPart;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import schmoller.tubes.ModTubes;
import schmoller.tubes.SpecialShapedRecipe;
import schmoller.tubes.SpecialShapelessRecipe;
import schmoller.tubes.api.Blocks;
import schmoller.tubes.api.FluidPayload;
import schmoller.tubes.api.ItemPayload;
import schmoller.tubes.api.Items;
import schmoller.tubes.api.PayloadRegistry;
import schmoller.tubes.api.TubeRegistry;
import schmoller.tubes.api.TubesAPI;
import schmoller.tubes.api.gui.ExtContainer;
import schmoller.tubes.api.gui.FakeSlot;
import schmoller.tubes.api.helpers.CommonHelper;
import schmoller.tubes.api.interfaces.ITube;
import schmoller.tubes.definitions.TypeBufferTube;
import schmoller.tubes.definitions.TypeColoringTube;
import schmoller.tubes.definitions.TypeCompressorTube;
import schmoller.tubes.definitions.TypeEjectionTube;
import schmoller.tubes.definitions.TypeExtractionTube;
import schmoller.tubes.definitions.TypeFilterTube;
import schmoller.tubes.definitions.TypeFluidExtractionTube;
import schmoller.tubes.definitions.TypeInjectionTube;
import schmoller.tubes.definitions.TypeNormalTube;
import schmoller.tubes.definitions.TypeRequestingTube;
import schmoller.tubes.definitions.TypeRestrictionTube;
import schmoller.tubes.definitions.TypeRoutingTube;
import schmoller.tubes.definitions.TypeTankTube;
import schmoller.tubes.definitions.TypeValveTube;
import schmoller.tubes.gui.BufferTubeContainer;
import schmoller.tubes.gui.CompressorContainer;
import schmoller.tubes.gui.FilterTubeContainer;
import schmoller.tubes.gui.InjectionTubeContainer;
import schmoller.tubes.gui.RequestingTubeContainer;
import schmoller.tubes.gui.RoutingTubeContainer;
import schmoller.tubes.items.BasicBlock;
import schmoller.tubes.items.BasicItem;
import schmoller.tubes.items.ItemTubeBase;
import schmoller.tubes.items.ItemTubeCap;
import schmoller.tubes.network.IModPacketHandler;
import schmoller.tubes.network.ModBlockPacket;
import schmoller.tubes.network.ModPacket;
import schmoller.tubes.network.packets.ModPacketNEIDragDrop;
import schmoller.tubes.network.packets.ModPacketSetColor;
import schmoller.tubes.network.packets.ModPacketSetFilterMode;
import schmoller.tubes.network.packets.ModPacketSetRequestingModes;
import schmoller.tubes.network.packets.ModPacketSetRoutingOptions;
import schmoller.tubes.parts.TubeCap;
import schmoller.tubes.types.BufferTube;
import schmoller.tubes.types.CompressorTube;
import schmoller.tubes.types.FilterTube;
import schmoller.tubes.types.InjectionTube;
import schmoller.tubes.types.RequestingTube;
import schmoller.tubes.types.RoutingTube;

public class CommonProxy
implements IModPacketHandler,
IGuiHandler,
MultiPartRegistry.IPartFactory {
    public void initialize() {
        this.registerTubes();
        this.registerItems();
        this.registerRecipes();
        OreDictionary.registerOre((String)"dustPlastic", (Item)Items.PlasticDust.getItem());
        OreDictionary.registerOre((String)"sheetPlastic", (Item)Items.PlasticSheet.getItem());
        OreDictionary.registerOre((String)"blockPlastic", (Block)Blocks.BlockPlastic.getBlock());
        MicroMaterialRegistry.registerMaterial((MicroMaterialRegistry.IMicroMaterial)new BlockMicroMaterial(Blocks.BlockPlastic.getBlock(), 0), (String)"tile.tubes.blockPlastic");
        FMLInterModComms.sendMessage((String)"BuildCraft|Transport", (String)"add-facade", (String)String.format("%s@%d", Blocks.BlockPlastic.getBlock().func_149739_a(), 0));
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)ModTubes.instance, (IGuiHandler)this);
        MultiPartRegistry.registerParts((MultiPartRegistry.IPartFactory)this, (String[])new String[]{"tubeCap"});
    }

    private void registerTubes() {
        TubeRegistry.registerTube(new TypeNormalTube(), "basic");
        TubeRegistry.registerTube(new TypeRestrictionTube(), "restriction");
        TubeRegistry.registerTube(new TypeInjectionTube(), "injection");
        TubeRegistry.registerTube(new TypeEjectionTube(), "ejection");
        TubeRegistry.registerTube(new TypeFilterTube(), "filter");
        TubeRegistry.registerTube(new TypeCompressorTube(), "compressor");
        TubeRegistry.registerTube(new TypeExtractionTube(), "extraction");
        TubeRegistry.registerTube(new TypeRequestingTube(), "requesting");
        TubeRegistry.registerTube(new TypeRoutingTube(), "routing");
        TubeRegistry.registerTube(new TypeValveTube(), "valve");
        TubeRegistry.registerTube(new TypeColoringTube(), "coloring");
        TubeRegistry.registerTube(new TypeFluidExtractionTube(), "fluidExtraction");
        TubeRegistry.registerTube(new TypeTankTube(), "tank");
        TubeRegistry.registerTube(new TypeBufferTube(), "buffer");
        PayloadRegistry.registerPayload(ItemPayload.class, "item", IInventory.class);
        PayloadRegistry.registerPayload(FluidPayload.class, "fluid", IFluidHandler.class);
    }

    private void registerItems() {
        Items.PlasticDust.initialize(new BasicItem().func_77655_b("plasticPellets"));
        Items.PlasticSheet.initialize(new BasicItem().func_77655_b("sheetPlastic"));
        Items.BucketMilkCurd.initialize(new BasicItem().func_77655_b("milkCurd").func_77642_a(net.minecraft.init.Items.field_151133_ar).func_77637_a((CreativeTabs)ModTubes.creativeTab).func_77625_d(1));
        Items.BucketPlastic.initialize(new BasicItem().func_77655_b("bucketOfPlastic").func_77642_a(net.minecraft.init.Items.field_151133_ar).func_77637_a((CreativeTabs)ModTubes.creativeTab).func_77625_d(1));
        Items.RedstoneCircuit.initialize(new BasicItem().func_77655_b("redstoneCircuit").func_77637_a((CreativeTabs)ModTubes.creativeTab));
        Items.FluidCircuit.initialize(new BasicItem().func_77655_b("fluidCircuit").func_77637_a((CreativeTabs)ModTubes.creativeTab));
        ModTubes.itemTube = new ItemTubeBase();
        Items.Tube.initialize((Item)ModTubes.itemTube);
        GameRegistry.registerItem((Item)Items.PlasticDust.getItem(), (String)"dustPlastic");
        GameRegistry.registerItem((Item)Items.PlasticSheet.getItem(), (String)"sheetPlastic");
        GameRegistry.registerItem((Item)Items.BucketMilkCurd.getItem(), (String)"milkCurd");
        GameRegistry.registerItem((Item)Items.BucketPlastic.getItem(), (String)"bucketOfPlastic");
        GameRegistry.registerItem((Item)Items.Tube.getItem(), (String)"tube");
        GameRegistry.registerItem((Item)Items.RedstoneCircuit.getItem(), (String)"redstoneCircuit");
        GameRegistry.registerItem((Item)Items.FluidCircuit.getItem(), (String)"fluidCircuit");
        Items.TubeCap.initialize(new ItemTubeCap().func_77655_b("tubeCap").func_77637_a((CreativeTabs)ModTubes.creativeTab));
        GameRegistry.registerItem((Item)Items.TubeCap.getItem(), (String)"tubeCap");
        Blocks.BlockPlastic.initialize(new BasicBlock(Material.field_76233_E).func_149647_a(ModTubes.creativeTab).func_149663_c("blockPlastic").func_149658_d("tubes:blockPlastic").func_149711_c(2.5f));
        Blocks.BlockPlastic.getBlock().setHarvestLevel("pickaxe", 0);
        Blocks.BlockPlastic.getBlock().setHarvestLevel("axe", 0);
        GameRegistry.registerBlock((Block)Blocks.BlockPlastic.getBlock(), (String)"blockPlastic");
        ModTubes.fluidPlastic = new Fluid("plastic").setDensity(800).setViscosity(1500);
        FluidRegistry.registerFluid((Fluid)ModTubes.fluidPlastic);
        ModTubes.fluidPlastic = FluidRegistry.getFluid((String)"plastic");
        FluidContainerRegistry.registerFluidContainer((FluidStack)FluidRegistry.getFluidStack((String)"plastic", (int)1000), (ItemStack)new ItemStack(Items.BucketPlastic.getItem()), (ItemStack)new ItemStack(net.minecraft.init.Items.field_151133_ar));
    }

    private void registerRecipes() {
        RecipeSorter.register((String)"tubes:shapeless", SpecialShapelessRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"before:minecraft:shapeless");
        RecipeSorter.register((String)"tubes:shaped", SpecialShapedRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"before:tubes:shapeless");
        GameRegistry.addSmelting((Item)Items.PlasticDust.getItem(), (ItemStack)new ItemStack(Items.PlasticSheet.getItem()), (float)0.0f);
        GameRegistry.addSmelting((Item)net.minecraft.init.Items.field_151117_aB, (ItemStack)new ItemStack(Items.BucketMilkCurd.getItem()), (float)0.0f);
        GameRegistry.addRecipe((IRecipe)new SpecialShapelessRecipe(new ItemStack(Items.PlasticDust.getItem(), ModTubes.instance.plasticYield * 4), Items.BucketMilkCurd.getItem(), new ItemStack(net.minecraft.init.Items.field_151044_h, 1, Short.MAX_VALUE), net.minecraft.init.Items.field_151016_H, FluidRegistry.getFluid((String)"water")));
        GameRegistry.addRecipe((IRecipe)new SpecialShapelessRecipe(new ItemStack(Items.PlasticDust.getItem(), ModTubes.instance.plasticYield * 4), Items.BucketPlastic.getItem(), new ItemStack(net.minecraft.init.Items.field_151044_h, 1, Short.MAX_VALUE)));
        GameRegistry.addRecipe((IRecipe)new SpecialShapedRecipe(new ItemStack(Items.PlasticDust.getItem(), ModTubes.instance.plasticYield), " c ", "sCs", " c ", Character.valueOf('c'), new ItemStack(net.minecraft.init.Items.field_151044_h, 1, Short.MAX_VALUE), Character.valueOf('C'), net.minecraft.init.Items.field_151119_aD, Character.valueOf('s'), net.minecraft.init.Blocks.field_150354_m));
        GameRegistry.addRecipe((IRecipe)new SpecialShapedRecipe(ModTubes.itemTube.createForType("basic", 8), "pgp", Character.valueOf('p'), "sheetPlastic", Character.valueOf('g'), net.minecraft.init.Blocks.field_150359_w));
        GameRegistry.addRecipe((IRecipe)new SpecialShapedRecipe(new ItemStack(Blocks.BlockPlastic.getBlock()), "pp", "pp", Character.valueOf('p'), "sheetPlastic"));
        GameRegistry.addRecipe((IRecipe)new SpecialShapelessRecipe(ModTubes.itemTube.createForType("restriction"), ModTubes.itemTube.createForType("basic"), net.minecraft.init.Items.field_151042_j));
        GameRegistry.addRecipe((IRecipe)new SpecialShapedRecipe(ModTubes.itemTube.createForType("compressor"), "ipi", "ptp", "ipi", Character.valueOf('i'), net.minecraft.init.Items.field_151042_j, Character.valueOf('p'), net.minecraft.init.Blocks.field_150331_J, Character.valueOf('t'), ModTubes.itemTube.createForType("basic")));
        GameRegistry.addRecipe((IRecipe)new SpecialShapedRecipe(ModTubes.itemTube.createForType("injection"), " w ", "wtw", " w ", Character.valueOf('w'), "plankWood", Character.valueOf('t'), ModTubes.itemTube.createForType("basic")));
        GameRegistry.addRecipe((IRecipe)new SpecialShapedRecipe(ModTubes.itemTube.createForType("extraction"), "h", "t", "p", Character.valueOf('t'), ModTubes.itemTube.createForType("basic"), Character.valueOf('h'), net.minecraft.init.Blocks.field_150438_bZ, Character.valueOf('p'), net.minecraft.init.Blocks.field_150320_F));
        GameRegistry.addRecipe((IRecipe)new SpecialShapedRecipe(ModTubes.itemTube.createForType("requesting"), "t", "e", "f", Character.valueOf('t'), ModTubes.itemTube.createForType("basic"), Character.valueOf('e'), ModTubes.itemTube.createForType("extraction"), Character.valueOf('f'), ModTubes.itemTube.createForType("filter")));
        GameRegistry.addRecipe((IRecipe)new SpecialShapedRecipe(ModTubes.itemTube.createForType("filter"), "ici", "ctc", "ici", Character.valueOf('i'), net.minecraft.init.Items.field_151042_j, Character.valueOf('t'), ModTubes.itemTube.createForType("basic"), Character.valueOf('c'), Items.RedstoneCircuit.getItem()));
        GameRegistry.addRecipe((IRecipe)new SpecialShapedRecipe(ModTubes.itemTube.createForType("routing"), "iti", "tft", "iti", Character.valueOf('i'), net.minecraft.init.Items.field_151042_j, Character.valueOf('t'), ModTubes.itemTube.createForType("basic"), Character.valueOf('f'), ModTubes.itemTube.createForType("filter")));
        GameRegistry.addRecipe((IRecipe)new SpecialShapelessRecipe(ModTubes.itemTube.createForType("ejection"), ModTubes.itemTube.createForType("basic"), net.minecraft.init.Blocks.field_150359_w));
        GameRegistry.addRecipe((IRecipe)new SpecialShapedRecipe(ModTubes.itemTube.createForType("fluidExtraction"), "f", "t", "f", Character.valueOf('f'), Items.FluidCircuit.getItem(), Character.valueOf('t'), ModTubes.itemTube.createForType("extraction")));
        TubesAPI.instance.registerShapelessRecipe(ModTubes.itemTube.createForType("valve"), ModTubes.itemTube.createForType("basic"), net.minecraft.init.Items.field_151042_j, net.minecraft.init.Blocks.field_150442_at);
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Items.RedstoneCircuit.getItem(), 4), (Object[])new Object[]{"igi", "rrr", "igi", Character.valueOf('i'), net.minecraft.init.Items.field_151042_j, Character.valueOf('g'), net.minecraft.init.Items.field_151043_k, Character.valueOf('r'), net.minecraft.init.Items.field_151137_ax});
        TubesAPI.instance.registerShapelessRecipe(new ItemStack(Items.TubeCap.getItem(), 2, 0), TubesAPI.instance.createTubeForType("basic"), MicroblockProxy.sawStone());
        TubesAPI.instance.registerShapelessRecipe(new ItemStack(Items.FluidCircuit.getItem(), 1, 0), new ItemStack(Items.RedstoneCircuit.getItem(), 1, 0), net.minecraft.init.Items.field_151133_ar);
        TubesAPI.instance.registerShapedRecipe(TubesAPI.instance.createTubeForType("tank", 1), " g ", "gtg", " g ", Character.valueOf('g'), net.minecraft.init.Blocks.field_150359_w, Character.valueOf('t'), TubesAPI.instance.createTubeForType("basic"));
        TubesAPI.instance.registerShapedRecipe(TubesAPI.instance.createTubeForType("buffer", 1), "t", "c", "t", Character.valueOf('t'), TubesAPI.instance.createTubeForType("basic"), Character.valueOf('c'), net.minecraft.init.Blocks.field_150486_ae);
    }

    public void registerOreRecipes() {
        TubesAPI.instance.registerShapedRecipe(ModTubes.itemTube.createForType("coloring"), " d ", "dtd", " d ", Character.valueOf('d'), "Tubes$anyDye", Character.valueOf('t'), ModTubes.itemTube.createForType("basic"));
    }

    @Override
    public boolean onPacketArrive(ModPacket packet, EntityPlayer sender) {
        if (packet instanceof ModBlockPacket) {
            ITube tube = CommonHelper.getMultiPart((IBlockAccess)sender.field_70170_p, ((ModBlockPacket)packet).xCoord, ((ModBlockPacket)packet).yCoord, ((ModBlockPacket)packet).zCoord, ITube.class);
            if (packet instanceof ModPacketSetFilterMode && tube instanceof FilterTube) {
                ModPacketSetFilterMode mode = (ModPacketSetFilterMode)packet;
                FilterTube logic = (FilterTube)tube;
                if (mode.mode != null) {
                    logic.setMode(mode.mode);
                } else {
                    logic.setComparison(mode.comparison);
                }
                return true;
            }
            if (packet instanceof ModPacketSetRequestingModes && tube instanceof RequestingTube) {
                ModPacketSetRequestingModes mpacket = (ModPacketSetRequestingModes)packet;
                if (mpacket.mode != null) {
                    ((RequestingTube)tube).setMode(mpacket.mode);
                } else {
                    ((RequestingTube)tube).setSizeMode(mpacket.sizeMode);
                }
                return true;
            }
            if (packet instanceof ModPacketSetRoutingOptions && tube instanceof RoutingTube) {
                ModPacketSetRoutingOptions options = (ModPacketSetRoutingOptions)packet;
                RoutingTube logic = (RoutingTube)tube;
                if (options.hasColour) {
                    logic.setColour(options.column, options.colour);
                } else {
                    logic.setDirection(options.column, options.direction);
                }
                return true;
            }
            if (packet instanceof ModPacketSetColor) {
                int color = ((ModPacketSetColor)packet).color;
                if (tube instanceof RequestingTube) {
                    ((RequestingTube)tube).setColour((short)color);
                } else if (tube instanceof FilterTube) {
                    ((FilterTube)tube).setColour((short)color);
                }
            }
        } else if (packet instanceof ModPacketNEIDragDrop) {
            Slot slot;
            EntityPlayer player = sender;
            ModPacketNEIDragDrop drop = (ModPacketNEIDragDrop)packet;
            if (player.field_71070_bA instanceof ExtContainer && player.field_71070_bA.field_75152_c == drop.windowId && drop.slot >= 0 && drop.slot < player.field_71070_bA.field_75151_b.size() && (slot = (Slot)player.field_71070_bA.field_75151_b.get(drop.slot)) instanceof FakeSlot) {
                ((ExtContainer)player.field_71070_bA).dropItem(drop.slot, drop.button, drop.modifiers, drop.item);
            }
        }
        return false;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        switch (ID) {
            case 0: {
                return new InjectionTubeContainer(CommonHelper.getMultiPart((IBlockAccess)world, x, y, z, InjectionTube.class), player);
            }
            case 1: {
                return new FilterTubeContainer(CommonHelper.getMultiPart((IBlockAccess)world, x, y, z, FilterTube.class), player);
            }
            case 2: {
                return new CompressorContainer(CommonHelper.getMultiPart((IBlockAccess)world, x, y, z, CompressorTube.class), player);
            }
            case 3: {
                return new RequestingTubeContainer(CommonHelper.getMultiPart((IBlockAccess)world, x, y, z, RequestingTube.class), player);
            }
            case 4: {
                return new RoutingTubeContainer(CommonHelper.getMultiPart((IBlockAccess)world, x, y, z, RoutingTube.class), player);
            }
            case 5: {
                return new BufferTubeContainer(player.field_71071_by, CommonHelper.getMultiPart((IBlockAccess)world, x, y, z, BufferTube.class));
            }
        }
        return null;
    }

    public TMultiPart createPart(String partType, boolean client) {
        if (partType.equals("tubeCap")) {
            return new TubeCap();
        }
        return null;
    }
}

