/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import schmoller.tubes.api.Payload;
import schmoller.tubes.api.SizeMode;
import schmoller.tubes.api.TubeItem;
import schmoller.tubes.api.helpers.RenderHelper;
import schmoller.tubes.api.interfaces.IFilter;

public class AnyFilter
implements IFilter {
    public static ResourceLocation texture = new ResourceLocation("tubes", "textures/gui/anyFilter.png");
    private int mMax;
    private int mValue;

    public AnyFilter(int value) {
        this(value, 64);
    }

    public AnyFilter(int value, int max) {
        assert (max > 0);
        this.mValue = value;
        this.mMax = max;
    }

    @Override
    public String getType() {
        return "any";
    }

    @Override
    public Class<? extends Payload> getPayloadType() {
        return null;
    }

    @Override
    public boolean matches(Payload payload, SizeMode mode) {
        if (this.mValue > payload.maxSize() && payload.size() == payload.maxSize()) {
            return true;
        }
        switch (mode) {
            case Max: {
                return true;
            }
            case Exact: {
                return payload.size() == this.mValue;
            }
            case GreaterEqual: {
                return payload.size() >= this.mValue;
            }
            case LessEqual: {
                return payload.size() <= this.mValue;
            }
        }
        return true;
    }

    @Override
    public boolean matches(TubeItem item, SizeMode mode) {
        return this.matches(item.item, mode);
    }

    @Override
    public void increase(boolean useMax, boolean shift) {
        this.mValue += shift ? 10 : 1;
        if (this.mValue > this.mMax && useMax) {
            this.mValue = this.mMax;
        }
    }

    @Override
    public void decrease(boolean shift) {
        this.mValue -= shift ? 10 : 1;
        if (this.mValue < 0) {
            this.mValue = 0;
        }
    }

    @Override
    public int getMax() {
        return this.mMax;
    }

    @Override
    public int size() {
        return this.mValue;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderFilter(int x, int y) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        RenderHelper.renderRect(x, y, 16, 16, 0.0f, 0.0f, 1.0f, 1.0f);
        String text = String.valueOf(this.mValue);
        int fwidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 17 - fwidth), (double)(y + 9), (double)0.0);
        if (fwidth > 16) {
            GL11.glTranslatef((float)(fwidth / 2 - 1), (float)((float)Minecraft.func_71410_x().field_71466_p.field_78288_b / 2.0f - 1.0f), (float)0.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        }
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        Minecraft.func_71410_x().field_71466_p.func_78261_a(text, 0, 0, 0xFFFFFF);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    @Override
    public void write(NBTTagCompound tag) {
        tag.func_74768_a("val", this.mValue);
        tag.func_74768_a("max", this.mMax);
    }

    @Override
    public void write(MCDataOutput output) {
        output.writeShort(this.mValue);
        output.writeShort(this.mMax);
    }

    public static AnyFilter from(NBTTagCompound tag) {
        return new AnyFilter(tag.func_74762_e("val"), tag.func_74762_e("max"));
    }

    public static AnyFilter from(MCDataInput input) {
        return new AnyFilter(input.readShort(), input.readShort());
    }

    @Override
    public IFilter copy() {
        return new AnyFilter(this.mValue, this.mMax);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<String> getTooltip(List<String> current) {
        return Arrays.asList(StatCollector.func_74838_a((String)"gui.filter.any"));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AnyFilter)) {
            return false;
        }
        AnyFilter other = (AnyFilter)obj;
        return this.mValue == other.mValue && this.mMax == other.mMax;
    }
}

