/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

public class AdvRender {
    private Vector3f[] vertices = new Vector3f[8];
    private boolean mUseColor = false;
    private Vector3f[] mCornerColors = new Vector3f[8];
    private Matrix4f transform = new Matrix4f();
    private int[][] corners = new int[6][];
    private Tessellator tes;
    private Vector2f[][] textureCoords = new Vector2f[6][4];
    private int[] textureRotation = new int[6];
    private int[] textureFlip = new int[6];
    private int[] texIndex = new int[6];
    private IIcon[] texIcons = new IIcon[6];
    private int textureWidth = 16;
    private int textureHeight = 16;
    private boolean iconMode = false;
    private boolean mAbsoluteTexCoords = true;
    private Stack<Matrix4f> mStackTransforms = new Stack();
    public FaceMode faceMode = FaceMode.Normal;
    private boolean mEnableAO = false;
    private float[][] mCornerAO = new float[6][4];
    private float mInternalAO = 0.0f;
    private int[][] mFaceBrightness = new int[6][4];
    private int mInternalBrightness = 0;
    private float[] mLocalLighting = new float[6];
    private float opacity = 1.0f;
    public boolean enableNormals = false;
    public boolean enableLighting = true;

    public AdvRender() {
        this.transform.setIdentity();
        for (int i = 0; i < 8; ++i) {
            this.mCornerColors[i] = new Vector3f(1.0f, 1.0f, 1.0f);
        }
    }

    public void setIcon(IIcon icon) {
        this.iconMode = true;
        for (int i = 0; i < 6; ++i) {
            this.texIcons[i] = icon;
        }
    }

    public void setIcon(int side, IIcon icon) {
        this.iconMode = true;
        this.texIcons[side] = icon;
    }

    public void setIcon(IIcon down, IIcon up, IIcon north, IIcon south, IIcon west, IIcon east) {
        this.iconMode = true;
        this.texIcons[0] = down;
        this.texIcons[1] = up;
        this.texIcons[2] = north;
        this.texIcons[3] = south;
        this.texIcons[4] = west;
        this.texIcons[5] = east;
    }

    public void setTextureSize(int width, int height) {
        this.textureWidth = width;
        this.textureHeight = height;
    }

    public void setTextureIndex(int index) {
        this.iconMode = false;
        for (int i = 0; i < 6; ++i) {
            this.texIndex[i] = index;
        }
    }

    public void setTextureIndex(int side, int index) {
        this.iconMode = false;
        this.texIndex[side] = index;
    }

    public void setTextureIndex(int down, int up, int north, int south, int west, int east) {
        this.iconMode = false;
        this.texIndex[0] = down;
        this.texIndex[1] = up;
        this.texIndex[2] = north;
        this.texIndex[3] = south;
        this.texIndex[4] = west;
        this.texIndex[5] = east;
    }

    public void resetTextureFlip() {
        this.setTextureFlip(0);
    }

    public void setTextureFlip(int flip) {
        for (int i = 0; i < 6; ++i) {
            this.textureFlip[i] = flip;
        }
    }

    public void setTextureFlip(int side, int flip) {
        this.textureFlip[side] = flip;
    }

    public void setTextureFlip(int down, int up, int north, int south, int west, int east) {
        this.textureFlip[0] = down;
        this.textureFlip[1] = up;
        this.textureFlip[2] = north;
        this.textureFlip[3] = south;
        this.textureFlip[4] = west;
        this.textureFlip[5] = east;
    }

    public void resetTextureRotation() {
        this.setTextureRotation(0);
    }

    public void setTextureRotation(int rotation) {
        for (int i = 0; i < 6; ++i) {
            this.textureRotation[i] = rotation;
        }
    }

    public void setTextureRotation(int down, int up, int north, int south, int west, int east) {
        this.textureRotation[0] = down;
        this.textureRotation[1] = up;
        this.textureRotation[2] = north;
        this.textureRotation[3] = south;
        this.textureRotation[4] = west;
        this.textureRotation[5] = east;
    }

    public void setLocalLights(float down, float up, float north, float south, float west, float east) {
        this.mLocalLighting[0] = down;
        this.mLocalLighting[1] = up;
        this.mLocalLighting[2] = north;
        this.mLocalLighting[3] = south;
        this.mLocalLighting[4] = west;
        this.mLocalLighting[5] = east;
    }

    public void resetAO() {
        this.mEnableAO = false;
    }

    public void resetLighting(int brightness) {
        for (int side = 0; side < 6; ++side) {
            this.mFaceBrightness[side][0] = brightness;
            this.mFaceBrightness[side][1] = brightness;
            this.mFaceBrightness[side][2] = brightness;
            this.mFaceBrightness[side][3] = brightness;
        }
        this.mInternalBrightness = brightness;
        this.mInternalAO = 1.0f;
        this.opacity = 1.0f;
    }

    public void setOpacity(float value) {
        this.opacity = value;
    }

    private int getMixedBrightnessForBlock(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block != null) {
            return block.func_149677_c(world, x, y, z);
        }
        return world.func_72802_i(x, y, z, 0);
    }

    private float getAmbientOcclusionLightValue(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block != null) {
            return block.func_149685_I();
        }
        return 1.0f;
    }

    private int mixBrightness(int source1, int source2, int source3, int source4) {
        if (source1 == 0) {
            source1 = source4;
        }
        if (source2 == 0) {
            source2 = source4;
        }
        if (source3 == 0) {
            source3 = source4;
        }
        return source1 + source2 + source3 + source4 >> 2 & 0xFF00FF;
    }

    public void setLightingFromBlock(IBlockAccess world, int x, int y, int z) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.setFaceLightingFromWorld(dir.ordinal(), world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        }
        this.mInternalBrightness = this.getMixedBrightnessForBlock(world, x, y, z);
        this.mInternalAO = this.getAmbientOcclusionLightValue(world, x, y, z);
    }

    public void setFaceLightingFromWorld(int side, IBlockAccess world, int x, int y, int z) {
        FMLClientHandler.instance().getClient();
        if (!Minecraft.func_71379_u()) {
            int lightVal;
            this.mFaceBrightness[side][0] = lightVal = this.getMixedBrightnessForBlock(world, x, y, z);
            this.mFaceBrightness[side][1] = lightVal;
            this.mFaceBrightness[side][2] = lightVal;
            this.mFaceBrightness[side][3] = lightVal;
        } else {
            int[] brightness = new int[8];
            float[] ao = new float[8];
            int myBrightness = this.getMixedBrightnessForBlock(world, x, y, z);
            float myAO = this.getAmbientOcclusionLightValue(world, x, y, z);
            switch (side) {
                case 0: {
                    brightness[0] = this.getMixedBrightnessForBlock(world, x - 1, y, z);
                    brightness[1] = this.getMixedBrightnessForBlock(world, x - 1, y, z - 1);
                    brightness[2] = this.getMixedBrightnessForBlock(world, x, y, z - 1);
                    brightness[3] = this.getMixedBrightnessForBlock(world, x + 1, y, z - 1);
                    brightness[4] = this.getMixedBrightnessForBlock(world, x + 1, y, z);
                    brightness[5] = this.getMixedBrightnessForBlock(world, x + 1, y, z + 1);
                    brightness[6] = this.getMixedBrightnessForBlock(world, x, y, z + 1);
                    brightness[7] = this.getMixedBrightnessForBlock(world, x - 1, y, z + 1);
                    ao[0] = this.getAmbientOcclusionLightValue(world, x - 1, y, z);
                    ao[1] = this.getAmbientOcclusionLightValue(world, x - 1, y, z - 1);
                    ao[2] = this.getAmbientOcclusionLightValue(world, x, y, z - 1);
                    ao[3] = this.getAmbientOcclusionLightValue(world, x + 1, y, z - 1);
                    ao[4] = this.getAmbientOcclusionLightValue(world, x + 1, y, z);
                    ao[5] = this.getAmbientOcclusionLightValue(world, x + 1, y, z + 1);
                    ao[6] = this.getAmbientOcclusionLightValue(world, x, y, z + 1);
                    ao[7] = this.getAmbientOcclusionLightValue(world, x - 1, y, z + 1);
                    break;
                }
                case 1: {
                    brightness[0] = this.getMixedBrightnessForBlock(world, x - 1, y, z);
                    brightness[1] = this.getMixedBrightnessForBlock(world, x - 1, y, z + 1);
                    brightness[2] = this.getMixedBrightnessForBlock(world, x, y, z + 1);
                    brightness[3] = this.getMixedBrightnessForBlock(world, x + 1, y, z + 1);
                    brightness[4] = this.getMixedBrightnessForBlock(world, x + 1, y, z);
                    brightness[5] = this.getMixedBrightnessForBlock(world, x + 1, y, z - 1);
                    brightness[6] = this.getMixedBrightnessForBlock(world, x, y, z - 1);
                    brightness[7] = this.getMixedBrightnessForBlock(world, x - 1, y, z - 1);
                    ao[0] = this.getAmbientOcclusionLightValue(world, x - 1, y, z);
                    ao[1] = this.getAmbientOcclusionLightValue(world, x - 1, y, z + 1);
                    ao[2] = this.getAmbientOcclusionLightValue(world, x, y, z + 1);
                    ao[3] = this.getAmbientOcclusionLightValue(world, x + 1, y, z + 1);
                    ao[4] = this.getAmbientOcclusionLightValue(world, x + 1, y, z);
                    ao[5] = this.getAmbientOcclusionLightValue(world, x + 1, y, z - 1);
                    ao[6] = this.getAmbientOcclusionLightValue(world, x, y, z - 1);
                    ao[7] = this.getAmbientOcclusionLightValue(world, x - 1, y, z - 1);
                    break;
                }
                case 2: {
                    brightness[0] = this.getMixedBrightnessForBlock(world, x - 1, y, z);
                    brightness[1] = this.getMixedBrightnessForBlock(world, x - 1, y + 1, z);
                    brightness[2] = this.getMixedBrightnessForBlock(world, x, y + 1, z);
                    brightness[3] = this.getMixedBrightnessForBlock(world, x + 1, y + 1, z);
                    brightness[4] = this.getMixedBrightnessForBlock(world, x + 1, y, z);
                    brightness[5] = this.getMixedBrightnessForBlock(world, x + 1, y - 1, z);
                    brightness[6] = this.getMixedBrightnessForBlock(world, x, y - 1, z);
                    brightness[7] = this.getMixedBrightnessForBlock(world, x - 1, y - 1, z);
                    ao[0] = this.getAmbientOcclusionLightValue(world, x - 1, y, z);
                    ao[1] = this.getAmbientOcclusionLightValue(world, x - 1, y + 1, z);
                    ao[2] = this.getAmbientOcclusionLightValue(world, x, y + 1, z);
                    ao[3] = this.getAmbientOcclusionLightValue(world, x + 1, y + 1, z);
                    ao[4] = this.getAmbientOcclusionLightValue(world, x + 1, y, z);
                    ao[5] = this.getAmbientOcclusionLightValue(world, x + 1, y - 1, z);
                    ao[6] = this.getAmbientOcclusionLightValue(world, x, y - 1, z);
                    ao[7] = this.getAmbientOcclusionLightValue(world, x - 1, y - 1, z);
                    break;
                }
                case 3: {
                    brightness[0] = this.getMixedBrightnessForBlock(world, x + 1, y, z);
                    brightness[1] = this.getMixedBrightnessForBlock(world, x + 1, y + 1, z);
                    brightness[2] = this.getMixedBrightnessForBlock(world, x, y + 1, z);
                    brightness[3] = this.getMixedBrightnessForBlock(world, x - 1, y + 1, z);
                    brightness[4] = this.getMixedBrightnessForBlock(world, x - 1, y, z);
                    brightness[5] = this.getMixedBrightnessForBlock(world, x - 1, y - 1, z);
                    brightness[6] = this.getMixedBrightnessForBlock(world, x, y - 1, z);
                    brightness[7] = this.getMixedBrightnessForBlock(world, x + 1, y - 1, z);
                    ao[0] = this.getAmbientOcclusionLightValue(world, x + 1, y, z);
                    ao[1] = this.getAmbientOcclusionLightValue(world, x + 1, y + 1, z);
                    ao[2] = this.getAmbientOcclusionLightValue(world, x, y + 1, z);
                    ao[3] = this.getAmbientOcclusionLightValue(world, x - 1, y + 1, z);
                    ao[4] = this.getAmbientOcclusionLightValue(world, x - 1, y, z);
                    ao[5] = this.getAmbientOcclusionLightValue(world, x - 1, y - 1, z);
                    ao[6] = this.getAmbientOcclusionLightValue(world, x, y - 1, z);
                    ao[7] = this.getAmbientOcclusionLightValue(world, x + 1, y - 1, z);
                    break;
                }
                case 4: {
                    brightness[0] = this.getMixedBrightnessForBlock(world, x, y, z + 1);
                    brightness[1] = this.getMixedBrightnessForBlock(world, x, y + 1, z + 1);
                    brightness[2] = this.getMixedBrightnessForBlock(world, x, y + 1, z);
                    brightness[3] = this.getMixedBrightnessForBlock(world, x, y + 1, z - 1);
                    brightness[4] = this.getMixedBrightnessForBlock(world, x, y, z - 1);
                    brightness[5] = this.getMixedBrightnessForBlock(world, x, y - 1, z - 1);
                    brightness[6] = this.getMixedBrightnessForBlock(world, x, y - 1, z);
                    brightness[7] = this.getMixedBrightnessForBlock(world, x, y - 1, z + 1);
                    ao[0] = this.getAmbientOcclusionLightValue(world, x, y, z + 1);
                    ao[1] = this.getAmbientOcclusionLightValue(world, x, y + 1, z + 1);
                    ao[2] = this.getAmbientOcclusionLightValue(world, x, y + 1, z);
                    ao[3] = this.getAmbientOcclusionLightValue(world, x, y + 1, z - 1);
                    ao[4] = this.getAmbientOcclusionLightValue(world, x, y, z - 1);
                    ao[5] = this.getAmbientOcclusionLightValue(world, x, y - 1, z - 1);
                    ao[6] = this.getAmbientOcclusionLightValue(world, x, y - 1, z);
                    ao[7] = this.getAmbientOcclusionLightValue(world, x, y - 1, z + 1);
                    break;
                }
                case 5: {
                    brightness[0] = this.getMixedBrightnessForBlock(world, x, y, z - 1);
                    brightness[1] = this.getMixedBrightnessForBlock(world, x, y + 1, z - 1);
                    brightness[2] = this.getMixedBrightnessForBlock(world, x, y + 1, z);
                    brightness[3] = this.getMixedBrightnessForBlock(world, x, y + 1, z + 1);
                    brightness[4] = this.getMixedBrightnessForBlock(world, x, y, z + 1);
                    brightness[5] = this.getMixedBrightnessForBlock(world, x, y - 1, z + 1);
                    brightness[6] = this.getMixedBrightnessForBlock(world, x, y - 1, z);
                    brightness[7] = this.getMixedBrightnessForBlock(world, x, y - 1, z - 1);
                    ao[0] = this.getAmbientOcclusionLightValue(world, x, y, z - 1);
                    ao[1] = this.getAmbientOcclusionLightValue(world, x, y + 1, z - 1);
                    ao[2] = this.getAmbientOcclusionLightValue(world, x, y + 1, z);
                    ao[3] = this.getAmbientOcclusionLightValue(world, x, y + 1, z + 1);
                    ao[4] = this.getAmbientOcclusionLightValue(world, x, y, z + 1);
                    ao[5] = this.getAmbientOcclusionLightValue(world, x, y - 1, z + 1);
                    ao[6] = this.getAmbientOcclusionLightValue(world, x, y - 1, z);
                    ao[7] = this.getAmbientOcclusionLightValue(world, x, y - 1, z - 1);
                }
            }
            this.mFaceBrightness[side][0] = this.mixBrightness(brightness[0], brightness[1], brightness[2], myBrightness);
            this.mFaceBrightness[side][1] = this.mixBrightness(brightness[2], brightness[3], brightness[4], myBrightness);
            this.mFaceBrightness[side][2] = this.mixBrightness(brightness[4], brightness[5], brightness[6], myBrightness);
            this.mFaceBrightness[side][3] = this.mixBrightness(brightness[6], brightness[7], brightness[0], myBrightness);
            this.mCornerAO[side][0] = (ao[0] + ao[1] + ao[2] + myAO) / 4.0f;
            this.mCornerAO[side][1] = (ao[2] + ao[3] + ao[4] + myAO) / 4.0f;
            this.mCornerAO[side][2] = (ao[4] + ao[5] + ao[6] + myAO) / 4.0f;
            this.mCornerAO[side][3] = (ao[6] + ao[7] + ao[0] + myAO) / 4.0f;
            this.mEnableAO = true;
        }
    }

    public void resetColor() {
        this.mUseColor = false;
    }

    public void setColorRGB(int color) {
        this.mUseColor = true;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        for (int i = 0; i < this.mCornerColors.length; ++i) {
            this.mCornerColors[i].x = r;
            this.mCornerColors[i].y = g;
            this.mCornerColors[i].z = b;
        }
    }

    public void setColorI(int r, int g, int b) {
        this.mUseColor = true;
        float rF = (float)r / 255.0f;
        float gF = (float)g / 255.0f;
        float bF = (float)b / 255.0f;
        for (int i = 0; i < this.mCornerColors.length; ++i) {
            this.mCornerColors[i].x = rF;
            this.mCornerColors[i].y = gF;
            this.mCornerColors[i].z = bF;
        }
    }

    public void setColorF(float r, float b, float g) {
        this.mUseColor = true;
        for (int i = 0; i < this.mCornerColors.length; ++i) {
            this.mCornerColors[i].x = r;
            this.mCornerColors[i].y = g;
            this.mCornerColors[i].z = b;
        }
    }

    public void setAbsoluteTextureCoords(boolean value) {
        this.mAbsoluteTexCoords = value;
    }

    public boolean getAbsoluteTextureCoords() {
        return this.mAbsoluteTexCoords;
    }

    private Vector3f getLocalCoords(Vector3f vec, int side) {
        Vector3f coords;
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        switch (dir) {
            case DOWN: {
                coords = new Vector3f(vec.x, vec.z, 1.0f - vec.y);
                break;
            }
            case EAST: {
                coords = new Vector3f(1.0f - vec.z, vec.y, vec.x);
                break;
            }
            case NORTH: {
                coords = new Vector3f(1.0f - vec.x, vec.y, 1.0f - vec.z);
                break;
            }
            case SOUTH: {
                coords = new Vector3f(vec.x, vec.y, vec.z);
                break;
            }
            case UP: {
                coords = new Vector3f(vec.x, 1.0f - vec.z, vec.y);
                break;
            }
            case WEST: {
                coords = new Vector3f(vec.z, vec.y, 1.0f - vec.x);
                break;
            }
            default: {
                coords = null;
            }
        }
        return coords;
    }

    private void rotateVector(Vector3f vec, int amount) {
        double theta = (double)amount * 1.5707963267948966;
        double x = (double)vec.x * Math.cos(theta) - (double)vec.y * Math.sin(theta);
        double y = (double)vec.x * Math.sin(theta) + (double)vec.y * Math.cos(theta);
        vec.x = (float)x;
        vec.y = (float)y;
    }

    private void rotateVector(Vector2f vec, int amount) {
        double theta = (double)amount * 1.5707963267948966;
        double x = (double)vec.x * Math.cos(theta) - (double)vec.y * Math.sin(theta);
        double y = (double)vec.x * Math.sin(theta) + (double)vec.y * Math.cos(theta);
        vec.x = (float)x;
        vec.y = (float)y;
    }

    private void normalizeCoords(Vector2f[] coords) {
        int i;
        int xNeg = 0;
        int yNeg = 0;
        int xPos = 0;
        int yPos = 0;
        for (i = 0; i < coords.length; ++i) {
            if ((double)coords[i].x < -1.0E-5) {
                xNeg = (int)Math.max((double)xNeg, -Math.floor(coords[i].x));
            }
            if ((double)coords[i].y < -1.0E-5) {
                yNeg = (int)Math.max((double)yNeg, -Math.floor(coords[i].y));
            }
            if ((double)coords[i].x > 1.00001) {
                xPos = (int)Math.max((double)xPos, Math.floor(coords[i].x));
            }
            if (!((double)coords[i].y > 1.00001)) continue;
            yPos = (int)Math.max((double)yPos, Math.floor(coords[i].y));
        }
        if (xNeg != 0 || yNeg != 0 || xPos != 0 || yPos != 0) {
            for (i = 0; i < coords.length; ++i) {
                coords[i].x += (float)xNeg;
                coords[i].y += (float)yNeg;
                coords[i].x -= (float)xPos;
                coords[i].y -= (float)yPos;
            }
        }
    }

    private void normalizeCoords(Vector3f[] coords) {
        int i;
        int xNeg = 0;
        int yNeg = 0;
        int xPos = 0;
        int yPos = 0;
        for (i = 0; i < coords.length; ++i) {
            if ((double)coords[i].x < -1.0E-5) {
                xNeg = (int)Math.max((double)xNeg, -Math.floor(coords[i].x));
            }
            if ((double)coords[i].y < -1.0E-5) {
                yNeg = (int)Math.max((double)yNeg, -Math.floor(coords[i].y));
            }
            if ((double)coords[i].x > 1.00001) {
                xPos = (int)Math.max((double)xPos, Math.floor(coords[i].x));
            }
            if (!((double)coords[i].y > 1.00001)) continue;
            yPos = (int)Math.max((double)yPos, Math.floor(coords[i].y));
        }
        if (xNeg != 0 || yNeg != 0 || xPos != 0 || yPos != 0) {
            for (i = 0; i < coords.length; ++i) {
                coords[i].x += (float)xNeg;
                coords[i].y += (float)yNeg;
                coords[i].x -= (float)xPos;
                coords[i].y -= (float)yPos;
            }
        }
    }

    private void flipCoords(Vector3f[] coords, int flip) {
        int i;
        if ((flip & 1) != 0) {
            for (i = 0; i < coords.length; ++i) {
                coords[i].x = 1.0f - coords[i].x;
            }
        }
        if ((flip & 2) != 0) {
            for (i = 0; i < coords.length; ++i) {
                coords[i].y = 1.0f - coords[i].y;
            }
        }
    }

    private void updateTextureCoords() {
        for (int side = 0; side < 6; ++side) {
            float height;
            float width;
            float top;
            float left;
            if (!this.iconMode) {
                left = (float)(this.texIndex[side] % this.textureWidth) / (float)this.textureWidth;
                top = (float)(this.texIndex[side] / this.textureWidth) / (float)this.textureHeight;
                width = 1.0f / (float)this.textureWidth;
                height = 1.0f / (float)this.textureHeight;
            } else {
                left = this.texIcons[side].func_94209_e();
                top = this.texIcons[side].func_94206_g();
                width = this.texIcons[side].func_94212_f() - left;
                height = this.texIcons[side].func_94210_h() - top;
            }
            if (this.mAbsoluteTexCoords) {
                int i;
                Vector3f[] coords = new Vector3f[4];
                for (i = 0; i < 4; ++i) {
                    coords[i] = this.getLocalCoords(this.vertices[this.corners[side][i]], side);
                    this.rotateVector(coords[i], this.textureRotation[side]);
                }
                this.normalizeCoords(coords);
                this.flipCoords(coords, this.textureFlip[side]);
                for (i = 0; i < 4; ++i) {
                    this.textureCoords[side][i] = new Vector2f(left + coords[i].x * width, top + (1.0f - coords[i].y) * height);
                }
                continue;
            }
            this.textureCoords[side][0] = new Vector2f(left, top + height);
            this.textureCoords[side][1] = new Vector2f(left + width, top + height);
            this.textureCoords[side][2] = new Vector2f(left + width, top);
            this.textureCoords[side][3] = new Vector2f(left, top);
            for (int i = 0; i < 4; ++i) {
                this.rotateVector(this.textureCoords[side][i], this.textureRotation[side]);
            }
            this.normalizeCoords(this.textureCoords[side]);
        }
    }

    public void setupBox(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.vertices[0] = new Vector3f(minX, minY, minZ);
        this.vertices[1] = new Vector3f(maxX, minY, minZ);
        this.vertices[2] = new Vector3f(minX, maxY, minZ);
        this.vertices[3] = new Vector3f(minX, minY, maxZ);
        this.vertices[4] = new Vector3f(maxX, maxY, minZ);
        this.vertices[5] = new Vector3f(minX, maxY, maxZ);
        this.vertices[6] = new Vector3f(maxX, minY, maxZ);
        this.vertices[7] = new Vector3f(maxX, maxY, maxZ);
        this.corners[0] = new int[]{0, 1, 6, 3};
        this.corners[1] = new int[]{5, 7, 4, 2};
        this.corners[2] = new int[]{2, 4, 1, 0};
        this.corners[3] = new int[]{7, 5, 3, 6};
        this.corners[4] = new int[]{5, 2, 0, 3};
        this.corners[5] = new int[]{4, 7, 6, 1};
    }

    public void outset(float amount) {
        int i;
        Vector3f center = new Vector3f();
        for (i = 0; i < this.vertices.length; ++i) {
            Vector3f.add((Vector3f)center, (Vector3f)this.vertices[i], (Vector3f)center);
        }
        center.scale(1.0f / (float)this.vertices.length);
        for (i = 0; i < this.vertices.length; ++i) {
            Vector3f diff = new Vector3f();
            Vector3f.sub((Vector3f)this.vertices[i], (Vector3f)center, (Vector3f)diff);
            diff.normalise();
            diff.scale(amount);
            Vector3f.add((Vector3f)this.vertices[i], (Vector3f)diff, (Vector3f)this.vertices[i]);
        }
    }

    public void clamp() {
        for (int i = 0; i < this.vertices.length; ++i) {
            Vector3f vec = this.vertices[i];
            if (vec.x < 0.0f) {
                vec.x = 0.0f;
            }
            if (vec.y < 0.0f) {
                vec.y = 0.0f;
            }
            if (vec.z < 0.0f) {
                vec.z = 0.0f;
            }
            if (vec.x > 1.0f) {
                vec.x = 1.0f;
            }
            if (vec.y > 1.0f) {
                vec.y = 1.0f;
            }
            if (!(vec.z > 1.0f)) continue;
            vec.z = 1.0f;
        }
    }

    public void resetTransform() {
        this.transform.setIdentity();
    }

    public void translate(float x, float y, float z) {
        Matrix4f mat = new Matrix4f();
        mat = mat.translate(new Vector3f(x, y, z));
        Matrix4f.mul((Matrix4f)mat, (Matrix4f)this.transform, (Matrix4f)this.transform);
    }

    public void rotate(float amount, Vector3f axis) {
        Matrix4f mat = new Matrix4f();
        mat = mat.rotate(amount, axis);
        Matrix4f.mul((Matrix4f)mat, (Matrix4f)this.transform, (Matrix4f)this.transform);
    }

    public void scale(float x, float y, float z) {
        Matrix4f mat = new Matrix4f();
        mat = mat.scale(new Vector3f(x, y, z));
        Matrix4f.mul((Matrix4f)mat, (Matrix4f)this.transform, (Matrix4f)this.transform);
    }

    public void drawBox(int faces, float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.setupBox(minX, minY, minZ, maxX, maxY, maxZ);
        this.drawFaces(faces);
    }

    private float interpolateAO(int side, float u, float v) {
        float top = this.mCornerAO[side][0] * u + (1.0f - u) * this.mCornerAO[side][1];
        float bottom = this.mCornerAO[side][3] * u + (1.0f - u) * this.mCornerAO[side][2];
        return top * v + (1.0f - v) * bottom;
    }

    private int interpolateBrightness(int side, float u, float v) {
        int[] sky = new int[4];
        int[] block = new int[4];
        for (int i = 0; i < 4; ++i) {
            sky[i] = this.mFaceBrightness[side][i] >> 20 & 0xF;
            block[i] = this.mFaceBrightness[side][i] >> 4 & 0xF;
        }
        float skyValTop = (float)sky[0] * u + (1.0f - u) * (float)sky[1];
        float skyValBottom = (float)sky[3] * u + (1.0f - u) * (float)sky[2];
        float blockValTop = (float)block[0] * u + (1.0f - u) * (float)block[1];
        float blockValBottom = (float)block[3] * u + (1.0f - u) * (float)block[2];
        float skyVal = skyValTop * v + (1.0f - v) * skyValBottom;
        float blockVal = blockValTop * v + (1.0f - v) * blockValBottom;
        return Math.round(skyVal) << 20 | Math.round(blockVal) << 4;
    }

    private void drawFace(int face, boolean reverse) {
        int v;
        Vector3f[] coords = new Vector3f[4];
        for (v = 0; v < 4; ++v) {
            coords[v] = this.getLocalCoords(this.vertices[this.corners[face][v]], face);
        }
        if (face == 0 || face == 1) {
            Vector3f temp = coords[0];
            coords[0] = coords[2];
            coords[2] = temp;
            temp = coords[3];
            coords[3] = coords[1];
            coords[1] = temp;
        }
        this.normalizeCoords(coords);
        for (v = 0; v < 4; ++v) {
            int vertexIndex = reverse ? 3 - v : v;
            Vector3f color = this.mCornerColors[face];
            if (!this.mUseColor) {
                color.z = 1.0f;
                color.y = 1.0f;
                color.x = 1.0f;
            }
            if (this.enableLighting) {
                if (this.mEnableAO) {
                    if (this.mAbsoluteTexCoords) {
                        float ao = coords[vertexIndex].z < 1.0f ? this.mInternalAO : this.interpolateAO(face, coords[vertexIndex].x, coords[vertexIndex].y);
                        color.x *= ao;
                        color.y *= ao;
                        color.z *= ao;
                    } else {
                        color.x *= this.mCornerAO[face][vertexIndex];
                        color.y *= this.mCornerAO[face][vertexIndex];
                        color.z *= this.mCornerAO[face][vertexIndex];
                    }
                }
                color.x *= this.mLocalLighting[face];
                color.y *= this.mLocalLighting[face];
                color.z *= this.mLocalLighting[face];
                this.tes.func_78380_c(coords[vertexIndex].z < 1.0f ? this.mInternalBrightness : this.interpolateBrightness(face, coords[vertexIndex].x, coords[vertexIndex].y));
            }
            this.tes.func_78369_a(color.x, color.y, color.z, this.opacity);
            if (this.enableNormals) {
                this.tes.func_78375_b((float)ForgeDirection.getOrientation((int)face).offsetX, (float)ForgeDirection.getOrientation((int)face).offsetY, (float)ForgeDirection.getOrientation((int)face).offsetZ);
            }
            Vector4f vert = new Vector4f();
            Matrix4f.transform((Matrix4f)this.transform, (Vector4f)new Vector4f(this.vertices[this.corners[face][vertexIndex]].x, this.vertices[this.corners[face][vertexIndex]].y, this.vertices[this.corners[face][vertexIndex]].z, 1.0f), (Vector4f)vert);
            this.tes.func_78374_a((double)vert.x, (double)vert.y, (double)vert.z, (double)this.textureCoords[face][vertexIndex].x, (double)this.textureCoords[face][vertexIndex].y);
        }
    }

    public void drawFaces(int faces) {
        this.tes = Tessellator.field_78398_a;
        this.updateTextureCoords();
        block5: for (int i = 0; i < 6; ++i) {
            if ((faces & 1 << i) == 0) continue;
            switch (this.faceMode) {
                case Normal: {
                    this.drawFace(i, false);
                    continue block5;
                }
                case Inverse: {
                    this.drawFace(i, true);
                    continue block5;
                }
                case Both: {
                    this.drawFace(i, false);
                    this.drawFace(i, true);
                }
            }
        }
    }

    public void drawPolygon(Vector3f[] vertices, int[] indices) {
        for (int i = 0; i < indices.length; ++i) {
            Vector4f vert = new Vector4f();
            Matrix4f.transform((Matrix4f)this.transform, (Vector4f)new Vector4f(vertices[indices[i]].x, vertices[indices[i]].y, vertices[indices[i]].z, 1.0f), (Vector4f)vert);
            this.tes.func_78377_a((double)vert.x, (double)vert.y, (double)vert.z);
        }
    }

    public void drawPolygon(Vector3f[] vertices, Vector2f[] texCoords, int[] indices) {
        this.tes = Tessellator.field_78398_a;
        for (int i = 0; i < indices.length; ++i) {
            Vector4f vert = new Vector4f();
            Matrix4f.transform((Matrix4f)this.transform, (Vector4f)new Vector4f(vertices[indices[i]].x, vertices[indices[i]].y, vertices[indices[i]].z, 1.0f), (Vector4f)vert);
            this.tes.func_78374_a((double)vert.x, (double)vert.y, (double)vert.z, (double)texCoords[indices[i]].x, (double)texCoords[indices[i]].y);
        }
    }

    public float toRadians(float deg) {
        return (float)((double)deg * Math.PI / 180.0);
    }

    public float toDegrees(float rad) {
        return (float)((double)rad / Math.PI * 180.0);
    }

    public void pushTransform() {
        this.mStackTransforms.push(new Matrix4f().load(this.transform));
    }

    public void popTransform() {
        this.transform = this.mStackTransforms.pop();
    }

    public void resetLighting() {
        this.resetLighting(0xF000F0);
    }

    public static enum FaceMode {
        Normal,
        Inverse,
        Both;

    }
}

