/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.types;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.RedstoneInteractions;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import schmoller.tubes.AnyFilter;
import schmoller.tubes.ItemFilter;
import schmoller.tubes.ModTubes;
import schmoller.tubes.PullMode;
import schmoller.tubes.api.FilterRegistry;
import schmoller.tubes.api.InteractionHandler;
import schmoller.tubes.api.OverflowBuffer;
import schmoller.tubes.api.Payload;
import schmoller.tubes.api.Position;
import schmoller.tubes.api.SizeMode;
import schmoller.tubes.api.TubeItem;
import schmoller.tubes.api.helpers.BaseRouter;
import schmoller.tubes.api.helpers.CommonHelper;
import schmoller.tubes.api.helpers.TubeHelper;
import schmoller.tubes.api.interfaces.IFilter;
import schmoller.tubes.api.interfaces.IPayloadHandler;
import schmoller.tubes.api.interfaces.IRouteCheckCallback;
import schmoller.tubes.api.interfaces.ITubeConnectable;
import schmoller.tubes.api.interfaces.ITubeImportDest;
import schmoller.tubes.api.interfaces.ITubeOverflowDestination;
import schmoller.tubes.routing.ImportSourceFinder;
import schmoller.tubes.routing.InputRouter;
import schmoller.tubes.routing.OutputRouter;
import schmoller.tubes.types.DirectionalTube;

public class RequestingTube
extends DirectionalTube
implements ITubeImportDest,
IRedstonePart,
ITubeOverflowDestination,
IRouteCheckCallback {
    private IFilter[] mFilter = new IFilter[16];
    private int mNext = 0;
    private PullMode mMode = PullMode.RedstoneConstant;
    private SizeMode mSizeMode = SizeMode.Max;
    private OverflowBuffer mOverflow = new OverflowBuffer();
    private int mColor = -1;
    private int mPulses = 0;
    private boolean mIsPowered;
    public static final int CHANNEL_PULSE = 2;
    public static final int CHANNEL_MODE = 3;
    public static final int CHANNEL_POWERED = 4;
    public static final int CHANNEL_SIZEMODE = 5;
    public float animTime = 0.0f;
    private IFilter mActiveFilter;

    public RequestingTube() {
        super("requesting");
    }

    @Override
    public int getHollowSize(int side) {
        if (side == this.getFacing()) {
            return 10;
        }
        return super.getHollowSize(side);
    }

    @Override
    public boolean canConnectTo(ITubeConnectable con) {
        return !(con instanceof RequestingTube);
    }

    @Override
    protected int getConnectableSides() {
        int dir = this.getFacing();
        return 1 << dir | 1 << (dir ^ 1);
    }

    @Override
    public boolean canPathThrough() {
        return false;
    }

    @Override
    public int getTickRate() {
        return this.mOverflow.isEmpty() ? 20 : 10;
    }

    @Override
    public void onTick() {
        if (this.world().field_72995_K) {
            return;
        }
        if (!this.mOverflow.isEmpty()) {
            TubeItem item = this.mOverflow.peekNext();
            BaseRouter.PathLocation loc = new OutputRouter((IBlockAccess)this.world(), new Position(this.x(), this.y(), this.z()), item, this.getFacing() ^ 1).route();
            if (loc != null) {
                this.mOverflow.getNext();
                item.state = 0;
                item.direction = item.lastDirection = this.getFacing() ^ 1;
                item.updated = true;
                item.setProgress(0.5f);
                this.addItem(item, true);
            }
        } else if (this.mMode == PullMode.Constant || this.mMode == PullMode.RedstoneConstant && this.mIsPowered || this.mMode == PullMode.RedstoneSingle && this.mPulses > 0) {
            Object extracted;
            IPayloadHandler handler;
            IFilter filterItem = null;
            int start = this.mNext;
            do {
                filterItem = this.mFilter[this.mNext++];
                if (this.mNext < 16) continue;
                this.mNext = 0;
            } while (filterItem == null && this.mNext != start);
            this.mActiveFilter = filterItem;
            BaseRouter.PathLocation source = new ImportSourceFinder((IBlockAccess)this.world(), new Position(this.x(), this.y(), this.z()), this.getFacing(), filterItem, this.mSizeMode).setRouteCheckCallback(this).route();
            if (source != null && (handler = InteractionHandler.getHandler(filterItem == null ? null : filterItem.getPayloadType(), (IBlockAccess)this.world(), source.position)) != null && (extracted = filterItem == null ? handler.extract(new AnyFilter(0), source.dir ^ 1, true) : handler.extract(filterItem, source.dir ^ 1, filterItem.size(), this.mSizeMode, true)) != null) {
                TubeItem tItem = new TubeItem((Payload)extracted);
                tItem.state = 1;
                tItem.direction = source.dir ^ 1;
                BaseRouter.PathLocation tubeLoc = new BaseRouter.PathLocation(source, source.dir ^ 1);
                TileEntity tile = CommonHelper.getTileEntity((IBlockAccess)this.world(), tubeLoc.position);
                ITubeConnectable con = TubeHelper.getTubeConnectable(tile);
                if (con != null) {
                    con.addItem(tItem, true);
                }
                --this.mPulses;
                if (this.mPulses < 0) {
                    this.mPulses = 0;
                }
                if (this.mMode == PullMode.RedstoneSingle) {
                    this.openChannel(2);
                }
                return;
            }
        }
    }

    @Override
    public boolean isEndPointOk(Position position, int fromSide) {
        Object extracted;
        IPayloadHandler handler = InteractionHandler.getHandler(this.mActiveFilter == null ? null : this.mActiveFilter.getPayloadType(), (IBlockAccess)this.world(), position);
        if (handler != null && (extracted = this.mActiveFilter == null ? handler.extract(new AnyFilter(0), fromSide ^ 1, false) : handler.extract(this.mActiveFilter, fromSide ^ 1, this.mActiveFilter.size(), this.mSizeMode, false)) != null) {
            TubeItem tItem = new TubeItem((Payload)extracted);
            tItem.state = 1;
            tItem.direction = fromSide ^ 1;
            return new InputRouter((IBlockAccess)this.world(), position.copy().offset(fromSide ^ 1, 1), tItem).route() != null;
        }
        return false;
    }

    @Override
    public boolean canAcceptOverflowFromSide(int side) {
        return side == this.getFacing();
    }

    @Override
    public boolean hasCustomRouting() {
        return true;
    }

    @Override
    public void simulateEffects(TubeItem item) {
        item.colour = this.mColor;
        item.state = 0;
    }

    @Override
    public int onDetermineDestination(TubeItem item) {
        if (item.state != 1) {
            return item.direction ^ 1;
        }
        item.colour = this.mColor;
        item.state = 0;
        return this.getFacing() ^ 1;
    }

    @Override
    public boolean canItemEnter(TubeItem item) {
        if (item.state == 2 && item.direction == this.getFacing()) {
            return true;
        }
        if (item.state != 1) {
            return false;
        }
        if (item.direction != (this.getFacing() ^ 1)) {
            return false;
        }
        if (!this.mOverflow.isEmpty()) {
            return false;
        }
        boolean empty = true;
        for (int i = 0; i < 16; ++i) {
            if (this.mFilter[i] == null) continue;
            empty = false;
            if (!this.mFilter[i].matches(item, SizeMode.Max)) continue;
            return true;
        }
        return empty;
    }

    @Override
    public boolean canAddItem(Payload payload, int direction) {
        if (direction != (this.getFacing() ^ 1)) {
            return false;
        }
        boolean empty = true;
        for (int i = 0; i < 16; ++i) {
            if (this.mFilter[i] == null) continue;
            empty = false;
            if (!this.mFilter[i].matches(payload, SizeMode.Max)) continue;
            return true;
        }
        return empty;
    }

    @Override
    protected boolean onItemJunction(TubeItem item) {
        if (item.state == 2) {
            if (!this.world().field_72995_K) {
                this.mOverflow.addItem(item);
            }
            return false;
        }
        if (item.direction == this.getFacing()) {
            item.lastDirection = item.direction;
            item.direction = this.getFacing() ^ 1;
            item.updated = true;
            return true;
        }
        if (!this.mOverflow.isEmpty()) {
            if (!this.world().field_72995_K) {
                this.mOverflow.addItem(item);
            }
            return false;
        }
        return super.onItemJunction(item);
    }

    private int getPower() {
        int current = 0;
        for (int side = 0; side < 6; ++side) {
            current = Math.max(current, RedstoneInteractions.getPowerTo((World)this.world(), (int)this.x(), (int)this.y(), (int)this.z(), (int)side, (int)31));
        }
        return current;
    }

    public void onWorldJoin() {
        this.mIsPowered = this.getPower() > 0;
    }

    @Override
    public void update() {
        if (!this.world().field_72995_K) {
            boolean state;
            boolean bl = state = this.getPower() > 0;
            if (state != this.mIsPowered) {
                this.openChannel(4).writeBoolean(state);
            }
            if (!this.mIsPowered && state && this.mMode == PullMode.RedstoneSingle) {
                ++this.mPulses;
            }
            this.mIsPowered = state;
        } else {
            switch (this.getMode()) {
                case Constant: {
                    this.animTime += 0.05f;
                    if (!(this.animTime > 1.0f)) break;
                    this.animTime -= 1.0f;
                    break;
                }
                case RedstoneConstant: {
                    if (this.isPowered()) {
                        this.animTime += 0.05f;
                        if (!(this.animTime > 1.0f)) break;
                        this.animTime -= 1.0f;
                        break;
                    }
                    if (!(this.animTime > 0.0f)) break;
                    this.animTime += 0.05f;
                    if (!(this.animTime > 1.0f)) break;
                    this.animTime = 0.0f;
                    break;
                }
                case RedstoneSingle: {
                    if (this.animTime > 0.0f) {
                        this.animTime += 0.05f;
                    }
                    if (!(this.animTime > 1.0f)) break;
                    this.animTime = 0.0f;
                }
            }
        }
        super.update();
    }

    public boolean canConnectRedstone(int side) {
        return true;
    }

    public int strongPowerLevel(int side) {
        return 0;
    }

    public int weakPowerLevel(int side) {
        return 0;
    }

    @Override
    public boolean canImportFromSide(int side) {
        return side == (this.getFacing() ^ 1);
    }

    public IFilter getFilter(int slot) {
        return this.mFilter[slot];
    }

    public void setFilter(int slot, IFilter filter) {
        this.mFilter[slot] = filter;
    }

    public PullMode getMode() {
        return this.mMode;
    }

    public void setMode(PullMode mode) {
        this.mMode = mode;
        if (!this.world().field_72995_K) {
            this.openChannel(3).writeByte(mode.ordinal());
        }
    }

    public SizeMode getSizeMode() {
        return this.mSizeMode;
    }

    public void setSizeMode(SizeMode mode) {
        this.mSizeMode = mode;
        if (!this.world().field_72995_K) {
            this.openChannel(5).writeByte(mode.ordinal());
        }
    }

    public short getColour() {
        return (short)this.mColor;
    }

    public void setColour(short colour) {
        this.mColor = colour;
    }

    public boolean isPowered() {
        return this.mIsPowered;
    }

    @Override
    protected void onDropItems(List<ItemStack> itemsToDrop) {
        super.onDropItems(itemsToDrop);
        this.mOverflow.onDropItems(itemsToDrop);
    }

    @Override
    protected void onRecieveDataClient(int channel, MCDataInput input) {
        if (channel == 3) {
            this.mMode = PullMode.values()[input.readByte()];
        } else if (channel == 2) {
            this.animTime = 1.0E-4f;
        } else if (channel == 4) {
            this.mIsPowered = input.readBoolean();
        } else if (channel == 5) {
            this.mSizeMode = SizeMode.values()[input.readByte()];
        } else {
            super.onRecieveDataClient(channel, input);
        }
    }

    @Override
    public void readDesc(MCDataInput input) {
        super.readDesc(input);
        this.mMode = PullMode.values()[input.readByte()];
        this.mSizeMode = SizeMode.values()[input.readByte()];
        this.mColor = input.readShort();
        this.mIsPowered = input.readBoolean();
    }

    @Override
    public void writeDesc(MCDataOutput output) {
        super.writeDesc(output);
        output.writeByte(this.mMode.ordinal());
        output.writeByte(this.mSizeMode.ordinal());
        output.writeShort(this.mColor);
        output.writeBoolean(this.mIsPowered);
    }

    @Override
    public void save(NBTTagCompound root) {
        super.save(root);
        NBTTagList filter = new NBTTagList();
        for (int i = 0; i < 16; ++i) {
            if (this.mFilter[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("Slot", i);
            FilterRegistry.getInstance().writeFilter(this.mFilter[i], tag);
            filter.func_74742_a((NBTBase)tag);
        }
        root.func_74782_a("NewFilter", (NBTBase)filter);
        root.func_74778_a("PullMode", this.mMode.name());
        root.func_74778_a("SizeMode", this.mSizeMode.name());
        root.func_74768_a("Pulses", this.mPulses);
        this.mOverflow.save(root);
        root.func_74777_a("Color", (short)this.mColor);
    }

    @Override
    public void load(NBTTagCompound root) {
        super.load(root);
        if (root.func_74764_b("Filter")) {
            NBTTagList filter = root.func_150295_c("Filter", 10);
            if (filter == null) {
                return;
            }
            for (int i = 0; i < filter.func_74745_c(); ++i) {
                NBTTagCompound tag = filter.func_150305_b(i);
                int slot = tag.func_74762_e("Slot");
                this.mFilter[slot] = new ItemFilter(ItemStack.func_77949_a((NBTTagCompound)tag), false);
            }
        } else {
            NBTTagList filter = root.func_150295_c("NewFilter", 10);
            if (filter == null) {
                return;
            }
            for (int i = 0; i < filter.func_74745_c(); ++i) {
                NBTTagCompound tag = filter.func_150305_b(i);
                int slot = tag.func_74762_e("Slot");
                this.mFilter[slot] = FilterRegistry.getInstance().readFilter(tag);
            }
        }
        this.mMode = PullMode.valueOf(root.func_74779_i("PullMode"));
        this.mPulses = root.func_74762_e("Pulses");
        this.mOverflow.load(root);
        if (root.func_74764_b("Color")) {
            this.mColor = root.func_74765_d("Color");
        }
        this.mSizeMode = root.func_74764_b("SizeMode") ? SizeMode.valueOf(root.func_74779_i("SizeMode")) : SizeMode.Exact;
    }

    @Override
    public boolean activate(EntityPlayer player, MovingObjectPosition part, ItemStack item) {
        if (!super.activate(player, part, item)) {
            player.openGui((Object)ModTubes.instance, 3, this.world(), this.x(), this.y(), this.z());
            return true;
        }
        return false;
    }
}

