/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.types;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import schmoller.tubes.api.TubeItem;
import schmoller.tubes.api.helpers.BaseTube;
import schmoller.tubes.api.helpers.CommonHelper;
import schmoller.tubes.api.interfaces.ITubeConnectable;

public class BasicTube
extends BaseTube
implements ITubeConnectable {
    private int mColor = -1;
    public static final int CHANNEL_COLOUR = 1;

    public BasicTube(String type) {
        super(type);
    }

    @Override
    public boolean canItemEnter(TubeItem item) {
        return this.mColor == -1 || item.colour == this.mColor || item.colour == -1;
    }

    @Override
    public int getColor() {
        return this.mColor;
    }

    @Override
    public void load(NBTTagCompound root) {
        super.load(root);
        this.mColor = root.func_74765_d("Color");
    }

    @Override
    public void save(NBTTagCompound root) {
        super.save(root);
        root.func_74777_a("Color", (short)this.mColor);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.mColor = packet.readShort();
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeShort(this.mColor);
    }

    @Override
    public boolean canConnectTo(ITubeConnectable con) {
        return this.mColor == -1 || con.getColor() == this.mColor || con.getColor() == -1;
    }

    private void updateColour() {
        if (this.world().field_72995_K) {
            return;
        }
        this.openChannel(1).writeShort(this.mColor);
    }

    @Override
    protected void onRecieveDataClient(int channel, MCDataInput input) {
        if (channel == 1) {
            this.mColor = input.readShort();
            this.tile().markRender();
        }
        super.onRecieveDataClient(channel, input);
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition part, ItemStack item) {
        if (item == null || item.func_77973_b() == null) {
            return false;
        }
        FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)item);
        if (liquid != null && FluidRegistry.getFluidName((FluidStack)liquid).equals("water")) {
            this.mColor = -1;
            this.updateColour();
            return true;
        }
        int index = CommonHelper.getDyeIndex(item);
        if (index != -1) {
            this.mColor = index;
            this.updateColour();
            return true;
        }
        return false;
    }
}

