/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.render;

import cpw.mods.fml.client.FMLClientHandler;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import schmoller.tubes.AdvRender;
import schmoller.tubes.api.TubeDefinition;
import schmoller.tubes.api.client.ITubeRender;
import schmoller.tubes.api.helpers.CommonHelper;
import schmoller.tubes.api.helpers.RenderHelper;
import schmoller.tubes.api.helpers.TubeHelper;
import schmoller.tubes.api.interfaces.ITube;
import schmoller.tubes.definitions.TypeEjectionTube;
import schmoller.tubes.definitions.TypeNormalTube;

public class NormalTubeRender
implements ITubeRender {
    protected AdvRender mRender = new AdvRender();

    @Override
    public void renderDynamic(TubeDefinition type, ITube tube, World world, int x, int y, int z, float frameTime) {
        RenderHelper.renderTubeItems(tube, x, y, z, frameTime);
    }

    @Override
    public void renderStatic(TubeDefinition type, ITube tube, World world, int x, int y, int z) {
        int connections = tube.getConnections();
        this.mRender.resetTransform();
        this.mRender.enableNormals = false;
        this.mRender.setLightingFromBlock((IBlockAccess)world, x, y, z);
        this.mRender.resetTextureFlip();
        this.mRender.resetTextureRotation();
        this.mRender.resetColor();
        this.mRender.faceMode = AdvRender.FaceMode.Both;
        this.mRender.setLocalLights(0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f);
        this.mRender.translate(x, y, z);
        int col = tube.getColor();
        int invCons = 0;
        for (int i = 0; i < 6; ++i) {
            if ((connections & 1 << i) == 0 || !TubeHelper.renderAsInventoryConnection((IBlockAccess)world, x, y, z, i)) continue;
            invCons |= 1 << i;
        }
        int tubeCons = connections - invCons;
        if (connections == 3 || connections == 12 || connections == 48) {
            this.renderStraight(connections, type, invCons, col);
            this.renderInventoryConnections(invCons, type);
        } else {
            this.renderCore(connections, type, col);
            this.renderConnections(tubeCons, type);
            this.renderInventoryConnections(invCons, type);
        }
    }

    protected void renderStraight(int connections, TubeDefinition def, int cutoff, int col) {
        this.mRender.setIcon(def.getStraightIcon());
        if (connections == 3) {
            float min = 0.0f;
            float max = 1.0f;
            if ((cutoff & 1) != 0) {
                min = 0.25f;
            }
            if ((cutoff & 2) != 0) {
                max = 0.75f;
            }
            this.mRender.drawBox(60, 0.25f, min, 0.25f, 0.75f, max, 0.75f);
            if (col != -1) {
                this.mRender.setIcon(TypeNormalTube.paintStraight);
                this.mRender.setColorRGB(CommonHelper.getDyeColor(col));
                this.mRender.setupBox(0.25f, min, 0.25f, 0.75f, max, 0.75f);
                this.mRender.outset(0.001f);
                this.mRender.clamp();
                this.mRender.drawFaces(60);
            }
        } else if (connections == 12) {
            float min = 0.0f;
            float max = 1.0f;
            if ((cutoff & 4) != 0) {
                min = 0.25f;
            }
            if ((cutoff & 8) != 0) {
                max = 0.75f;
            }
            this.mRender.setTextureRotation(0, 0, 1, 1, 1, 1);
            this.mRender.drawBox(51, 0.25f, 0.25f, min, 0.75f, 0.75f, max);
            if (col != -1) {
                this.mRender.setIcon(TypeNormalTube.paintStraight);
                this.mRender.setColorRGB(CommonHelper.getDyeColor(col));
                this.mRender.setupBox(0.25f, 0.25f, min, 0.75f, 0.75f, max);
                this.mRender.outset(0.001f);
                this.mRender.clamp();
                this.mRender.drawFaces(51);
            }
        } else {
            float min = 0.0f;
            float max = 1.0f;
            if ((cutoff & 0x10) != 0) {
                min = 0.25f;
            }
            if ((cutoff & 0x20) != 0) {
                max = 0.75f;
            }
            this.mRender.setTextureRotation(1);
            this.mRender.drawBox(15, min, 0.25f, 0.25f, max, 0.75f, 0.75f);
            if (col != -1) {
                this.mRender.setIcon(TypeNormalTube.paintStraight);
                this.mRender.setColorRGB(CommonHelper.getDyeColor(col));
                this.mRender.setupBox(min, 0.25f, 0.25f, max, 0.75f, 0.75f);
                this.mRender.outset(0.001f);
                this.mRender.clamp();
                this.mRender.drawFaces(15);
            }
        }
        this.mRender.resetColor();
        this.mRender.resetTextureRotation();
    }

    protected void renderCore(int connections, TubeDefinition def, int col) {
        this.mRender.setIcon(def.getCenterIcon());
        this.mRender.drawBox(~connections & 0x3F, 0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
        if (col != -1) {
            this.mRender.setIcon(TypeNormalTube.paintCenter);
            this.mRender.setColorRGB(CommonHelper.getDyeColor(col));
            this.mRender.setupBox(0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
            this.mRender.outset(0.001f);
            this.mRender.drawFaces(~connections & 0x3F);
            this.mRender.clamp();
            this.mRender.resetColor();
        }
    }

    protected void renderInventoryConnections(int connections, TubeDefinition def) {
        block8: for (int i = 0; i < 6; ++i) {
            if ((connections & 1 << i) == 0) continue;
            this.mRender.setIcon(TypeEjectionTube.funnelIcon);
            switch (i) {
                case 0: {
                    this.mRender.drawBox(60, 0.25f, 0.0f, 0.25f, 0.75f, 0.25f, 0.75f);
                    this.mRender.setIcon(TypeEjectionTube.endIcon, TypeEjectionTube.endIcon, TypeEjectionTube.funnelIcon, TypeEjectionTube.funnelIcon, TypeEjectionTube.funnelIcon, TypeEjectionTube.funnelIcon);
                    this.mRender.drawBox(63, 0.1875f, 0.0f, 0.1875f, 0.8125f, 0.0625f, 0.8125f);
                    continue block8;
                }
                case 1: {
                    this.mRender.drawBox(60, 0.25f, 0.75f, 0.25f, 0.75f, 1.0f, 0.75f);
                    this.mRender.setIcon(TypeEjectionTube.endIcon, TypeEjectionTube.endIcon, TypeEjectionTube.funnelIcon, TypeEjectionTube.funnelIcon, TypeEjectionTube.funnelIcon, TypeEjectionTube.funnelIcon);
                    this.mRender.drawBox(63, 0.1875f, 0.9375f, 0.1875f, 0.8125f, 1.0f, 0.8125f);
                    continue block8;
                }
                case 2: {
                    this.mRender.drawBox(51, 0.25f, 0.25f, 0.0f, 0.75f, 0.75f, 0.25f);
                    this.mRender.setIcon(TypeEjectionTube.funnelIcon, TypeEjectionTube.funnelIcon, TypeEjectionTube.endIcon, TypeEjectionTube.endIcon, TypeEjectionTube.funnelIcon, TypeEjectionTube.funnelIcon);
                    this.mRender.drawBox(63, 0.1875f, 0.1875f, 0.0f, 0.8125f, 0.8125f, 0.0625f);
                    continue block8;
                }
                case 3: {
                    this.mRender.drawBox(51, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f, 1.0f);
                    this.mRender.setIcon(TypeEjectionTube.funnelIcon, TypeEjectionTube.funnelIcon, TypeEjectionTube.endIcon, TypeEjectionTube.endIcon, TypeEjectionTube.funnelIcon, TypeEjectionTube.funnelIcon);
                    this.mRender.drawBox(63, 0.1875f, 0.1875f, 0.9375f, 0.8125f, 0.8125f, 1.0f);
                    continue block8;
                }
                case 4: {
                    this.mRender.drawBox(15, 0.0f, 0.25f, 0.25f, 0.25f, 0.75f, 0.75f);
                    this.mRender.setIcon(TypeEjectionTube.funnelIcon, TypeEjectionTube.funnelIcon, TypeEjectionTube.funnelIcon, TypeEjectionTube.funnelIcon, TypeEjectionTube.endIcon, TypeEjectionTube.endIcon);
                    this.mRender.drawBox(63, 0.0f, 0.1875f, 0.1875f, 0.0625f, 0.8125f, 0.8125f);
                    continue block8;
                }
                case 5: {
                    this.mRender.drawBox(15, 0.75f, 0.25f, 0.25f, 1.0f, 0.75f, 0.75f);
                    this.mRender.setIcon(TypeEjectionTube.funnelIcon, TypeEjectionTube.funnelIcon, TypeEjectionTube.funnelIcon, TypeEjectionTube.funnelIcon, TypeEjectionTube.endIcon, TypeEjectionTube.endIcon);
                    this.mRender.drawBox(63, 0.9375f, 0.1875f, 0.1875f, 1.0f, 0.8125f, 0.8125f);
                }
            }
        }
    }

    protected void renderConnections(int connections, TubeDefinition def) {
        this.mRender.setIcon(def.getCenterIcon());
        for (int i = 0; i < 6; ++i) {
            if ((connections & 1 << i) == 0) continue;
            this.mRender.resetTextureRotation();
            switch (i) {
                case 0: {
                    this.mRender.setupBox(0.25f, 0.0f, 0.25f, 0.75f, 0.25f, 0.75f);
                    break;
                }
                case 1: {
                    this.mRender.setupBox(0.25f, 0.75f, 0.25f, 0.75f, 1.0f, 0.75f);
                    break;
                }
                case 2: {
                    this.mRender.setTextureRotation(0, 0, 0, 0, 1, 1);
                    this.mRender.setupBox(0.25f, 0.25f, 0.0f, 0.75f, 0.75f, 0.25f);
                    break;
                }
                case 3: {
                    this.mRender.setTextureRotation(0, 0, 0, 0, 1, 1);
                    this.mRender.setupBox(0.25f, 0.25f, 0.75f, 0.75f, 0.75f, 1.0f);
                    break;
                }
                case 4: {
                    this.mRender.setTextureRotation(1);
                    this.mRender.setupBox(0.0f, 0.25f, 0.25f, 0.25f, 0.75f, 0.75f);
                    break;
                }
                case 5: {
                    this.mRender.setTextureRotation(1);
                    this.mRender.setupBox(0.75f, 0.25f, 0.25f, 1.0f, 0.75f, 0.75f);
                }
            }
            this.mRender.drawFaces(63 - (1 << (i ^ 1)) - (1 << i));
        }
        this.mRender.resetTextureRotation();
    }

    @Override
    public void renderItem(TubeDefinition type, ItemStack item) {
        this.mRender.resetTransform();
        this.mRender.enableNormals = true;
        this.mRender.resetTextureFlip();
        this.mRender.resetTextureRotation();
        this.mRender.resetLighting(0xF000F0);
        this.mRender.resetColor();
        this.mRender.faceMode = AdvRender.FaceMode.Normal;
        this.mRender.setLocalLights(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        Tessellator tes = Tessellator.field_78398_a;
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        tes.func_78382_b();
        this.mRender.setIcon(type.getCenterIcon());
        this.mRender.drawBox(63, 0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
        tes.func_78381_a();
    }
}

