/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.render;

import cpw.mods.fml.client.FMLClientHandler;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import schmoller.tubes.AdvRender;
import schmoller.tubes.api.TubeDefinition;
import schmoller.tubes.api.interfaces.IDirectionalTube;
import schmoller.tubes.api.interfaces.ITube;
import schmoller.tubes.definitions.TypeEjectionTube;
import schmoller.tubes.definitions.TypeFluidExtractionTube;
import schmoller.tubes.render.ExtractionTubeRender;
import schmoller.tubes.types.ExtractionTube;

public class FluidExtractionTubeRender
extends ExtractionTubeRender {
    @Override
    protected void renderExtractor(int side) {
        this.mRender.setIcon(TypeFluidExtractionTube.icon);
        switch (side) {
            case 0: {
                this.mRender.drawBox(60, 0.25f, 0.0f, 0.25f, 0.75f, 0.25f, 0.75f);
                this.mRender.setIcon(TypeEjectionTube.endIcon, TypeEjectionTube.endIcon, TypeFluidExtractionTube.icon, TypeFluidExtractionTube.icon, TypeFluidExtractionTube.icon, TypeFluidExtractionTube.icon);
                this.mRender.drawBox(63, 0.1875f, 0.0f, 0.1875f, 0.8125f, 0.0625f, 0.8125f);
                break;
            }
            case 1: {
                this.mRender.drawBox(60, 0.25f, 0.75f, 0.25f, 0.75f, 1.0f, 0.75f);
                this.mRender.setIcon(TypeEjectionTube.endIcon, TypeEjectionTube.endIcon, TypeFluidExtractionTube.icon, TypeFluidExtractionTube.icon, TypeFluidExtractionTube.icon, TypeFluidExtractionTube.icon);
                this.mRender.drawBox(63, 0.1875f, 0.9375f, 0.1875f, 0.8125f, 1.0f, 0.8125f);
                break;
            }
            case 2: {
                this.mRender.setTextureRotation(0, 0, 0, 0, 1, 1);
                this.mRender.drawBox(51, 0.25f, 0.25f, 0.0f, 0.75f, 0.75f, 0.25f);
                this.mRender.setIcon(TypeFluidExtractionTube.icon, TypeFluidExtractionTube.icon, TypeEjectionTube.endIcon, TypeEjectionTube.endIcon, TypeFluidExtractionTube.icon, TypeFluidExtractionTube.icon);
                this.mRender.drawBox(63, 0.1875f, 0.1875f, 0.0f, 0.8125f, 0.8125f, 0.0625f);
                break;
            }
            case 3: {
                this.mRender.setTextureRotation(0, 0, 0, 0, 1, 1);
                this.mRender.drawBox(51, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f, 1.0f);
                this.mRender.setIcon(TypeFluidExtractionTube.icon, TypeFluidExtractionTube.icon, TypeEjectionTube.endIcon, TypeEjectionTube.endIcon, TypeFluidExtractionTube.icon, TypeFluidExtractionTube.icon);
                this.mRender.drawBox(63, 0.1875f, 0.1875f, 0.9375f, 0.8125f, 0.8125f, 1.0f);
                break;
            }
            case 4: {
                this.mRender.setTextureRotation(1, 1, 1, 1, 0, 0);
                this.mRender.drawBox(15, 0.0f, 0.25f, 0.25f, 0.25f, 0.75f, 0.75f);
                this.mRender.setIcon(TypeFluidExtractionTube.icon, TypeFluidExtractionTube.icon, TypeFluidExtractionTube.icon, TypeFluidExtractionTube.icon, TypeEjectionTube.endIcon, TypeEjectionTube.endIcon);
                this.mRender.drawBox(63, 0.0f, 0.1875f, 0.1875f, 0.0625f, 0.8125f, 0.8125f);
                break;
            }
            case 5: {
                this.mRender.setTextureRotation(1, 1, 1, 1, 0, 0);
                this.mRender.drawBox(15, 0.75f, 0.25f, 0.25f, 1.0f, 0.75f, 0.75f);
                this.mRender.setIcon(TypeFluidExtractionTube.icon, TypeFluidExtractionTube.icon, TypeFluidExtractionTube.icon, TypeFluidExtractionTube.icon, TypeEjectionTube.endIcon, TypeEjectionTube.endIcon);
                this.mRender.drawBox(63, 0.9375f, 0.1875f, 0.1875f, 1.0f, 0.8125f, 0.8125f);
            }
        }
        this.mRender.resetTextureRotation();
    }

    private void renderPump(int side, float animTime) {
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TypeFluidExtractionTube.pumpTexture);
        this.mRender.setTextureIndex(0);
        this.mRender.setTextureSize(1, 1);
        Tessellator tes = Tessellator.field_78398_a;
        tes.func_78386_a(1.0f, 1.0f, 1.0f);
        tes.func_78382_b();
        float amount = ((float)Math.cos((double)animTime * Math.PI * 2.0) / 2.0f + 0.5f) * 0.0625f;
        this.mRender.resetTransform();
        switch (side) {
            case 0: {
                this.mRender.translate(0.0f, amount, 0.0f);
                this.mRender.drawBox(63, 0.1875f, 0.0625f, 0.1875f, 0.8125f, 0.125f, 0.8125f);
                break;
            }
            case 1: {
                this.mRender.translate(0.0f, -amount, 0.0f);
                this.mRender.drawBox(63, 0.1875f, 0.875f, 0.1875f, 0.8125f, 0.9375f, 0.8125f);
                break;
            }
            case 2: {
                this.mRender.translate(0.0f, 0.0f, amount);
                this.mRender.drawBox(63, 0.1875f, 0.1875f, 0.0625f, 0.8125f, 0.8125f, 0.125f);
                break;
            }
            case 3: {
                this.mRender.translate(0.0f, 0.0f, -amount);
                this.mRender.drawBox(63, 0.1875f, 0.1875f, 0.875f, 0.8125f, 0.8125f, 0.9375f);
                break;
            }
            case 4: {
                this.mRender.translate(amount, 0.0f, 0.0f);
                this.mRender.drawBox(63, 0.0625f, 0.1875f, 0.1875f, 0.125f, 0.8125f, 0.8125f);
                break;
            }
            case 5: {
                this.mRender.translate(-amount, 0.0f, 0.0f);
                this.mRender.drawBox(63, 0.875f, 0.1875f, 0.1875f, 0.9375f, 0.8125f, 0.8125f);
            }
        }
        tes.func_78381_a();
    }

    @Override
    public void renderItem(TubeDefinition type, ItemStack item) {
        this.mRender.resetTransform();
        this.mRender.enableNormals = true;
        this.mRender.resetTextureFlip();
        this.mRender.resetTextureRotation();
        this.mRender.resetLighting(0xF000F0);
        this.mRender.setLocalLights(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        Tessellator tes = Tessellator.field_78398_a;
        GL11.glDisable((int)2884);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        tes.func_78382_b();
        this.mRender.setIcon(type.getCenterIcon());
        this.mRender.drawBox(55, 0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
        this.renderExtractor(3);
        tes.func_78381_a();
        GL11.glEnable((int)2884);
        this.renderPump(3, (float)(System.currentTimeMillis() % 1000L) / 1000.0f);
    }

    @Override
    public void renderDynamic(TubeDefinition type, ITube tube, World world, int x, int y, int z, float frameTime) {
        int direction = ((IDirectionalTube)((Object)tube)).getFacing();
        this.mRender.resetTransform();
        this.mRender.enableNormals = false;
        this.mRender.setLightingFromBlock((IBlockAccess)world, x, y, z);
        this.mRender.resetTextureFlip();
        this.mRender.resetTextureRotation();
        this.mRender.faceMode = AdvRender.FaceMode.Normal;
        GL11.glDisable((int)2896);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        this.mRender.setLocalLights(0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f);
        this.renderPump(direction, ((ExtractionTube)tube).animTime + 0.05f * frameTime);
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        super.renderDynamic(type, tube, world, x, y, z, frameTime);
    }
}

