/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.network;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.vec.BlockCoord;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class MCDInputBridge
implements MCDataInput {
    private ByteBuf mBuffer;

    public MCDInputBridge(ByteBuf buf) {
        this.mBuffer = buf;
    }

    public boolean readBoolean() {
        return this.mBuffer.readBoolean();
    }

    public byte readByte() {
        return this.mBuffer.readByte();
    }

    public short readUByte() {
        return this.mBuffer.readUnsignedByte();
    }

    public byte[] readByteArray(int size) {
        byte[] bytes = new byte[size];
        this.mBuffer.readBytes(bytes);
        return bytes;
    }

    public char readChar() {
        return this.mBuffer.readChar();
    }

    public BlockCoord readCoord() {
        return new BlockCoord(this.readInt(), this.readInt(), this.readInt());
    }

    public double readDouble() {
        return this.mBuffer.readDouble();
    }

    public float readFloat() {
        return this.mBuffer.readFloat();
    }

    public FluidStack readFluidStack() {
        short id = this.readShort();
        if (id == -1) {
            return null;
        }
        int amount = this.readInt();
        NBTTagCompound tag = this.readNBTTagCompound();
        return new FluidStack((int)id, amount, tag);
    }

    public int readInt() {
        return this.mBuffer.readInt();
    }

    public ItemStack readItemStack() {
        short id = this.readShort();
        if (id == -1) {
            return null;
        }
        byte size = this.readByte();
        short damage = this.readShort();
        NBTTagCompound tag = this.readNBTTagCompound();
        ItemStack item = new ItemStack(Item.func_150899_d((int)id), (int)size, (int)damage);
        item.func_77982_d(tag);
        return item;
    }

    public long readLong() {
        return this.mBuffer.readLong();
    }

    public NBTTagCompound readNBTTagCompound() {
        short length = this.readShort();
        if (length == -1) {
            return null;
        }
        byte[] data = this.readByteArray(length);
        try {
            return CompressedStreamTools.func_74792_a((byte[])data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public short readShort() {
        return this.mBuffer.readShort();
    }

    public int readUShort() {
        return this.mBuffer.readUnsignedShort();
    }

    public String readString() {
        short size = this.readShort();
        char[] chars = new char[size];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = this.readChar();
        }
        return new String(chars);
    }

    public int readVarInt() {
        byte temp;
        int value = 0;
        int spot = 0;
        do {
            temp = this.readByte();
            value |= (temp & 0x7F) << spot++ * 7;
        } while ((temp & 0x80) == 128);
        return value;
    }

    public int readVarShort() {
        int low = this.readUShort();
        int high = 0;
        if ((low & 0x8000) != 0) {
            low &= Short.MAX_VALUE;
            high = this.readUShort();
        }
        return (high & 0xFF) << 15 | low;
    }
}

